/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.Inventory;
import travel.wink.sdk.extranet.model.InventoryUpdateRequest;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.PageInventory;
import travel.wink.sdk.extranet.model.SelectableKeyValuePair;
import travel.wink.sdk.extranet.model.State;

public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec linkChannelInventoryWithSalesChannelRequestCreation(String hotelIdentifier, Inventory inventory) throws WebClientResponseException {
        Inventory postBody = inventory;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling linkChannelInventoryWithSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventory == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventory' when calling linkChannelInventoryWithSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Inventory> linkChannelInventoryWithSalesChannel(String hotelIdentifier, Inventory inventory) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.linkChannelInventoryWithSalesChannelRequestCreation(hotelIdentifier, inventory).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Inventory>> linkChannelInventoryWithSalesChannelWithHttpInfo(String hotelIdentifier, Inventory inventory) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.linkChannelInventoryWithSalesChannelRequestCreation(hotelIdentifier, inventory).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelActivitiesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelActivities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/activity/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelActivities(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelActivitiesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelActivitiesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelActivitiesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelAddOnsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelAddOns", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/addon/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelAddOns(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelAddOnsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelAddOnsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelAddOnsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelAttractionsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelAttractions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/attraction/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelAttractions(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelAttractionsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelAttractionsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelAttractionsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelMeetingRoomsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelMeetingRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/meetingroom/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelMeetingRooms(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelMeetingRoomsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelMeetingRoomsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelMeetingRoomsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelPackagesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelPackages", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/package/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelPackages(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelPackagesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelPackagesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelPackagesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelPlacesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelPlaces", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/place/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelPlaces(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelPlacesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelPlacesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelPlacesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelRestaurantsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelRestaurants", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/restaurant/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelRestaurants(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelRestaurantsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelRestaurantsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelRestaurantsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelSpasRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelSpas", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/spa/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showChannelSpas(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelSpasRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showChannelSpasWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showChannelSpasRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryRequestCreation(String hotelIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/{inventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Inventory> showInventory(String hotelIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.showInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Inventory>> showInventoryWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.showInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryListRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Inventory> showInventoryList(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.showInventoryListRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Inventory>>> showInventoryListWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.showInventoryListRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryNamesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventoryNames", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/name/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<String> showInventoryNames(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryNamesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showInventoryNamesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryNamesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryTypesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventoryTypes", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/type/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<String> showInventoryTypes(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryTypesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showInventoryTypesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryTypesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showMasterRatesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/guestroom/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showMasterRates(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showMasterRatesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showMasterRatesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showMasterRatesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPageableChannelInventoryRequestCreation(String hotelIdentifier, State state) throws WebClientResponseException {
        State postBody = state;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPageableChannelInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showPageableChannelInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageInventory> localVarReturnType = new ParameterizedTypeReference<PageInventory>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventory> showPageableChannelInventory(String hotelIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventory> localVarReturnType = new ParameterizedTypeReference<PageInventory>(){};
        return this.showPageableChannelInventoryRequestCreation(hotelIdentifier, state).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventory>> showPageableChannelInventoryWithHttpInfo(String hotelIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventory> localVarReturnType = new ParameterizedTypeReference<PageInventory>(){};
        return this.showPageableChannelInventoryRequestCreation(hotelIdentifier, state).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSalesChannelListByInventoryRequestCreation(String hotelIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelListByInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showSalesChannelListByInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/{inventoryIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePair> showSalesChannelListByInventory(String hotelIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.showSalesChannelListByInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePair>>> showSalesChannelListByInventoryWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>(){};
        return this.showSalesChannelListByInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec toggleInventoryAvailabilityRequestCreation(String hotelIdentifier, String inventoryIdentifier, InventoryUpdateRequest inventoryUpdateRequest) throws WebClientResponseException {
        InventoryUpdateRequest postBody = inventoryUpdateRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleInventoryAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling toggleInventoryAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequest' when calling toggleInventoryAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/{inventoryIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Inventory> toggleInventoryAvailability(String hotelIdentifier, String inventoryIdentifier, InventoryUpdateRequest inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.toggleInventoryAvailabilityRequestCreation(hotelIdentifier, inventoryIdentifier, inventoryUpdateRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Inventory>> toggleInventoryAvailabilityWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, InventoryUpdateRequest inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.toggleInventoryAvailabilityRequestCreation(hotelIdentifier, inventoryIdentifier, inventoryUpdateRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec toggleInventoryListAvailabilityRequestCreation(String hotelIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        List<InventoryUpdateRequest> postBody = inventoryUpdateRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleInventoryListAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequest' when calling toggleInventoryListAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Inventory> toggleInventoryListAvailability(String hotelIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.toggleInventoryListAvailabilityRequestCreation(hotelIdentifier, inventoryUpdateRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Inventory>>> toggleInventoryListAvailabilityWithHttpInfo(String hotelIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Inventory> localVarReturnType = new ParameterizedTypeReference<Inventory>(){};
        return this.toggleInventoryListAvailabilityRequestCreation(hotelIdentifier, inventoryUpdateRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

