/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.ChildDescriptive;

@ApiModel(description="Room Configuration")
@JsonPropertyOrder(value={"adults", "children"})
@JsonTypeName(value="RoomConfiguration_Descriptive")
public class RoomConfigurationDescriptive {
    public static final String JSON_PROPERTY_ADULTS = "adults";
    private Integer adults;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<ChildDescriptive> children = null;

    public RoomConfigurationDescriptive adults(Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(required=true, value="Number of adults")
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdults(Integer adults) {
        this.adults = adults;
    }

    public RoomConfigurationDescriptive children(List<ChildDescriptive> children) {
        this.children = children;
        return this;
    }

    public RoomConfigurationDescriptive addChildrenItem(ChildDescriptive childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<ChildDescriptive>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Children configurations")
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ChildDescriptive> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(List<ChildDescriptive> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomConfigurationDescriptive roomConfigurationDescriptive = (RoomConfigurationDescriptive)o;
        return Objects.equals(this.adults, roomConfigurationDescriptive.adults) && Objects.equals(this.children, roomConfigurationDescriptive.children);
    }

    public int hashCode() {
        return Objects.hash(this.adults, this.children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomConfigurationDescriptive {\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

