/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"stars", "localName", "hotelChain", "hotelBrand", "whenBuilt", "licenseNumber", "locationCategory", "segmentCategory", "hotelCategory", "architecturalStyle"})
public class UpsertPropertyProfileRequest {
    public static final String JSON_PROPERTY_STARS = "stars";
    private Integer stars;
    public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
    private String localName;
    public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
    private String hotelChain;
    public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
    private String hotelBrand;
    public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
    private String whenBuilt;
    public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
    private String licenseNumber;
    public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
    private String locationCategory;
    public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
    private String segmentCategory;
    public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
    private String hotelCategory;
    public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
    private String architecturalStyle;

    public UpsertPropertyProfileRequest stars(Integer stars) {
        this.stars = stars;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @Max(value=6L)
    @ApiModelProperty(example="4", required=true, value="Hotel star rating.")
    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) @Max(value=6L) Integer getStars() {
        return this.stars;
    }

    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStars(Integer stars) {
        this.stars = stars;
    }

    public UpsertPropertyProfileRequest localName(String localName) {
        this.localName = localName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Resor Ubud Getaway", value="Name of the hotel in its local language if you use it for domestic guests.")
    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalName() {
        return this.localName;
    }

    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public UpsertPropertyProfileRequest hotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Getaway Resorts", value="Hotel chain name if property is part of that chain.")
    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelChain() {
        return this.hotelChain;
    }

    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
    }

    public UpsertPropertyProfileRequest hotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Happy Resorts", value="Hotel brand name if property is part of that brand.")
    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelBrand() {
        return this.hotelBrand;
    }

    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
    }

    public UpsertPropertyProfileRequest whenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1927", value="Year the property was constructed.")
    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhenBuilt() {
        return this.whenBuilt;
    }

    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
    }

    public UpsertPropertyProfileRequest licenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC1234", value="If the property has a valid license number to run a hotel in their country, add it here.")
    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public UpsertPropertyProfileRequest locationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="34", required=true, value="Supported OTA specification `LOC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocationCategory() {
        return this.locationCategory;
    }

    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
    }

    public UpsertPropertyProfileRequest segmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="7", required=true, value="Supported OTA specification `SEG` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSegmentCategory() {
        return this.segmentCategory;
    }

    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSegmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
    }

    public UpsertPropertyProfileRequest hotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="45", required=true, value="Supported OTA specification `PCT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelCategory() {
        return this.hotelCategory;
    }

    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
    }

    public UpsertPropertyProfileRequest architecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="7", required=true, value="Supported OTA specification `ARC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getArchitecturalStyle() {
        return this.architecturalStyle;
    }

    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setArchitecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertPropertyProfileRequest upsertPropertyProfileRequest = (UpsertPropertyProfileRequest)o;
        return Objects.equals(this.stars, upsertPropertyProfileRequest.stars) && Objects.equals(this.localName, upsertPropertyProfileRequest.localName) && Objects.equals(this.hotelChain, upsertPropertyProfileRequest.hotelChain) && Objects.equals(this.hotelBrand, upsertPropertyProfileRequest.hotelBrand) && Objects.equals(this.whenBuilt, upsertPropertyProfileRequest.whenBuilt) && Objects.equals(this.licenseNumber, upsertPropertyProfileRequest.licenseNumber) && Objects.equals(this.locationCategory, upsertPropertyProfileRequest.locationCategory) && Objects.equals(this.segmentCategory, upsertPropertyProfileRequest.segmentCategory) && Objects.equals(this.hotelCategory, upsertPropertyProfileRequest.hotelCategory) && Objects.equals(this.architecturalStyle, upsertPropertyProfileRequest.architecturalStyle);
    }

    public int hashCode() {
        return Objects.hash(this.stars, this.localName, this.hotelChain, this.hotelBrand, this.whenBuilt, this.licenseNumber, this.locationCategory, this.segmentCategory, this.hotelCategory, this.architecturalStyle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertPropertyProfileRequest {\n");
        sb.append("    stars: ").append(this.toIndentedString(this.stars)).append("\n");
        sb.append("    localName: ").append(this.toIndentedString(this.localName)).append("\n");
        sb.append("    hotelChain: ").append(this.toIndentedString(this.hotelChain)).append("\n");
        sb.append("    hotelBrand: ").append(this.toIndentedString(this.hotelBrand)).append("\n");
        sb.append("    whenBuilt: ").append(this.toIndentedString(this.whenBuilt)).append("\n");
        sb.append("    licenseNumber: ").append(this.toIndentedString(this.licenseNumber)).append("\n");
        sb.append("    locationCategory: ").append(this.toIndentedString(this.locationCategory)).append("\n");
        sb.append("    segmentCategory: ").append(this.toIndentedString(this.segmentCategory)).append("\n");
        sb.append("    hotelCategory: ").append(this.toIndentedString(this.hotelCategory)).append("\n");
        sb.append("    architecturalStyle: ").append(this.toIndentedString(this.architecturalStyle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

