package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CreateScheduleItemRequest;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import java.time.OffsetDateTime;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ScheduleItemView;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpdateScheduleItemRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:27:39.414751+07:00[Asia/Bangkok]")
public class SchedulerApi {
    private ApiClient apiClient;

    public SchedulerApi() {
        this(new ApiClient());
    }

    @Autowired
    public SchedulerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Scheduler Item
     * Create a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Create a calendar item for travel inventory with this identifier
     * @param createScheduleItemRequest The createScheduleItemRequest parameter
     * @return ScheduleItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequest createScheduleItemRequest) throws WebClientResponseException {
        Object postBody = createScheduleItemRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createScheduleItemRequest' is set
        if (createScheduleItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createScheduleItemRequest' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Scheduler Item
     * Create a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Create a calendar item for travel inventory with this identifier
     * @param createScheduleItemRequest The createScheduleItemRequest parameter
     * @return ScheduleItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ScheduleItemView> createScheduleItem(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequest createScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return createScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, createScheduleItemRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ScheduleItemView>> createScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequest createScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return createScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, createScheduleItemRequest).toEntity(localVarReturnType);
    }
    /**
     * Delete Scheduler Item
     * Delete a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Remove a calendar item for travel inventory with this identifier
     * @param identifier Remove a calendar item with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, String identifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Scheduler Item
     * Delete a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Remove a calendar item for travel inventory with this identifier
     * @param identifier Remove a calendar item with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeScheduleItem(String hotelIdentifier, String inventoryIdentifier, String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String identifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Scheduler Items
     * Retrieve list of calendar items for a meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show calendar items for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Show calendar items for travel inventory with this identifier
     * @param start Specify start date range
     * @param end Specify end date range
     * @param accept The accept parameter
     * @return List&lt;ScheduleItemView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showScheduleItemsRequestCreation(String hotelIdentifier, String inventoryIdentifier, OffsetDateTime start, OffsetDateTime end, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'start' is set
        if (start == null) {
            throw new WebClientResponseException("Missing the required parameter 'start' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'end' is set
        if (end == null) {
            throw new WebClientResponseException("Missing the required parameter 'end' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "end", end));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Scheduler Items
     * Retrieve list of calendar items for a meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show calendar items for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Show calendar items for travel inventory with this identifier
     * @param start Specify start date range
     * @param end Specify end date range
     * @param accept The accept parameter
     * @return List&lt;ScheduleItemView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ScheduleItemView> showScheduleItems(String hotelIdentifier, String inventoryIdentifier, OffsetDateTime start, OffsetDateTime end, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return showScheduleItemsRequestCreation(hotelIdentifier, inventoryIdentifier, start, end, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<ScheduleItemView>>> showScheduleItemsWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, OffsetDateTime start, OffsetDateTime end, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return showScheduleItemsRequestCreation(hotelIdentifier, inventoryIdentifier, start, end, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Scheduler Item
     * Update an existing calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Update a calendar item for travel inventory with this identifier
     * @param identifier Update a calendar item with this identifier
     * @param updateScheduleItemRequest The updateScheduleItemRequest parameter
     * @return ScheduleItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequest updateScheduleItemRequest) throws WebClientResponseException {
        Object postBody = updateScheduleItemRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateScheduleItemRequest' is set
        if (updateScheduleItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateScheduleItemRequest' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Scheduler Item
     * Update an existing calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Update a calendar item for travel inventory with this identifier
     * @param identifier Update a calendar item with this identifier
     * @param updateScheduleItemRequest The updateScheduleItemRequest parameter
     * @return ScheduleItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ScheduleItemView> updateScheduleItem(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequest updateScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return updateScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ScheduleItemView>> updateScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequest updateScheduleItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemView> localVarReturnType = new ParameterizedTypeReference<ScheduleItemView>() {};
        return updateScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequest).toEntity(localVarReturnType);
    }
}
