/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.8.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import travel.wink.sdk.extranet.model.Personal;
import travel.wink.sdk.extranet.model.Preferences;
import travel.wink.sdk.extranet.model.ProfileUser;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A user profile accompanies this booking IF user has created and enabled sharing of profile
 */
@ApiModel(description = "A user profile accompanies this booking IF user has created and enabled sharing of profile")
@JsonPropertyOrder({
  Profile.JSON_PROPERTY_PROFILE_IDENTIFIER,
  Profile.JSON_PROPERTY_USER_IDENTIFIER,
  Profile.JSON_PROPERTY_SHARE,
  Profile.JSON_PROPERTY_USER,
  Profile.JSON_PROPERTY_PERSONAL,
  Profile.JSON_PROPERTY_PREFERENCES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:27:39.414751+07:00[Asia/Bangkok]")
public class Profile {
  public static final String JSON_PROPERTY_PROFILE_IDENTIFIER = "profileIdentifier";
  private UUID profileIdentifier;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_SHARE = "share";
  private Boolean share;

  public static final String JSON_PROPERTY_USER = "user";
  private ProfileUser user;

  public static final String JSON_PROPERTY_PERSONAL = "personal";
  private Personal personal;

  public static final String JSON_PROPERTY_PREFERENCES = "preferences";
  private Preferences preferences;

  public Profile() { 
  }

  public Profile profileIdentifier(UUID profileIdentifier) {
    
    this.profileIdentifier = profileIdentifier;
    return this;
  }

   /**
   * Profile identifier
   * @return profileIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Profile identifier")
  @JsonProperty(JSON_PROPERTY_PROFILE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getProfileIdentifier() {
    return profileIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfileIdentifier(UUID profileIdentifier) {
    this.profileIdentifier = profileIdentifier;
  }


  public Profile userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * User identifier
   * @return userIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "User identifier")
  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public Profile share(Boolean share) {
    
    this.share = share;
    return this;
  }

   /**
   * Indicates whether the user wants to share this profile of themselves with hotel(s)
   * @return share
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Indicates whether the user wants to share this profile of themselves with hotel(s)")
  @JsonProperty(JSON_PROPERTY_SHARE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShare() {
    return share;
  }


  @JsonProperty(JSON_PROPERTY_SHARE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShare(Boolean share) {
    this.share = share;
  }


  public Profile user(ProfileUser user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProfileUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(ProfileUser user) {
    this.user = user;
  }


  public Profile personal(Personal personal) {
    
    this.personal = personal;
    return this;
  }

   /**
   * Get personal
   * @return personal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PERSONAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Personal getPersonal() {
    return personal;
  }


  @JsonProperty(JSON_PROPERTY_PERSONAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPersonal(Personal personal) {
    this.personal = personal;
  }


  public Profile preferences(Preferences preferences) {
    
    this.preferences = preferences;
    return this;
  }

   /**
   * Get preferences
   * @return preferences
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Preferences getPreferences() {
    return preferences;
  }


  @JsonProperty(JSON_PROPERTY_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferences(Preferences preferences) {
    this.preferences = preferences;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Profile profile = (Profile) o;
    return Objects.equals(this.profileIdentifier, profile.profileIdentifier) &&
        Objects.equals(this.userIdentifier, profile.userIdentifier) &&
        Objects.equals(this.share, profile.share) &&
        Objects.equals(this.user, profile.user) &&
        Objects.equals(this.personal, profile.personal) &&
        Objects.equals(this.preferences, profile.preferences);
  }

  @Override
  public int hashCode() {
    return Objects.hash(profileIdentifier, userIdentifier, share, user, personal, preferences);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Profile {\n");
    sb.append("    profileIdentifier: ").append(toIndentedString(profileIdentifier)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    share: ").append(toIndentedString(share)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    personal: ").append(toIndentedString(personal)).append("\n");
    sb.append("    preferences: ").append(toIndentedString(preferences)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

