/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.8.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertCancellationPolicyRequest
 */
@JsonPropertyOrder({
  UpsertCancellationPolicyRequest.JSON_PROPERTY_REFUNDABLE,
  UpsertCancellationPolicyRequest.JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE,
  UpsertCancellationPolicyRequest.JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE,
  UpsertCancellationPolicyRequest.JSON_PROPERTY_NO_SHOW_CHARGE,
  UpsertCancellationPolicyRequest.JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE,
  UpsertCancellationPolicyRequest.JSON_PROPERTY_NON_REFUNDABLE_DEADLINE,
  UpsertCancellationPolicyRequest.JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:27:39.414751+07:00[Asia/Bangkok]")
public class UpsertCancellationPolicyRequest {
  public static final String JSON_PROPERTY_REFUNDABLE = "refundable";
  private Boolean refundable = false;

  /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   */
  public enum AdvanceCancellationFreeOfChargeEnum {
    UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL("UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL"),
    
    UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL("UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL"),
    
    ONE_DAY_BEFORE_ARRIVAL("ONE_DAY_BEFORE_ARRIVAL"),
    
    TWO_DAYS_BEFORE_ARRIVAL("TWO_DAYS_BEFORE_ARRIVAL"),
    
    THREE_DAYS_BEFORE_ARRIVAL("THREE_DAYS_BEFORE_ARRIVAL"),
    
    FIVE_DAYS_BEFORE_ARRIVAL("FIVE_DAYS_BEFORE_ARRIVAL"),
    
    SEVEN_DAYS_BEFORE_ARRIVAL("SEVEN_DAYS_BEFORE_ARRIVAL"),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL("FOURTEEN_DAYS_BEFORE_ARRIVAL"),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL("TWENTYONE_DAYS_BEFORE_ARRIVAL"),
    
    THIRTY_DAYS_BEFORE_ARRIVAL("THIRTY_DAYS_BEFORE_ARRIVAL"),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL("FOURTY_TWO_DAYS_BEFORE_ARRIVAL"),
    
    SIXTY_DAYS_BEFORE_ARRIVAL("SIXTY_DAYS_BEFORE_ARRIVAL");

    private String value;

    AdvanceCancellationFreeOfChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdvanceCancellationFreeOfChargeEnum fromValue(String value) {
      for (AdvanceCancellationFreeOfChargeEnum b : AdvanceCancellationFreeOfChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE = "advanceCancellationFreeOfCharge";
  private AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge;

  /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   */
  public enum RefundableCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SIXTY_PERCENT("SIXTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT"),
    
    NINENTY_PERCENT("NINENTY_PERCENT"),
    
    ONE_HUNDRED_PERCENT("ONE_HUNDRED_PERCENT");

    private String value;

    RefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundableCancellationChargeEnum fromValue(String value) {
      for (RefundableCancellationChargeEnum b : RefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE = "refundableCancellationCharge";
  private RefundableCancellationChargeEnum refundableCancellationCharge;

  /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   */
  public enum NoShowChargeEnum {
    SAME_AS_CANCELLATION_FEE("SAME_AS_CANCELLATION_FEE"),
    
    ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE("ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE");

    private String value;

    NoShowChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NoShowChargeEnum fromValue(String value) {
      for (NoShowChargeEnum b : NoShowChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NO_SHOW_CHARGE = "noShowCharge";
  private NoShowChargeEnum noShowCharge;

  /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   */
  public enum NonRefundableCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    TEN_PERCENT("TEN_PERCENT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT");

    private String value;

    NonRefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableCancellationChargeEnum fromValue(String value) {
      for (NonRefundableCancellationChargeEnum b : NonRefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE = "nonRefundableCancellationCharge";
  private NonRefundableCancellationChargeEnum nonRefundableCancellationCharge;

  /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   */
  public enum NonRefundableDeadlineEnum {
    ONE_DAY_BEFORE_ARRIVAL("ONE_DAY_BEFORE_ARRIVAL"),
    
    TWO_DAYS_BEFORE_ARRIVAL("TWO_DAYS_BEFORE_ARRIVAL"),
    
    THREE_DAYS_BEFORE_ARRIVAL("THREE_DAYS_BEFORE_ARRIVAL"),
    
    FIVE_DAYS_BEFORE_ARRIVAL("FIVE_DAYS_BEFORE_ARRIVAL"),
    
    SEVEN_DAYS_BEFORE_ARRIVAL("SEVEN_DAYS_BEFORE_ARRIVAL"),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL("FOURTEEN_DAYS_BEFORE_ARRIVAL"),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL("TWENTYONE_DAYS_BEFORE_ARRIVAL"),
    
    THIRTY_DAYS_BEFORE_ARRIVAL("THIRTY_DAYS_BEFORE_ARRIVAL"),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL("FOURTY_TWO_DAYS_BEFORE_ARRIVAL"),
    
    SIXTY_DAYS_BEFORE_ARRIVAL("SIXTY_DAYS_BEFORE_ARRIVAL");

    private String value;

    NonRefundableDeadlineEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableDeadlineEnum fromValue(String value) {
      for (NonRefundableDeadlineEnum b : NonRefundableDeadlineEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_DEADLINE = "nonRefundableDeadline";
  private NonRefundableDeadlineEnum nonRefundableDeadline;

  /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   */
  public enum NonRefundableAfterDeadlineCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    TEN_PERCENT("TEN_PERCENT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT"),
    
    ONE_HUNDRED_PERCENT("ONE_HUNDRED_PERCENT");

    private String value;

    NonRefundableAfterDeadlineCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableAfterDeadlineCancellationChargeEnum fromValue(String value) {
      for (NonRefundableAfterDeadlineCancellationChargeEnum b : NonRefundableAfterDeadlineCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE = "nonRefundableAfterDeadlineCancellationCharge";
  private NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge;

  public UpsertCancellationPolicyRequest() { 
  }

  public UpsertCancellationPolicyRequest refundable(Boolean refundable) {
    
    this.refundable = refundable;
    return this;
  }

   /**
   * Whether this cancellation policy is refundable or not
   * @return refundable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Whether this cancellation policy is refundable or not")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getRefundable() {
    return refundable;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefundable(Boolean refundable) {
    this.refundable = refundable;
  }


  public UpsertCancellationPolicyRequest advanceCancellationFreeOfCharge(AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
    return this;
  }

   /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   * @return advanceCancellationFreeOfCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL", value = "When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.")
  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceCancellationFreeOfChargeEnum getAdvanceCancellationFreeOfCharge() {
    return advanceCancellationFreeOfCharge;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceCancellationFreeOfCharge(AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
  }


  public UpsertCancellationPolicyRequest refundableCancellationCharge(RefundableCancellationChargeEnum refundableCancellationCharge) {
    
    this.refundableCancellationCharge = refundableCancellationCharge;
    return this;
  }

   /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   * @return refundableCancellationCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "FIFTY_PERCENT", value = "If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableCancellationChargeEnum getRefundableCancellationCharge() {
    return refundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableCancellationCharge(RefundableCancellationChargeEnum refundableCancellationCharge) {
    this.refundableCancellationCharge = refundableCancellationCharge;
  }


  public UpsertCancellationPolicyRequest noShowCharge(NoShowChargeEnum noShowCharge) {
    
    this.noShowCharge = noShowCharge;
    return this;
  }

   /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   * @return noShowCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SAME_AS_CANCELLATION_FEE", value = "In case the 'Refundable cancellation charge' is set, a different no show charge can be applied.")
  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NoShowChargeEnum getNoShowCharge() {
    return noShowCharge;
  }


  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoShowCharge(NoShowChargeEnum noShowCharge) {
    this.noShowCharge = noShowCharge;
  }


  public UpsertCancellationPolicyRequest nonRefundableCancellationCharge(NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
    return this;
  }

   /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   * @return nonRefundableCancellationCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SEVENTY_PERCENT", value = "When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.")
  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableCancellationChargeEnum getNonRefundableCancellationCharge() {
    return nonRefundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableCancellationCharge(NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
  }


  public UpsertCancellationPolicyRequest nonRefundableDeadline(NonRefundableDeadlineEnum nonRefundableDeadline) {
    
    this.nonRefundableDeadline = nonRefundableDeadline;
    return this;
  }

   /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   * @return nonRefundableDeadline
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SEVEN_DAYS_BEFORE_ARRIVAL", value = "The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.")
  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableDeadlineEnum getNonRefundableDeadline() {
    return nonRefundableDeadline;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableDeadline(NonRefundableDeadlineEnum nonRefundableDeadline) {
    this.nonRefundableDeadline = nonRefundableDeadline;
  }


  public UpsertCancellationPolicyRequest nonRefundableAfterDeadlineCancellationCharge(NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
    return this;
  }

   /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   * @return nonRefundableAfterDeadlineCancellationCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ONE_HUNDRED_PERCENT", value = "If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.")
  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableAfterDeadlineCancellationChargeEnum getNonRefundableAfterDeadlineCancellationCharge() {
    return nonRefundableAfterDeadlineCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableAfterDeadlineCancellationCharge(NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertCancellationPolicyRequest upsertCancellationPolicyRequest = (UpsertCancellationPolicyRequest) o;
    return Objects.equals(this.refundable, upsertCancellationPolicyRequest.refundable) &&
        Objects.equals(this.advanceCancellationFreeOfCharge, upsertCancellationPolicyRequest.advanceCancellationFreeOfCharge) &&
        Objects.equals(this.refundableCancellationCharge, upsertCancellationPolicyRequest.refundableCancellationCharge) &&
        Objects.equals(this.noShowCharge, upsertCancellationPolicyRequest.noShowCharge) &&
        Objects.equals(this.nonRefundableCancellationCharge, upsertCancellationPolicyRequest.nonRefundableCancellationCharge) &&
        Objects.equals(this.nonRefundableDeadline, upsertCancellationPolicyRequest.nonRefundableDeadline) &&
        Objects.equals(this.nonRefundableAfterDeadlineCancellationCharge, upsertCancellationPolicyRequest.nonRefundableAfterDeadlineCancellationCharge);
  }

  @Override
  public int hashCode() {
    return Objects.hash(refundable, advanceCancellationFreeOfCharge, refundableCancellationCharge, noShowCharge, nonRefundableCancellationCharge, nonRefundableDeadline, nonRefundableAfterDeadlineCancellationCharge);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertCancellationPolicyRequest {\n");
    sb.append("    refundable: ").append(toIndentedString(refundable)).append("\n");
    sb.append("    advanceCancellationFreeOfCharge: ").append(toIndentedString(advanceCancellationFreeOfCharge)).append("\n");
    sb.append("    refundableCancellationCharge: ").append(toIndentedString(refundableCancellationCharge)).append("\n");
    sb.append("    noShowCharge: ").append(toIndentedString(noShowCharge)).append("\n");
    sb.append("    nonRefundableCancellationCharge: ").append(toIndentedString(nonRefundableCancellationCharge)).append("\n");
    sb.append("    nonRefundableDeadline: ").append(toIndentedString(nonRefundableDeadline)).append("\n");
    sb.append("    nonRefundableAfterDeadlineCancellationCharge: ").append(toIndentedString(nonRefundableAfterDeadlineCancellationCharge)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

