/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.KeyValuePair;

@ApiModel(description="Chart properties allow you to choose how to visualize available data points. Choose how you want to:   - filter your data  - sort your data  - group your data  - include data in your data sets  - display currency amounts")
@JsonPropertyOrder(value={"series", "timeSeriesUnits", "startDate", "endDate", "filterOnHotelIdentifier", "filterOnChannelSubType", "filterOnOwnerIdentifier", "filterOnEngineCountryGeoNameId", "filterOnEngineCityGeoNameId", "filterOnEngineContinentCode", "filterOnEngineConfigurationIdentifier", "filterOnCountryGeoNameId", "filterOnCityGeoNameId", "filterOnContinentCode", "filterOnUserIdentifier", "sortOnPageVisits", "sortOnMapMarkerVisits", "sortOnCardVisits", "sortOnBookings", "sortOnCancellations", "sortOnRoomNights", "sortOnMeetingRooms", "sortOnRestaurants", "sortOnSpas", "sortOnActivities", "sortOnAttractions", "sortOnPlaces", "sortOnPackages", "sortOnAddOns", "sortOnTotalRoomRevenue", "sortOnPackagesRevenue", "sortOnAddonsRevenue", "sortOnPackagesAndAddonsRevenue", "sortOnTotalNetRevenue", "sortOnCancelledRoomNights", "sortOnCancelledMeetingRooms", "sortOnCancelledRestaurants", "sortOnCancelledSpas", "sortOnCancelledActivities", "sortOnCancelledAttractions", "sortOnCancelledPlaces", "sortOnCancelledPackages", "sortOnCancelledAddOns", "sortOnCancelledTotalRoomRevenue", "sortOnCancelledPackagesAndAddonsRevenue", "sortOnCancelledPackagesRevenue", "sortOnCancelledAddonsRevenue", "sortOnCancelledTotalNetRevenue", "includePageVisits", "includeMapMarkerVisits", "includeCardVisits", "includeBookings", "includeCancellations", "includeRoomNights", "includeMeetingRooms", "includeRestaurants", "includeSpas", "includeActivities", "includeAttractions", "includePlaces", "includePackages", "includeAddOns", "includeTotalRoomRevenue", "includeAverageRoomRate", "includePackagesRevenue", "includeAddonsRevenue", "includePackagesAndAddonsRevenue", "includeTotalNetRevenue", "includeCancelledRoomNights", "includeCancelledMeetingRooms", "includeCancelledRestaurants", "includeCancelledSpas", "includeCancelledActivities", "includeCancelledAttractions", "includeCancelledPlaces", "includeCancelledPackages", "includeCancelledAddOns", "includeCancelledTotalRoomRevenue", "includeCancelledPackagesAndAddonsRevenue", "includeCancelledPackagesRevenue", "includeCancelledAddonsRevenue", "includeCancelledTotalNetRevenue", "groupOnChannelSubType", "groupOnOwnerIdentifier", "groupOnEngineIdentifier", "groupOnEngineCountryGeoNameId", "groupOnEngineCityGeoNameId", "groupOnEngineContinentCode", "groupOnEngineConfigurationIdentifier", "groupOnCountryGeoNameId", "groupOnCityGeoNameId", "groupOnContinentCode", "groupOnHotelIdentifier", "groupOnUserIdentifier", "currencyCode"})
public class ChartRequest {
    public static final String JSON_PROPERTY_SERIES = "series";
    private SeriesEnum series;
    public static final String JSON_PROPERTY_TIME_SERIES_UNITS = "timeSeriesUnits";
    private Long timeSeriesUnits;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private OffsetDateTime startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private OffsetDateTime endDate;
    public static final String JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER = "filterOnHotelIdentifier";
    private KeyValuePair filterOnHotelIdentifier;
    public static final String JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE = "filterOnChannelSubType";
    private FilterOnChannelSubTypeEnum filterOnChannelSubType;
    public static final String JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER = "filterOnOwnerIdentifier";
    private KeyValuePair filterOnOwnerIdentifier;
    public static final String JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID = "filterOnEngineCountryGeoNameId";
    private KeyValuePair filterOnEngineCountryGeoNameId;
    public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID = "filterOnEngineCityGeoNameId";
    private KeyValuePair filterOnEngineCityGeoNameId;
    public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE = "filterOnEngineContinentCode";
    private KeyValuePair filterOnEngineContinentCode;
    public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER = "filterOnEngineConfigurationIdentifier";
    private KeyValuePair filterOnEngineConfigurationIdentifier;
    public static final String JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID = "filterOnCountryGeoNameId";
    private KeyValuePair filterOnCountryGeoNameId;
    public static final String JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID = "filterOnCityGeoNameId";
    private KeyValuePair filterOnCityGeoNameId;
    public static final String JSON_PROPERTY_FILTER_ON_CONTINENT_CODE = "filterOnContinentCode";
    private KeyValuePair filterOnContinentCode;
    public static final String JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER = "filterOnUserIdentifier";
    private KeyValuePair filterOnUserIdentifier;
    public static final String JSON_PROPERTY_SORT_ON_PAGE_VISITS = "sortOnPageVisits";
    private Boolean sortOnPageVisits = false;
    public static final String JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS = "sortOnMapMarkerVisits";
    private Boolean sortOnMapMarkerVisits = false;
    public static final String JSON_PROPERTY_SORT_ON_CARD_VISITS = "sortOnCardVisits";
    private Boolean sortOnCardVisits = false;
    public static final String JSON_PROPERTY_SORT_ON_BOOKINGS = "sortOnBookings";
    private Boolean sortOnBookings = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLATIONS = "sortOnCancellations";
    private Boolean sortOnCancellations = false;
    public static final String JSON_PROPERTY_SORT_ON_ROOM_NIGHTS = "sortOnRoomNights";
    private Boolean sortOnRoomNights = false;
    public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS = "sortOnMeetingRooms";
    private Boolean sortOnMeetingRooms = false;
    public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS = "sortOnRestaurants";
    private Boolean sortOnRestaurants = false;
    public static final String JSON_PROPERTY_SORT_ON_SPAS = "sortOnSpas";
    private Boolean sortOnSpas = false;
    public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES = "sortOnActivities";
    private Boolean sortOnActivities = false;
    public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS = "sortOnAttractions";
    private Boolean sortOnAttractions = false;
    public static final String JSON_PROPERTY_SORT_ON_PLACES = "sortOnPlaces";
    private Boolean sortOnPlaces = false;
    public static final String JSON_PROPERTY_SORT_ON_PACKAGES = "sortOnPackages";
    private Boolean sortOnPackages = false;
    public static final String JSON_PROPERTY_SORT_ON_ADD_ONS = "sortOnAddOns";
    private Boolean sortOnAddOns = false;
    public static final String JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE = "sortOnTotalRoomRevenue";
    private Boolean sortOnTotalRoomRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_PACKAGES_REVENUE = "sortOnPackagesRevenue";
    private Boolean sortOnPackagesRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_ADDONS_REVENUE = "sortOnAddonsRevenue";
    private Boolean sortOnAddonsRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_PACKAGES_AND_ADDONS_REVENUE = "sortOnPackagesAndAddonsRevenue";
    private Boolean sortOnPackagesAndAddonsRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE = "sortOnTotalNetRevenue";
    private Boolean sortOnTotalNetRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS = "sortOnCancelledRoomNights";
    private Boolean sortOnCancelledRoomNights = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS = "sortOnCancelledMeetingRooms";
    private Boolean sortOnCancelledMeetingRooms = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS = "sortOnCancelledRestaurants";
    private Boolean sortOnCancelledRestaurants = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS = "sortOnCancelledSpas";
    private Boolean sortOnCancelledSpas = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES = "sortOnCancelledActivities";
    private Boolean sortOnCancelledActivities = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS = "sortOnCancelledAttractions";
    private Boolean sortOnCancelledAttractions = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES = "sortOnCancelledPlaces";
    private Boolean sortOnCancelledPlaces = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES = "sortOnCancelledPackages";
    private Boolean sortOnCancelledPackages = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS = "sortOnCancelledAddOns";
    private Boolean sortOnCancelledAddOns = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE = "sortOnCancelledTotalRoomRevenue";
    private Boolean sortOnCancelledTotalRoomRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_AND_ADDONS_REVENUE = "sortOnCancelledPackagesAndAddonsRevenue";
    private Boolean sortOnCancelledPackagesAndAddonsRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PACKAGES_REVENUE = "sortOnCancelledPackagesRevenue";
    private Boolean sortOnCancelledPackagesRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE = "sortOnCancelledAddonsRevenue";
    private Boolean sortOnCancelledAddonsRevenue = false;
    public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE = "sortOnCancelledTotalNetRevenue";
    private Boolean sortOnCancelledTotalNetRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_PAGE_VISITS = "includePageVisits";
    private Boolean includePageVisits = false;
    public static final String JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS = "includeMapMarkerVisits";
    private Boolean includeMapMarkerVisits = false;
    public static final String JSON_PROPERTY_INCLUDE_CARD_VISITS = "includeCardVisits";
    private Boolean includeCardVisits = false;
    public static final String JSON_PROPERTY_INCLUDE_BOOKINGS = "includeBookings";
    private Boolean includeBookings = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLATIONS = "includeCancellations";
    private Boolean includeCancellations = false;
    public static final String JSON_PROPERTY_INCLUDE_ROOM_NIGHTS = "includeRoomNights";
    private Boolean includeRoomNights = false;
    public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS = "includeMeetingRooms";
    private Boolean includeMeetingRooms = false;
    public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS = "includeRestaurants";
    private Boolean includeRestaurants = false;
    public static final String JSON_PROPERTY_INCLUDE_SPAS = "includeSpas";
    private Boolean includeSpas = false;
    public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES = "includeActivities";
    private Boolean includeActivities = false;
    public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS = "includeAttractions";
    private Boolean includeAttractions = false;
    public static final String JSON_PROPERTY_INCLUDE_PLACES = "includePlaces";
    private Boolean includePlaces = false;
    public static final String JSON_PROPERTY_INCLUDE_PACKAGES = "includePackages";
    private Boolean includePackages = false;
    public static final String JSON_PROPERTY_INCLUDE_ADD_ONS = "includeAddOns";
    private Boolean includeAddOns = false;
    public static final String JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE = "includeTotalRoomRevenue";
    private Boolean includeTotalRoomRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE = "includeAverageRoomRate";
    private Boolean includeAverageRoomRate = false;
    public static final String JSON_PROPERTY_INCLUDE_PACKAGES_REVENUE = "includePackagesRevenue";
    private Boolean includePackagesRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_ADDONS_REVENUE = "includeAddonsRevenue";
    private Boolean includeAddonsRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_PACKAGES_AND_ADDONS_REVENUE = "includePackagesAndAddonsRevenue";
    private Boolean includePackagesAndAddonsRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE = "includeTotalNetRevenue";
    private Boolean includeTotalNetRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS = "includeCancelledRoomNights";
    private Boolean includeCancelledRoomNights = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS = "includeCancelledMeetingRooms";
    private Boolean includeCancelledMeetingRooms = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS = "includeCancelledRestaurants";
    private Boolean includeCancelledRestaurants = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS = "includeCancelledSpas";
    private Boolean includeCancelledSpas = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES = "includeCancelledActivities";
    private Boolean includeCancelledActivities = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS = "includeCancelledAttractions";
    private Boolean includeCancelledAttractions = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES = "includeCancelledPlaces";
    private Boolean includeCancelledPlaces = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES = "includeCancelledPackages";
    private Boolean includeCancelledPackages = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS = "includeCancelledAddOns";
    private Boolean includeCancelledAddOns = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE = "includeCancelledTotalRoomRevenue";
    private Boolean includeCancelledTotalRoomRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_AND_ADDONS_REVENUE = "includeCancelledPackagesAndAddonsRevenue";
    private Boolean includeCancelledPackagesAndAddonsRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PACKAGES_REVENUE = "includeCancelledPackagesRevenue";
    private Boolean includeCancelledPackagesRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADDONS_REVENUE = "includeCancelledAddonsRevenue";
    private Boolean includeCancelledAddonsRevenue = false;
    public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE = "includeCancelledTotalNetRevenue";
    private Boolean includeCancelledTotalNetRevenue = false;
    public static final String JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE = "groupOnChannelSubType";
    private Boolean groupOnChannelSubType = false;
    public static final String JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER = "groupOnOwnerIdentifier";
    private Boolean groupOnOwnerIdentifier = false;
    public static final String JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER = "groupOnEngineIdentifier";
    private Boolean groupOnEngineIdentifier = false;
    public static final String JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID = "groupOnEngineCountryGeoNameId";
    private Boolean groupOnEngineCountryGeoNameId = false;
    public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID = "groupOnEngineCityGeoNameId";
    private Boolean groupOnEngineCityGeoNameId = false;
    public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE = "groupOnEngineContinentCode";
    private Boolean groupOnEngineContinentCode = false;
    public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER = "groupOnEngineConfigurationIdentifier";
    private Boolean groupOnEngineConfigurationIdentifier = false;
    public static final String JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID = "groupOnCountryGeoNameId";
    private Boolean groupOnCountryGeoNameId = false;
    public static final String JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID = "groupOnCityGeoNameId";
    private Boolean groupOnCityGeoNameId = false;
    public static final String JSON_PROPERTY_GROUP_ON_CONTINENT_CODE = "groupOnContinentCode";
    private Boolean groupOnContinentCode = false;
    public static final String JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER = "groupOnHotelIdentifier";
    private Boolean groupOnHotelIdentifier = false;
    public static final String JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER = "groupOnUserIdentifier";
    private Boolean groupOnUserIdentifier = false;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode = "USD";

    public ChartRequest series(SeriesEnum series) {
        this.series = series;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="HOUR", required=true, value="The time series to visualize")
    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SeriesEnum getSeries() {
        return this.series;
    }

    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSeries(SeriesEnum series) {
        this.series = series;
    }

    public ChartRequest timeSeriesUnits(Long timeSeriesUnits) {
        this.timeSeriesUnits = timeSeriesUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="24", value="How many units of the time series type to visualize. Only required if start / end date not populated.")
    @JsonProperty(value="timeSeriesUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimeSeriesUnits() {
        return this.timeSeriesUnits;
    }

    @JsonProperty(value="timeSeriesUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeSeriesUnits(Long timeSeriesUnits) {
        this.timeSeriesUnits = timeSeriesUnits;
    }

    public ChartRequest startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Fixed date to start visualizations on")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public ChartRequest endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Fixed date to end visualizations on")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public ChartRequest filterOnHotelIdentifier(KeyValuePair filterOnHotelIdentifier) {
        this.filterOnHotelIdentifier = filterOnHotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnHotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnHotelIdentifier() {
        return this.filterOnHotelIdentifier;
    }

    @JsonProperty(value="filterOnHotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnHotelIdentifier(KeyValuePair filterOnHotelIdentifier) {
        this.filterOnHotelIdentifier = filterOnHotelIdentifier;
    }

    public ChartRequest filterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
        this.filterOnChannelSubType = filterOnChannelSubType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="APPLICATION", value="Filter on channel sub type. What channel sub-type helped make the booking.")
    @JsonProperty(value="filterOnChannelSubType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterOnChannelSubTypeEnum getFilterOnChannelSubType() {
        return this.filterOnChannelSubType;
    }

    @JsonProperty(value="filterOnChannelSubType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
        this.filterOnChannelSubType = filterOnChannelSubType;
    }

    public ChartRequest filterOnOwnerIdentifier(KeyValuePair filterOnOwnerIdentifier) {
        this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnOwnerIdentifier() {
        return this.filterOnOwnerIdentifier;
    }

    @JsonProperty(value="filterOnOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnOwnerIdentifier(KeyValuePair filterOnOwnerIdentifier) {
        this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
    }

    public ChartRequest filterOnEngineCountryGeoNameId(KeyValuePair filterOnEngineCountryGeoNameId) {
        this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnEngineCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnEngineCountryGeoNameId() {
        return this.filterOnEngineCountryGeoNameId;
    }

    @JsonProperty(value="filterOnEngineCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnEngineCountryGeoNameId(KeyValuePair filterOnEngineCountryGeoNameId) {
        this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
    }

    public ChartRequest filterOnEngineCityGeoNameId(KeyValuePair filterOnEngineCityGeoNameId) {
        this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnEngineCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnEngineCityGeoNameId() {
        return this.filterOnEngineCityGeoNameId;
    }

    @JsonProperty(value="filterOnEngineCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnEngineCityGeoNameId(KeyValuePair filterOnEngineCityGeoNameId) {
        this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
    }

    public ChartRequest filterOnEngineContinentCode(KeyValuePair filterOnEngineContinentCode) {
        this.filterOnEngineContinentCode = filterOnEngineContinentCode;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnEngineContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnEngineContinentCode() {
        return this.filterOnEngineContinentCode;
    }

    @JsonProperty(value="filterOnEngineContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnEngineContinentCode(KeyValuePair filterOnEngineContinentCode) {
        this.filterOnEngineContinentCode = filterOnEngineContinentCode;
    }

    public ChartRequest filterOnEngineConfigurationIdentifier(KeyValuePair filterOnEngineConfigurationIdentifier) {
        this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnEngineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnEngineConfigurationIdentifier() {
        return this.filterOnEngineConfigurationIdentifier;
    }

    @JsonProperty(value="filterOnEngineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnEngineConfigurationIdentifier(KeyValuePair filterOnEngineConfigurationIdentifier) {
        this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
    }

    public ChartRequest filterOnCountryGeoNameId(KeyValuePair filterOnCountryGeoNameId) {
        this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnCountryGeoNameId() {
        return this.filterOnCountryGeoNameId;
    }

    @JsonProperty(value="filterOnCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnCountryGeoNameId(KeyValuePair filterOnCountryGeoNameId) {
        this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
    }

    public ChartRequest filterOnCityGeoNameId(KeyValuePair filterOnCityGeoNameId) {
        this.filterOnCityGeoNameId = filterOnCityGeoNameId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnCityGeoNameId() {
        return this.filterOnCityGeoNameId;
    }

    @JsonProperty(value="filterOnCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnCityGeoNameId(KeyValuePair filterOnCityGeoNameId) {
        this.filterOnCityGeoNameId = filterOnCityGeoNameId;
    }

    public ChartRequest filterOnContinentCode(KeyValuePair filterOnContinentCode) {
        this.filterOnContinentCode = filterOnContinentCode;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnContinentCode() {
        return this.filterOnContinentCode;
    }

    @JsonProperty(value="filterOnContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnContinentCode(KeyValuePair filterOnContinentCode) {
        this.filterOnContinentCode = filterOnContinentCode;
    }

    public ChartRequest filterOnUserIdentifier(KeyValuePair filterOnUserIdentifier) {
        this.filterOnUserIdentifier = filterOnUserIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="filterOnUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePair getFilterOnUserIdentifier() {
        return this.filterOnUserIdentifier;
    }

    @JsonProperty(value="filterOnUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterOnUserIdentifier(KeyValuePair filterOnUserIdentifier) {
        this.filterOnUserIdentifier = filterOnUserIdentifier;
    }

    public ChartRequest sortOnPageVisits(Boolean sortOnPageVisits) {
        this.sortOnPageVisits = sortOnPageVisits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Sort on page visits")
    @JsonProperty(value="sortOnPageVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnPageVisits() {
        return this.sortOnPageVisits;
    }

    @JsonProperty(value="sortOnPageVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnPageVisits(Boolean sortOnPageVisits) {
        this.sortOnPageVisits = sortOnPageVisits;
    }

    public ChartRequest sortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
        this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on map marker visits")
    @JsonProperty(value="sortOnMapMarkerVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnMapMarkerVisits() {
        return this.sortOnMapMarkerVisits;
    }

    @JsonProperty(value="sortOnMapMarkerVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
        this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
    }

    public ChartRequest sortOnCardVisits(Boolean sortOnCardVisits) {
        this.sortOnCardVisits = sortOnCardVisits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on card visits")
    @JsonProperty(value="sortOnCardVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCardVisits() {
        return this.sortOnCardVisits;
    }

    @JsonProperty(value="sortOnCardVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCardVisits(Boolean sortOnCardVisits) {
        this.sortOnCardVisits = sortOnCardVisits;
    }

    public ChartRequest sortOnBookings(Boolean sortOnBookings) {
        this.sortOnBookings = sortOnBookings;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on bookings")
    @JsonProperty(value="sortOnBookings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnBookings() {
        return this.sortOnBookings;
    }

    @JsonProperty(value="sortOnBookings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnBookings(Boolean sortOnBookings) {
        this.sortOnBookings = sortOnBookings;
    }

    public ChartRequest sortOnCancellations(Boolean sortOnCancellations) {
        this.sortOnCancellations = sortOnCancellations;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancellations")
    @JsonProperty(value="sortOnCancellations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancellations() {
        return this.sortOnCancellations;
    }

    @JsonProperty(value="sortOnCancellations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancellations(Boolean sortOnCancellations) {
        this.sortOnCancellations = sortOnCancellations;
    }

    public ChartRequest sortOnRoomNights(Boolean sortOnRoomNights) {
        this.sortOnRoomNights = sortOnRoomNights;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on room nights")
    @JsonProperty(value="sortOnRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnRoomNights() {
        return this.sortOnRoomNights;
    }

    @JsonProperty(value="sortOnRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnRoomNights(Boolean sortOnRoomNights) {
        this.sortOnRoomNights = sortOnRoomNights;
    }

    public ChartRequest sortOnMeetingRooms(Boolean sortOnMeetingRooms) {
        this.sortOnMeetingRooms = sortOnMeetingRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on meeting rooms")
    @JsonProperty(value="sortOnMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnMeetingRooms() {
        return this.sortOnMeetingRooms;
    }

    @JsonProperty(value="sortOnMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnMeetingRooms(Boolean sortOnMeetingRooms) {
        this.sortOnMeetingRooms = sortOnMeetingRooms;
    }

    public ChartRequest sortOnRestaurants(Boolean sortOnRestaurants) {
        this.sortOnRestaurants = sortOnRestaurants;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on restaurants")
    @JsonProperty(value="sortOnRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnRestaurants() {
        return this.sortOnRestaurants;
    }

    @JsonProperty(value="sortOnRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnRestaurants(Boolean sortOnRestaurants) {
        this.sortOnRestaurants = sortOnRestaurants;
    }

    public ChartRequest sortOnSpas(Boolean sortOnSpas) {
        this.sortOnSpas = sortOnSpas;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on spas")
    @JsonProperty(value="sortOnSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnSpas() {
        return this.sortOnSpas;
    }

    @JsonProperty(value="sortOnSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnSpas(Boolean sortOnSpas) {
        this.sortOnSpas = sortOnSpas;
    }

    public ChartRequest sortOnActivities(Boolean sortOnActivities) {
        this.sortOnActivities = sortOnActivities;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on activities")
    @JsonProperty(value="sortOnActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnActivities() {
        return this.sortOnActivities;
    }

    @JsonProperty(value="sortOnActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnActivities(Boolean sortOnActivities) {
        this.sortOnActivities = sortOnActivities;
    }

    public ChartRequest sortOnAttractions(Boolean sortOnAttractions) {
        this.sortOnAttractions = sortOnAttractions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on attractions")
    @JsonProperty(value="sortOnAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnAttractions() {
        return this.sortOnAttractions;
    }

    @JsonProperty(value="sortOnAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnAttractions(Boolean sortOnAttractions) {
        this.sortOnAttractions = sortOnAttractions;
    }

    public ChartRequest sortOnPlaces(Boolean sortOnPlaces) {
        this.sortOnPlaces = sortOnPlaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on places")
    @JsonProperty(value="sortOnPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnPlaces() {
        return this.sortOnPlaces;
    }

    @JsonProperty(value="sortOnPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnPlaces(Boolean sortOnPlaces) {
        this.sortOnPlaces = sortOnPlaces;
    }

    public ChartRequest sortOnPackages(Boolean sortOnPackages) {
        this.sortOnPackages = sortOnPackages;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on packages")
    @JsonProperty(value="sortOnPackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnPackages() {
        return this.sortOnPackages;
    }

    @JsonProperty(value="sortOnPackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnPackages(Boolean sortOnPackages) {
        this.sortOnPackages = sortOnPackages;
    }

    public ChartRequest sortOnAddOns(Boolean sortOnAddOns) {
        this.sortOnAddOns = sortOnAddOns;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on add-ons")
    @JsonProperty(value="sortOnAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnAddOns() {
        return this.sortOnAddOns;
    }

    @JsonProperty(value="sortOnAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnAddOns(Boolean sortOnAddOns) {
        this.sortOnAddOns = sortOnAddOns;
    }

    public ChartRequest sortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
        this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on total room revenue")
    @JsonProperty(value="sortOnTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnTotalRoomRevenue() {
        return this.sortOnTotalRoomRevenue;
    }

    @JsonProperty(value="sortOnTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
        this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
    }

    public ChartRequest sortOnPackagesRevenue(Boolean sortOnPackagesRevenue) {
        this.sortOnPackagesRevenue = sortOnPackagesRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on packag revenue")
    @JsonProperty(value="sortOnPackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnPackagesRevenue() {
        return this.sortOnPackagesRevenue;
    }

    @JsonProperty(value="sortOnPackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnPackagesRevenue(Boolean sortOnPackagesRevenue) {
        this.sortOnPackagesRevenue = sortOnPackagesRevenue;
    }

    public ChartRequest sortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
        this.sortOnAddonsRevenue = sortOnAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on add-on revenue")
    @JsonProperty(value="sortOnAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnAddonsRevenue() {
        return this.sortOnAddonsRevenue;
    }

    @JsonProperty(value="sortOnAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
        this.sortOnAddonsRevenue = sortOnAddonsRevenue;
    }

    public ChartRequest sortOnPackagesAndAddonsRevenue(Boolean sortOnPackagesAndAddonsRevenue) {
        this.sortOnPackagesAndAddonsRevenue = sortOnPackagesAndAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on combined packages and add-on revenue")
    @JsonProperty(value="sortOnPackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnPackagesAndAddonsRevenue() {
        return this.sortOnPackagesAndAddonsRevenue;
    }

    @JsonProperty(value="sortOnPackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnPackagesAndAddonsRevenue(Boolean sortOnPackagesAndAddonsRevenue) {
        this.sortOnPackagesAndAddonsRevenue = sortOnPackagesAndAddonsRevenue;
    }

    public ChartRequest sortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
        this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on total net revenue")
    @JsonProperty(value="sortOnTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnTotalNetRevenue() {
        return this.sortOnTotalNetRevenue;
    }

    @JsonProperty(value="sortOnTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
        this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
    }

    public ChartRequest sortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
        this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled room nights")
    @JsonProperty(value="sortOnCancelledRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledRoomNights() {
        return this.sortOnCancelledRoomNights;
    }

    @JsonProperty(value="sortOnCancelledRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
        this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
    }

    public ChartRequest sortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
        this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled meeting rooms")
    @JsonProperty(value="sortOnCancelledMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledMeetingRooms() {
        return this.sortOnCancelledMeetingRooms;
    }

    @JsonProperty(value="sortOnCancelledMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
        this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
    }

    public ChartRequest sortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
        this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled restaurants")
    @JsonProperty(value="sortOnCancelledRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledRestaurants() {
        return this.sortOnCancelledRestaurants;
    }

    @JsonProperty(value="sortOnCancelledRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
        this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
    }

    public ChartRequest sortOnCancelledSpas(Boolean sortOnCancelledSpas) {
        this.sortOnCancelledSpas = sortOnCancelledSpas;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled spas")
    @JsonProperty(value="sortOnCancelledSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledSpas() {
        return this.sortOnCancelledSpas;
    }

    @JsonProperty(value="sortOnCancelledSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledSpas(Boolean sortOnCancelledSpas) {
        this.sortOnCancelledSpas = sortOnCancelledSpas;
    }

    public ChartRequest sortOnCancelledActivities(Boolean sortOnCancelledActivities) {
        this.sortOnCancelledActivities = sortOnCancelledActivities;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled activities")
    @JsonProperty(value="sortOnCancelledActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledActivities() {
        return this.sortOnCancelledActivities;
    }

    @JsonProperty(value="sortOnCancelledActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledActivities(Boolean sortOnCancelledActivities) {
        this.sortOnCancelledActivities = sortOnCancelledActivities;
    }

    public ChartRequest sortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
        this.sortOnCancelledAttractions = sortOnCancelledAttractions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled attractions")
    @JsonProperty(value="sortOnCancelledAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledAttractions() {
        return this.sortOnCancelledAttractions;
    }

    @JsonProperty(value="sortOnCancelledAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
        this.sortOnCancelledAttractions = sortOnCancelledAttractions;
    }

    public ChartRequest sortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
        this.sortOnCancelledPlaces = sortOnCancelledPlaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled places")
    @JsonProperty(value="sortOnCancelledPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledPlaces() {
        return this.sortOnCancelledPlaces;
    }

    @JsonProperty(value="sortOnCancelledPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
        this.sortOnCancelledPlaces = sortOnCancelledPlaces;
    }

    public ChartRequest sortOnCancelledPackages(Boolean sortOnCancelledPackages) {
        this.sortOnCancelledPackages = sortOnCancelledPackages;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled packages")
    @JsonProperty(value="sortOnCancelledPackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledPackages() {
        return this.sortOnCancelledPackages;
    }

    @JsonProperty(value="sortOnCancelledPackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledPackages(Boolean sortOnCancelledPackages) {
        this.sortOnCancelledPackages = sortOnCancelledPackages;
    }

    public ChartRequest sortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
        this.sortOnCancelledAddOns = sortOnCancelledAddOns;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled add-ons")
    @JsonProperty(value="sortOnCancelledAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledAddOns() {
        return this.sortOnCancelledAddOns;
    }

    @JsonProperty(value="sortOnCancelledAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
        this.sortOnCancelledAddOns = sortOnCancelledAddOns;
    }

    public ChartRequest sortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
        this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled total room revenue")
    @JsonProperty(value="sortOnCancelledTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledTotalRoomRevenue() {
        return this.sortOnCancelledTotalRoomRevenue;
    }

    @JsonProperty(value="sortOnCancelledTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
        this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
    }

    public ChartRequest sortOnCancelledPackagesAndAddonsRevenue(Boolean sortOnCancelledPackagesAndAddonsRevenue) {
        this.sortOnCancelledPackagesAndAddonsRevenue = sortOnCancelledPackagesAndAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled packages revenue")
    @JsonProperty(value="sortOnCancelledPackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledPackagesAndAddonsRevenue() {
        return this.sortOnCancelledPackagesAndAddonsRevenue;
    }

    @JsonProperty(value="sortOnCancelledPackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledPackagesAndAddonsRevenue(Boolean sortOnCancelledPackagesAndAddonsRevenue) {
        this.sortOnCancelledPackagesAndAddonsRevenue = sortOnCancelledPackagesAndAddonsRevenue;
    }

    public ChartRequest sortOnCancelledPackagesRevenue(Boolean sortOnCancelledPackagesRevenue) {
        this.sortOnCancelledPackagesRevenue = sortOnCancelledPackagesRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled packages revenue")
    @JsonProperty(value="sortOnCancelledPackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledPackagesRevenue() {
        return this.sortOnCancelledPackagesRevenue;
    }

    @JsonProperty(value="sortOnCancelledPackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledPackagesRevenue(Boolean sortOnCancelledPackagesRevenue) {
        this.sortOnCancelledPackagesRevenue = sortOnCancelledPackagesRevenue;
    }

    public ChartRequest sortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
        this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled add-o revenue")
    @JsonProperty(value="sortOnCancelledAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledAddonsRevenue() {
        return this.sortOnCancelledAddonsRevenue;
    }

    @JsonProperty(value="sortOnCancelledAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
        this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
    }

    public ChartRequest sortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
        this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Sort on cancelled total net revenue")
    @JsonProperty(value="sortOnCancelledTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSortOnCancelledTotalNetRevenue() {
        return this.sortOnCancelledTotalNetRevenue;
    }

    @JsonProperty(value="sortOnCancelledTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
        this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
    }

    public ChartRequest includePageVisits(Boolean includePageVisits) {
        this.includePageVisits = includePageVisits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include page visits")
    @JsonProperty(value="includePageVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePageVisits() {
        return this.includePageVisits;
    }

    @JsonProperty(value="includePageVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePageVisits(Boolean includePageVisits) {
        this.includePageVisits = includePageVisits;
    }

    public ChartRequest includeMapMarkerVisits(Boolean includeMapMarkerVisits) {
        this.includeMapMarkerVisits = includeMapMarkerVisits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include map marker visits")
    @JsonProperty(value="includeMapMarkerVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeMapMarkerVisits() {
        return this.includeMapMarkerVisits;
    }

    @JsonProperty(value="includeMapMarkerVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeMapMarkerVisits(Boolean includeMapMarkerVisits) {
        this.includeMapMarkerVisits = includeMapMarkerVisits;
    }

    public ChartRequest includeCardVisits(Boolean includeCardVisits) {
        this.includeCardVisits = includeCardVisits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include card visits")
    @JsonProperty(value="includeCardVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCardVisits() {
        return this.includeCardVisits;
    }

    @JsonProperty(value="includeCardVisits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCardVisits(Boolean includeCardVisits) {
        this.includeCardVisits = includeCardVisits;
    }

    public ChartRequest includeBookings(Boolean includeBookings) {
        this.includeBookings = includeBookings;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include bookings")
    @JsonProperty(value="includeBookings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeBookings() {
        return this.includeBookings;
    }

    @JsonProperty(value="includeBookings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeBookings(Boolean includeBookings) {
        this.includeBookings = includeBookings;
    }

    public ChartRequest includeCancellations(Boolean includeCancellations) {
        this.includeCancellations = includeCancellations;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancellations")
    @JsonProperty(value="includeCancellations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancellations() {
        return this.includeCancellations;
    }

    @JsonProperty(value="includeCancellations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancellations(Boolean includeCancellations) {
        this.includeCancellations = includeCancellations;
    }

    public ChartRequest includeRoomNights(Boolean includeRoomNights) {
        this.includeRoomNights = includeRoomNights;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include room nights")
    @JsonProperty(value="includeRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeRoomNights() {
        return this.includeRoomNights;
    }

    @JsonProperty(value="includeRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeRoomNights(Boolean includeRoomNights) {
        this.includeRoomNights = includeRoomNights;
    }

    public ChartRequest includeMeetingRooms(Boolean includeMeetingRooms) {
        this.includeMeetingRooms = includeMeetingRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include meeting rooms")
    @JsonProperty(value="includeMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeMeetingRooms() {
        return this.includeMeetingRooms;
    }

    @JsonProperty(value="includeMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeMeetingRooms(Boolean includeMeetingRooms) {
        this.includeMeetingRooms = includeMeetingRooms;
    }

    public ChartRequest includeRestaurants(Boolean includeRestaurants) {
        this.includeRestaurants = includeRestaurants;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include restaurants")
    @JsonProperty(value="includeRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeRestaurants() {
        return this.includeRestaurants;
    }

    @JsonProperty(value="includeRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeRestaurants(Boolean includeRestaurants) {
        this.includeRestaurants = includeRestaurants;
    }

    public ChartRequest includeSpas(Boolean includeSpas) {
        this.includeSpas = includeSpas;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include spas")
    @JsonProperty(value="includeSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeSpas() {
        return this.includeSpas;
    }

    @JsonProperty(value="includeSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeSpas(Boolean includeSpas) {
        this.includeSpas = includeSpas;
    }

    public ChartRequest includeActivities(Boolean includeActivities) {
        this.includeActivities = includeActivities;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include activities")
    @JsonProperty(value="includeActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeActivities() {
        return this.includeActivities;
    }

    @JsonProperty(value="includeActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeActivities(Boolean includeActivities) {
        this.includeActivities = includeActivities;
    }

    public ChartRequest includeAttractions(Boolean includeAttractions) {
        this.includeAttractions = includeAttractions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include attractions")
    @JsonProperty(value="includeAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeAttractions() {
        return this.includeAttractions;
    }

    @JsonProperty(value="includeAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeAttractions(Boolean includeAttractions) {
        this.includeAttractions = includeAttractions;
    }

    public ChartRequest includePlaces(Boolean includePlaces) {
        this.includePlaces = includePlaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include places")
    @JsonProperty(value="includePlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePlaces() {
        return this.includePlaces;
    }

    @JsonProperty(value="includePlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePlaces(Boolean includePlaces) {
        this.includePlaces = includePlaces;
    }

    public ChartRequest includePackages(Boolean includePackages) {
        this.includePackages = includePackages;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include packages")
    @JsonProperty(value="includePackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePackages() {
        return this.includePackages;
    }

    @JsonProperty(value="includePackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePackages(Boolean includePackages) {
        this.includePackages = includePackages;
    }

    public ChartRequest includeAddOns(Boolean includeAddOns) {
        this.includeAddOns = includeAddOns;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include add-ons")
    @JsonProperty(value="includeAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeAddOns() {
        return this.includeAddOns;
    }

    @JsonProperty(value="includeAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeAddOns(Boolean includeAddOns) {
        this.includeAddOns = includeAddOns;
    }

    public ChartRequest includeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
        this.includeTotalRoomRevenue = includeTotalRoomRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include total room revenue")
    @JsonProperty(value="includeTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTotalRoomRevenue() {
        return this.includeTotalRoomRevenue;
    }

    @JsonProperty(value="includeTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
        this.includeTotalRoomRevenue = includeTotalRoomRevenue;
    }

    public ChartRequest includeAverageRoomRate(Boolean includeAverageRoomRate) {
        this.includeAverageRoomRate = includeAverageRoomRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include average room rate")
    @JsonProperty(value="includeAverageRoomRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeAverageRoomRate() {
        return this.includeAverageRoomRate;
    }

    @JsonProperty(value="includeAverageRoomRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeAverageRoomRate(Boolean includeAverageRoomRate) {
        this.includeAverageRoomRate = includeAverageRoomRate;
    }

    public ChartRequest includePackagesRevenue(Boolean includePackagesRevenue) {
        this.includePackagesRevenue = includePackagesRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include packages revenue")
    @JsonProperty(value="includePackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePackagesRevenue() {
        return this.includePackagesRevenue;
    }

    @JsonProperty(value="includePackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePackagesRevenue(Boolean includePackagesRevenue) {
        this.includePackagesRevenue = includePackagesRevenue;
    }

    public ChartRequest includeAddonsRevenue(Boolean includeAddonsRevenue) {
        this.includeAddonsRevenue = includeAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include add-ons revenue")
    @JsonProperty(value="includeAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeAddonsRevenue() {
        return this.includeAddonsRevenue;
    }

    @JsonProperty(value="includeAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeAddonsRevenue(Boolean includeAddonsRevenue) {
        this.includeAddonsRevenue = includeAddonsRevenue;
    }

    public ChartRequest includePackagesAndAddonsRevenue(Boolean includePackagesAndAddonsRevenue) {
        this.includePackagesAndAddonsRevenue = includePackagesAndAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include combined packages and add-os revenue")
    @JsonProperty(value="includePackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePackagesAndAddonsRevenue() {
        return this.includePackagesAndAddonsRevenue;
    }

    @JsonProperty(value="includePackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePackagesAndAddonsRevenue(Boolean includePackagesAndAddonsRevenue) {
        this.includePackagesAndAddonsRevenue = includePackagesAndAddonsRevenue;
    }

    public ChartRequest includeTotalNetRevenue(Boolean includeTotalNetRevenue) {
        this.includeTotalNetRevenue = includeTotalNetRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include total net revenue")
    @JsonProperty(value="includeTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTotalNetRevenue() {
        return this.includeTotalNetRevenue;
    }

    @JsonProperty(value="includeTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeTotalNetRevenue(Boolean includeTotalNetRevenue) {
        this.includeTotalNetRevenue = includeTotalNetRevenue;
    }

    public ChartRequest includeCancelledRoomNights(Boolean includeCancelledRoomNights) {
        this.includeCancelledRoomNights = includeCancelledRoomNights;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled room nights")
    @JsonProperty(value="includeCancelledRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledRoomNights() {
        return this.includeCancelledRoomNights;
    }

    @JsonProperty(value="includeCancelledRoomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledRoomNights(Boolean includeCancelledRoomNights) {
        this.includeCancelledRoomNights = includeCancelledRoomNights;
    }

    public ChartRequest includeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
        this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled meeting rooms")
    @JsonProperty(value="includeCancelledMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledMeetingRooms() {
        return this.includeCancelledMeetingRooms;
    }

    @JsonProperty(value="includeCancelledMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
        this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
    }

    public ChartRequest includeCancelledRestaurants(Boolean includeCancelledRestaurants) {
        this.includeCancelledRestaurants = includeCancelledRestaurants;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled restaurants")
    @JsonProperty(value="includeCancelledRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledRestaurants() {
        return this.includeCancelledRestaurants;
    }

    @JsonProperty(value="includeCancelledRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledRestaurants(Boolean includeCancelledRestaurants) {
        this.includeCancelledRestaurants = includeCancelledRestaurants;
    }

    public ChartRequest includeCancelledSpas(Boolean includeCancelledSpas) {
        this.includeCancelledSpas = includeCancelledSpas;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled spas")
    @JsonProperty(value="includeCancelledSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledSpas() {
        return this.includeCancelledSpas;
    }

    @JsonProperty(value="includeCancelledSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledSpas(Boolean includeCancelledSpas) {
        this.includeCancelledSpas = includeCancelledSpas;
    }

    public ChartRequest includeCancelledActivities(Boolean includeCancelledActivities) {
        this.includeCancelledActivities = includeCancelledActivities;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled activities")
    @JsonProperty(value="includeCancelledActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledActivities() {
        return this.includeCancelledActivities;
    }

    @JsonProperty(value="includeCancelledActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledActivities(Boolean includeCancelledActivities) {
        this.includeCancelledActivities = includeCancelledActivities;
    }

    public ChartRequest includeCancelledAttractions(Boolean includeCancelledAttractions) {
        this.includeCancelledAttractions = includeCancelledAttractions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled attractions")
    @JsonProperty(value="includeCancelledAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledAttractions() {
        return this.includeCancelledAttractions;
    }

    @JsonProperty(value="includeCancelledAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledAttractions(Boolean includeCancelledAttractions) {
        this.includeCancelledAttractions = includeCancelledAttractions;
    }

    public ChartRequest includeCancelledPlaces(Boolean includeCancelledPlaces) {
        this.includeCancelledPlaces = includeCancelledPlaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled places")
    @JsonProperty(value="includeCancelledPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledPlaces() {
        return this.includeCancelledPlaces;
    }

    @JsonProperty(value="includeCancelledPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledPlaces(Boolean includeCancelledPlaces) {
        this.includeCancelledPlaces = includeCancelledPlaces;
    }

    public ChartRequest includeCancelledPackages(Boolean includeCancelledPackages) {
        this.includeCancelledPackages = includeCancelledPackages;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled packages")
    @JsonProperty(value="includeCancelledPackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledPackages() {
        return this.includeCancelledPackages;
    }

    @JsonProperty(value="includeCancelledPackages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledPackages(Boolean includeCancelledPackages) {
        this.includeCancelledPackages = includeCancelledPackages;
    }

    public ChartRequest includeCancelledAddOns(Boolean includeCancelledAddOns) {
        this.includeCancelledAddOns = includeCancelledAddOns;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled add-ons")
    @JsonProperty(value="includeCancelledAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledAddOns() {
        return this.includeCancelledAddOns;
    }

    @JsonProperty(value="includeCancelledAddOns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledAddOns(Boolean includeCancelledAddOns) {
        this.includeCancelledAddOns = includeCancelledAddOns;
    }

    public ChartRequest includeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
        this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled total room revenue")
    @JsonProperty(value="includeCancelledTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledTotalRoomRevenue() {
        return this.includeCancelledTotalRoomRevenue;
    }

    @JsonProperty(value="includeCancelledTotalRoomRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
        this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
    }

    public ChartRequest includeCancelledPackagesAndAddonsRevenue(Boolean includeCancelledPackagesAndAddonsRevenue) {
        this.includeCancelledPackagesAndAddonsRevenue = includeCancelledPackagesAndAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include combined cancelled package and add-on revenue")
    @JsonProperty(value="includeCancelledPackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledPackagesAndAddonsRevenue() {
        return this.includeCancelledPackagesAndAddonsRevenue;
    }

    @JsonProperty(value="includeCancelledPackagesAndAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledPackagesAndAddonsRevenue(Boolean includeCancelledPackagesAndAddonsRevenue) {
        this.includeCancelledPackagesAndAddonsRevenue = includeCancelledPackagesAndAddonsRevenue;
    }

    public ChartRequest includeCancelledPackagesRevenue(Boolean includeCancelledPackagesRevenue) {
        this.includeCancelledPackagesRevenue = includeCancelledPackagesRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled packages revenue")
    @JsonProperty(value="includeCancelledPackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledPackagesRevenue() {
        return this.includeCancelledPackagesRevenue;
    }

    @JsonProperty(value="includeCancelledPackagesRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledPackagesRevenue(Boolean includeCancelledPackagesRevenue) {
        this.includeCancelledPackagesRevenue = includeCancelledPackagesRevenue;
    }

    public ChartRequest includeCancelledAddonsRevenue(Boolean includeCancelledAddonsRevenue) {
        this.includeCancelledAddonsRevenue = includeCancelledAddonsRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled add-ons revenue")
    @JsonProperty(value="includeCancelledAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledAddonsRevenue() {
        return this.includeCancelledAddonsRevenue;
    }

    @JsonProperty(value="includeCancelledAddonsRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledAddonsRevenue(Boolean includeCancelledAddonsRevenue) {
        this.includeCancelledAddonsRevenue = includeCancelledAddonsRevenue;
    }

    public ChartRequest includeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
        this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Include cancelled total net revenue")
    @JsonProperty(value="includeCancelledTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeCancelledTotalNetRevenue() {
        return this.includeCancelledTotalNetRevenue;
    }

    @JsonProperty(value="includeCancelledTotalNetRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
        this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
    }

    public ChartRequest groupOnChannelSubType(Boolean groupOnChannelSubType) {
        this.groupOnChannelSubType = groupOnChannelSubType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on  channel sub type")
    @JsonProperty(value="groupOnChannelSubType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnChannelSubType() {
        return this.groupOnChannelSubType;
    }

    @JsonProperty(value="groupOnChannelSubType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnChannelSubType(Boolean groupOnChannelSubType) {
        this.groupOnChannelSubType = groupOnChannelSubType;
    }

    public ChartRequest groupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
        this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on owner identifier")
    @JsonProperty(value="groupOnOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnOwnerIdentifier() {
        return this.groupOnOwnerIdentifier;
    }

    @JsonProperty(value="groupOnOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
        this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
    }

    public ChartRequest groupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
        this.groupOnEngineIdentifier = groupOnEngineIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on application identifier")
    @JsonProperty(value="groupOnEngineIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnEngineIdentifier() {
        return this.groupOnEngineIdentifier;
    }

    @JsonProperty(value="groupOnEngineIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
        this.groupOnEngineIdentifier = groupOnEngineIdentifier;
    }

    public ChartRequest groupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
        this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on application country geoNameId")
    @JsonProperty(value="groupOnEngineCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnEngineCountryGeoNameId() {
        return this.groupOnEngineCountryGeoNameId;
    }

    @JsonProperty(value="groupOnEngineCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
        this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
    }

    public ChartRequest groupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
        this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on application city geoNameId")
    @JsonProperty(value="groupOnEngineCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnEngineCityGeoNameId() {
        return this.groupOnEngineCityGeoNameId;
    }

    @JsonProperty(value="groupOnEngineCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
        this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
    }

    public ChartRequest groupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
        this.groupOnEngineContinentCode = groupOnEngineContinentCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on application continent code")
    @JsonProperty(value="groupOnEngineContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnEngineContinentCode() {
        return this.groupOnEngineContinentCode;
    }

    @JsonProperty(value="groupOnEngineContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
        this.groupOnEngineContinentCode = groupOnEngineContinentCode;
    }

    public ChartRequest groupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
        this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on customization identifier")
    @JsonProperty(value="groupOnEngineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnEngineConfigurationIdentifier() {
        return this.groupOnEngineConfigurationIdentifier;
    }

    @JsonProperty(value="groupOnEngineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
        this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
    }

    public ChartRequest groupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
        this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on country geoNameId")
    @JsonProperty(value="groupOnCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnCountryGeoNameId() {
        return this.groupOnCountryGeoNameId;
    }

    @JsonProperty(value="groupOnCountryGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
        this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
    }

    public ChartRequest groupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
        this.groupOnCityGeoNameId = groupOnCityGeoNameId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on city geoNameId")
    @JsonProperty(value="groupOnCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnCityGeoNameId() {
        return this.groupOnCityGeoNameId;
    }

    @JsonProperty(value="groupOnCityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
        this.groupOnCityGeoNameId = groupOnCityGeoNameId;
    }

    public ChartRequest groupOnContinentCode(Boolean groupOnContinentCode) {
        this.groupOnContinentCode = groupOnContinentCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on continent code")
    @JsonProperty(value="groupOnContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnContinentCode() {
        return this.groupOnContinentCode;
    }

    @JsonProperty(value="groupOnContinentCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnContinentCode(Boolean groupOnContinentCode) {
        this.groupOnContinentCode = groupOnContinentCode;
    }

    public ChartRequest groupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
        this.groupOnHotelIdentifier = groupOnHotelIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on hotel identifier")
    @JsonProperty(value="groupOnHotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnHotelIdentifier() {
        return this.groupOnHotelIdentifier;
    }

    @JsonProperty(value="groupOnHotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
        this.groupOnHotelIdentifier = groupOnHotelIdentifier;
    }

    public ChartRequest groupOnUserIdentifier(Boolean groupOnUserIdentifier) {
        this.groupOnUserIdentifier = groupOnUserIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Group on user identifier")
    @JsonProperty(value="groupOnUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupOnUserIdentifier() {
        return this.groupOnUserIdentifier;
    }

    @JsonProperty(value="groupOnUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupOnUserIdentifier(Boolean groupOnUserIdentifier) {
        this.groupOnUserIdentifier = groupOnUserIdentifier;
    }

    public ChartRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="EUR", value="Currency code")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartRequest chartRequest = (ChartRequest)o;
        return Objects.equals((Object)this.series, (Object)chartRequest.series) && Objects.equals(this.timeSeriesUnits, chartRequest.timeSeriesUnits) && Objects.equals(this.startDate, chartRequest.startDate) && Objects.equals(this.endDate, chartRequest.endDate) && Objects.equals(this.filterOnHotelIdentifier, chartRequest.filterOnHotelIdentifier) && Objects.equals((Object)this.filterOnChannelSubType, (Object)chartRequest.filterOnChannelSubType) && Objects.equals(this.filterOnOwnerIdentifier, chartRequest.filterOnOwnerIdentifier) && Objects.equals(this.filterOnEngineCountryGeoNameId, chartRequest.filterOnEngineCountryGeoNameId) && Objects.equals(this.filterOnEngineCityGeoNameId, chartRequest.filterOnEngineCityGeoNameId) && Objects.equals(this.filterOnEngineContinentCode, chartRequest.filterOnEngineContinentCode) && Objects.equals(this.filterOnEngineConfigurationIdentifier, chartRequest.filterOnEngineConfigurationIdentifier) && Objects.equals(this.filterOnCountryGeoNameId, chartRequest.filterOnCountryGeoNameId) && Objects.equals(this.filterOnCityGeoNameId, chartRequest.filterOnCityGeoNameId) && Objects.equals(this.filterOnContinentCode, chartRequest.filterOnContinentCode) && Objects.equals(this.filterOnUserIdentifier, chartRequest.filterOnUserIdentifier) && Objects.equals(this.sortOnPageVisits, chartRequest.sortOnPageVisits) && Objects.equals(this.sortOnMapMarkerVisits, chartRequest.sortOnMapMarkerVisits) && Objects.equals(this.sortOnCardVisits, chartRequest.sortOnCardVisits) && Objects.equals(this.sortOnBookings, chartRequest.sortOnBookings) && Objects.equals(this.sortOnCancellations, chartRequest.sortOnCancellations) && Objects.equals(this.sortOnRoomNights, chartRequest.sortOnRoomNights) && Objects.equals(this.sortOnMeetingRooms, chartRequest.sortOnMeetingRooms) && Objects.equals(this.sortOnRestaurants, chartRequest.sortOnRestaurants) && Objects.equals(this.sortOnSpas, chartRequest.sortOnSpas) && Objects.equals(this.sortOnActivities, chartRequest.sortOnActivities) && Objects.equals(this.sortOnAttractions, chartRequest.sortOnAttractions) && Objects.equals(this.sortOnPlaces, chartRequest.sortOnPlaces) && Objects.equals(this.sortOnPackages, chartRequest.sortOnPackages) && Objects.equals(this.sortOnAddOns, chartRequest.sortOnAddOns) && Objects.equals(this.sortOnTotalRoomRevenue, chartRequest.sortOnTotalRoomRevenue) && Objects.equals(this.sortOnPackagesRevenue, chartRequest.sortOnPackagesRevenue) && Objects.equals(this.sortOnAddonsRevenue, chartRequest.sortOnAddonsRevenue) && Objects.equals(this.sortOnPackagesAndAddonsRevenue, chartRequest.sortOnPackagesAndAddonsRevenue) && Objects.equals(this.sortOnTotalNetRevenue, chartRequest.sortOnTotalNetRevenue) && Objects.equals(this.sortOnCancelledRoomNights, chartRequest.sortOnCancelledRoomNights) && Objects.equals(this.sortOnCancelledMeetingRooms, chartRequest.sortOnCancelledMeetingRooms) && Objects.equals(this.sortOnCancelledRestaurants, chartRequest.sortOnCancelledRestaurants) && Objects.equals(this.sortOnCancelledSpas, chartRequest.sortOnCancelledSpas) && Objects.equals(this.sortOnCancelledActivities, chartRequest.sortOnCancelledActivities) && Objects.equals(this.sortOnCancelledAttractions, chartRequest.sortOnCancelledAttractions) && Objects.equals(this.sortOnCancelledPlaces, chartRequest.sortOnCancelledPlaces) && Objects.equals(this.sortOnCancelledPackages, chartRequest.sortOnCancelledPackages) && Objects.equals(this.sortOnCancelledAddOns, chartRequest.sortOnCancelledAddOns) && Objects.equals(this.sortOnCancelledTotalRoomRevenue, chartRequest.sortOnCancelledTotalRoomRevenue) && Objects.equals(this.sortOnCancelledPackagesAndAddonsRevenue, chartRequest.sortOnCancelledPackagesAndAddonsRevenue) && Objects.equals(this.sortOnCancelledPackagesRevenue, chartRequest.sortOnCancelledPackagesRevenue) && Objects.equals(this.sortOnCancelledAddonsRevenue, chartRequest.sortOnCancelledAddonsRevenue) && Objects.equals(this.sortOnCancelledTotalNetRevenue, chartRequest.sortOnCancelledTotalNetRevenue) && Objects.equals(this.includePageVisits, chartRequest.includePageVisits) && Objects.equals(this.includeMapMarkerVisits, chartRequest.includeMapMarkerVisits) && Objects.equals(this.includeCardVisits, chartRequest.includeCardVisits) && Objects.equals(this.includeBookings, chartRequest.includeBookings) && Objects.equals(this.includeCancellations, chartRequest.includeCancellations) && Objects.equals(this.includeRoomNights, chartRequest.includeRoomNights) && Objects.equals(this.includeMeetingRooms, chartRequest.includeMeetingRooms) && Objects.equals(this.includeRestaurants, chartRequest.includeRestaurants) && Objects.equals(this.includeSpas, chartRequest.includeSpas) && Objects.equals(this.includeActivities, chartRequest.includeActivities) && Objects.equals(this.includeAttractions, chartRequest.includeAttractions) && Objects.equals(this.includePlaces, chartRequest.includePlaces) && Objects.equals(this.includePackages, chartRequest.includePackages) && Objects.equals(this.includeAddOns, chartRequest.includeAddOns) && Objects.equals(this.includeTotalRoomRevenue, chartRequest.includeTotalRoomRevenue) && Objects.equals(this.includeAverageRoomRate, chartRequest.includeAverageRoomRate) && Objects.equals(this.includePackagesRevenue, chartRequest.includePackagesRevenue) && Objects.equals(this.includeAddonsRevenue, chartRequest.includeAddonsRevenue) && Objects.equals(this.includePackagesAndAddonsRevenue, chartRequest.includePackagesAndAddonsRevenue) && Objects.equals(this.includeTotalNetRevenue, chartRequest.includeTotalNetRevenue) && Objects.equals(this.includeCancelledRoomNights, chartRequest.includeCancelledRoomNights) && Objects.equals(this.includeCancelledMeetingRooms, chartRequest.includeCancelledMeetingRooms) && Objects.equals(this.includeCancelledRestaurants, chartRequest.includeCancelledRestaurants) && Objects.equals(this.includeCancelledSpas, chartRequest.includeCancelledSpas) && Objects.equals(this.includeCancelledActivities, chartRequest.includeCancelledActivities) && Objects.equals(this.includeCancelledAttractions, chartRequest.includeCancelledAttractions) && Objects.equals(this.includeCancelledPlaces, chartRequest.includeCancelledPlaces) && Objects.equals(this.includeCancelledPackages, chartRequest.includeCancelledPackages) && Objects.equals(this.includeCancelledAddOns, chartRequest.includeCancelledAddOns) && Objects.equals(this.includeCancelledTotalRoomRevenue, chartRequest.includeCancelledTotalRoomRevenue) && Objects.equals(this.includeCancelledPackagesAndAddonsRevenue, chartRequest.includeCancelledPackagesAndAddonsRevenue) && Objects.equals(this.includeCancelledPackagesRevenue, chartRequest.includeCancelledPackagesRevenue) && Objects.equals(this.includeCancelledAddonsRevenue, chartRequest.includeCancelledAddonsRevenue) && Objects.equals(this.includeCancelledTotalNetRevenue, chartRequest.includeCancelledTotalNetRevenue) && Objects.equals(this.groupOnChannelSubType, chartRequest.groupOnChannelSubType) && Objects.equals(this.groupOnOwnerIdentifier, chartRequest.groupOnOwnerIdentifier) && Objects.equals(this.groupOnEngineIdentifier, chartRequest.groupOnEngineIdentifier) && Objects.equals(this.groupOnEngineCountryGeoNameId, chartRequest.groupOnEngineCountryGeoNameId) && Objects.equals(this.groupOnEngineCityGeoNameId, chartRequest.groupOnEngineCityGeoNameId) && Objects.equals(this.groupOnEngineContinentCode, chartRequest.groupOnEngineContinentCode) && Objects.equals(this.groupOnEngineConfigurationIdentifier, chartRequest.groupOnEngineConfigurationIdentifier) && Objects.equals(this.groupOnCountryGeoNameId, chartRequest.groupOnCountryGeoNameId) && Objects.equals(this.groupOnCityGeoNameId, chartRequest.groupOnCityGeoNameId) && Objects.equals(this.groupOnContinentCode, chartRequest.groupOnContinentCode) && Objects.equals(this.groupOnHotelIdentifier, chartRequest.groupOnHotelIdentifier) && Objects.equals(this.groupOnUserIdentifier, chartRequest.groupOnUserIdentifier) && Objects.equals(this.currencyCode, chartRequest.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.series, this.timeSeriesUnits, this.startDate, this.endDate, this.filterOnHotelIdentifier, this.filterOnChannelSubType, this.filterOnOwnerIdentifier, this.filterOnEngineCountryGeoNameId, this.filterOnEngineCityGeoNameId, this.filterOnEngineContinentCode, this.filterOnEngineConfigurationIdentifier, this.filterOnCountryGeoNameId, this.filterOnCityGeoNameId, this.filterOnContinentCode, this.filterOnUserIdentifier, this.sortOnPageVisits, this.sortOnMapMarkerVisits, this.sortOnCardVisits, this.sortOnBookings, this.sortOnCancellations, this.sortOnRoomNights, this.sortOnMeetingRooms, this.sortOnRestaurants, this.sortOnSpas, this.sortOnActivities, this.sortOnAttractions, this.sortOnPlaces, this.sortOnPackages, this.sortOnAddOns, this.sortOnTotalRoomRevenue, this.sortOnPackagesRevenue, this.sortOnAddonsRevenue, this.sortOnPackagesAndAddonsRevenue, this.sortOnTotalNetRevenue, this.sortOnCancelledRoomNights, this.sortOnCancelledMeetingRooms, this.sortOnCancelledRestaurants, this.sortOnCancelledSpas, this.sortOnCancelledActivities, this.sortOnCancelledAttractions, this.sortOnCancelledPlaces, this.sortOnCancelledPackages, this.sortOnCancelledAddOns, this.sortOnCancelledTotalRoomRevenue, this.sortOnCancelledPackagesAndAddonsRevenue, this.sortOnCancelledPackagesRevenue, this.sortOnCancelledAddonsRevenue, this.sortOnCancelledTotalNetRevenue, this.includePageVisits, this.includeMapMarkerVisits, this.includeCardVisits, this.includeBookings, this.includeCancellations, this.includeRoomNights, this.includeMeetingRooms, this.includeRestaurants, this.includeSpas, this.includeActivities, this.includeAttractions, this.includePlaces, this.includePackages, this.includeAddOns, this.includeTotalRoomRevenue, this.includeAverageRoomRate, this.includePackagesRevenue, this.includeAddonsRevenue, this.includePackagesAndAddonsRevenue, this.includeTotalNetRevenue, this.includeCancelledRoomNights, this.includeCancelledMeetingRooms, this.includeCancelledRestaurants, this.includeCancelledSpas, this.includeCancelledActivities, this.includeCancelledAttractions, this.includeCancelledPlaces, this.includeCancelledPackages, this.includeCancelledAddOns, this.includeCancelledTotalRoomRevenue, this.includeCancelledPackagesAndAddonsRevenue, this.includeCancelledPackagesRevenue, this.includeCancelledAddonsRevenue, this.includeCancelledTotalNetRevenue, this.groupOnChannelSubType, this.groupOnOwnerIdentifier, this.groupOnEngineIdentifier, this.groupOnEngineCountryGeoNameId, this.groupOnEngineCityGeoNameId, this.groupOnEngineContinentCode, this.groupOnEngineConfigurationIdentifier, this.groupOnCountryGeoNameId, this.groupOnCityGeoNameId, this.groupOnContinentCode, this.groupOnHotelIdentifier, this.groupOnUserIdentifier, this.currencyCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartRequest {\n");
        sb.append("    series: ").append(this.toIndentedString((Object)this.series)).append("\n");
        sb.append("    timeSeriesUnits: ").append(this.toIndentedString(this.timeSeriesUnits)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    filterOnHotelIdentifier: ").append(this.toIndentedString(this.filterOnHotelIdentifier)).append("\n");
        sb.append("    filterOnChannelSubType: ").append(this.toIndentedString((Object)this.filterOnChannelSubType)).append("\n");
        sb.append("    filterOnOwnerIdentifier: ").append(this.toIndentedString(this.filterOnOwnerIdentifier)).append("\n");
        sb.append("    filterOnEngineCountryGeoNameId: ").append(this.toIndentedString(this.filterOnEngineCountryGeoNameId)).append("\n");
        sb.append("    filterOnEngineCityGeoNameId: ").append(this.toIndentedString(this.filterOnEngineCityGeoNameId)).append("\n");
        sb.append("    filterOnEngineContinentCode: ").append(this.toIndentedString(this.filterOnEngineContinentCode)).append("\n");
        sb.append("    filterOnEngineConfigurationIdentifier: ").append(this.toIndentedString(this.filterOnEngineConfigurationIdentifier)).append("\n");
        sb.append("    filterOnCountryGeoNameId: ").append(this.toIndentedString(this.filterOnCountryGeoNameId)).append("\n");
        sb.append("    filterOnCityGeoNameId: ").append(this.toIndentedString(this.filterOnCityGeoNameId)).append("\n");
        sb.append("    filterOnContinentCode: ").append(this.toIndentedString(this.filterOnContinentCode)).append("\n");
        sb.append("    filterOnUserIdentifier: ").append(this.toIndentedString(this.filterOnUserIdentifier)).append("\n");
        sb.append("    sortOnPageVisits: ").append(this.toIndentedString(this.sortOnPageVisits)).append("\n");
        sb.append("    sortOnMapMarkerVisits: ").append(this.toIndentedString(this.sortOnMapMarkerVisits)).append("\n");
        sb.append("    sortOnCardVisits: ").append(this.toIndentedString(this.sortOnCardVisits)).append("\n");
        sb.append("    sortOnBookings: ").append(this.toIndentedString(this.sortOnBookings)).append("\n");
        sb.append("    sortOnCancellations: ").append(this.toIndentedString(this.sortOnCancellations)).append("\n");
        sb.append("    sortOnRoomNights: ").append(this.toIndentedString(this.sortOnRoomNights)).append("\n");
        sb.append("    sortOnMeetingRooms: ").append(this.toIndentedString(this.sortOnMeetingRooms)).append("\n");
        sb.append("    sortOnRestaurants: ").append(this.toIndentedString(this.sortOnRestaurants)).append("\n");
        sb.append("    sortOnSpas: ").append(this.toIndentedString(this.sortOnSpas)).append("\n");
        sb.append("    sortOnActivities: ").append(this.toIndentedString(this.sortOnActivities)).append("\n");
        sb.append("    sortOnAttractions: ").append(this.toIndentedString(this.sortOnAttractions)).append("\n");
        sb.append("    sortOnPlaces: ").append(this.toIndentedString(this.sortOnPlaces)).append("\n");
        sb.append("    sortOnPackages: ").append(this.toIndentedString(this.sortOnPackages)).append("\n");
        sb.append("    sortOnAddOns: ").append(this.toIndentedString(this.sortOnAddOns)).append("\n");
        sb.append("    sortOnTotalRoomRevenue: ").append(this.toIndentedString(this.sortOnTotalRoomRevenue)).append("\n");
        sb.append("    sortOnPackagesRevenue: ").append(this.toIndentedString(this.sortOnPackagesRevenue)).append("\n");
        sb.append("    sortOnAddonsRevenue: ").append(this.toIndentedString(this.sortOnAddonsRevenue)).append("\n");
        sb.append("    sortOnPackagesAndAddonsRevenue: ").append(this.toIndentedString(this.sortOnPackagesAndAddonsRevenue)).append("\n");
        sb.append("    sortOnTotalNetRevenue: ").append(this.toIndentedString(this.sortOnTotalNetRevenue)).append("\n");
        sb.append("    sortOnCancelledRoomNights: ").append(this.toIndentedString(this.sortOnCancelledRoomNights)).append("\n");
        sb.append("    sortOnCancelledMeetingRooms: ").append(this.toIndentedString(this.sortOnCancelledMeetingRooms)).append("\n");
        sb.append("    sortOnCancelledRestaurants: ").append(this.toIndentedString(this.sortOnCancelledRestaurants)).append("\n");
        sb.append("    sortOnCancelledSpas: ").append(this.toIndentedString(this.sortOnCancelledSpas)).append("\n");
        sb.append("    sortOnCancelledActivities: ").append(this.toIndentedString(this.sortOnCancelledActivities)).append("\n");
        sb.append("    sortOnCancelledAttractions: ").append(this.toIndentedString(this.sortOnCancelledAttractions)).append("\n");
        sb.append("    sortOnCancelledPlaces: ").append(this.toIndentedString(this.sortOnCancelledPlaces)).append("\n");
        sb.append("    sortOnCancelledPackages: ").append(this.toIndentedString(this.sortOnCancelledPackages)).append("\n");
        sb.append("    sortOnCancelledAddOns: ").append(this.toIndentedString(this.sortOnCancelledAddOns)).append("\n");
        sb.append("    sortOnCancelledTotalRoomRevenue: ").append(this.toIndentedString(this.sortOnCancelledTotalRoomRevenue)).append("\n");
        sb.append("    sortOnCancelledPackagesAndAddonsRevenue: ").append(this.toIndentedString(this.sortOnCancelledPackagesAndAddonsRevenue)).append("\n");
        sb.append("    sortOnCancelledPackagesRevenue: ").append(this.toIndentedString(this.sortOnCancelledPackagesRevenue)).append("\n");
        sb.append("    sortOnCancelledAddonsRevenue: ").append(this.toIndentedString(this.sortOnCancelledAddonsRevenue)).append("\n");
        sb.append("    sortOnCancelledTotalNetRevenue: ").append(this.toIndentedString(this.sortOnCancelledTotalNetRevenue)).append("\n");
        sb.append("    includePageVisits: ").append(this.toIndentedString(this.includePageVisits)).append("\n");
        sb.append("    includeMapMarkerVisits: ").append(this.toIndentedString(this.includeMapMarkerVisits)).append("\n");
        sb.append("    includeCardVisits: ").append(this.toIndentedString(this.includeCardVisits)).append("\n");
        sb.append("    includeBookings: ").append(this.toIndentedString(this.includeBookings)).append("\n");
        sb.append("    includeCancellations: ").append(this.toIndentedString(this.includeCancellations)).append("\n");
        sb.append("    includeRoomNights: ").append(this.toIndentedString(this.includeRoomNights)).append("\n");
        sb.append("    includeMeetingRooms: ").append(this.toIndentedString(this.includeMeetingRooms)).append("\n");
        sb.append("    includeRestaurants: ").append(this.toIndentedString(this.includeRestaurants)).append("\n");
        sb.append("    includeSpas: ").append(this.toIndentedString(this.includeSpas)).append("\n");
        sb.append("    includeActivities: ").append(this.toIndentedString(this.includeActivities)).append("\n");
        sb.append("    includeAttractions: ").append(this.toIndentedString(this.includeAttractions)).append("\n");
        sb.append("    includePlaces: ").append(this.toIndentedString(this.includePlaces)).append("\n");
        sb.append("    includePackages: ").append(this.toIndentedString(this.includePackages)).append("\n");
        sb.append("    includeAddOns: ").append(this.toIndentedString(this.includeAddOns)).append("\n");
        sb.append("    includeTotalRoomRevenue: ").append(this.toIndentedString(this.includeTotalRoomRevenue)).append("\n");
        sb.append("    includeAverageRoomRate: ").append(this.toIndentedString(this.includeAverageRoomRate)).append("\n");
        sb.append("    includePackagesRevenue: ").append(this.toIndentedString(this.includePackagesRevenue)).append("\n");
        sb.append("    includeAddonsRevenue: ").append(this.toIndentedString(this.includeAddonsRevenue)).append("\n");
        sb.append("    includePackagesAndAddonsRevenue: ").append(this.toIndentedString(this.includePackagesAndAddonsRevenue)).append("\n");
        sb.append("    includeTotalNetRevenue: ").append(this.toIndentedString(this.includeTotalNetRevenue)).append("\n");
        sb.append("    includeCancelledRoomNights: ").append(this.toIndentedString(this.includeCancelledRoomNights)).append("\n");
        sb.append("    includeCancelledMeetingRooms: ").append(this.toIndentedString(this.includeCancelledMeetingRooms)).append("\n");
        sb.append("    includeCancelledRestaurants: ").append(this.toIndentedString(this.includeCancelledRestaurants)).append("\n");
        sb.append("    includeCancelledSpas: ").append(this.toIndentedString(this.includeCancelledSpas)).append("\n");
        sb.append("    includeCancelledActivities: ").append(this.toIndentedString(this.includeCancelledActivities)).append("\n");
        sb.append("    includeCancelledAttractions: ").append(this.toIndentedString(this.includeCancelledAttractions)).append("\n");
        sb.append("    includeCancelledPlaces: ").append(this.toIndentedString(this.includeCancelledPlaces)).append("\n");
        sb.append("    includeCancelledPackages: ").append(this.toIndentedString(this.includeCancelledPackages)).append("\n");
        sb.append("    includeCancelledAddOns: ").append(this.toIndentedString(this.includeCancelledAddOns)).append("\n");
        sb.append("    includeCancelledTotalRoomRevenue: ").append(this.toIndentedString(this.includeCancelledTotalRoomRevenue)).append("\n");
        sb.append("    includeCancelledPackagesAndAddonsRevenue: ").append(this.toIndentedString(this.includeCancelledPackagesAndAddonsRevenue)).append("\n");
        sb.append("    includeCancelledPackagesRevenue: ").append(this.toIndentedString(this.includeCancelledPackagesRevenue)).append("\n");
        sb.append("    includeCancelledAddonsRevenue: ").append(this.toIndentedString(this.includeCancelledAddonsRevenue)).append("\n");
        sb.append("    includeCancelledTotalNetRevenue: ").append(this.toIndentedString(this.includeCancelledTotalNetRevenue)).append("\n");
        sb.append("    groupOnChannelSubType: ").append(this.toIndentedString(this.groupOnChannelSubType)).append("\n");
        sb.append("    groupOnOwnerIdentifier: ").append(this.toIndentedString(this.groupOnOwnerIdentifier)).append("\n");
        sb.append("    groupOnEngineIdentifier: ").append(this.toIndentedString(this.groupOnEngineIdentifier)).append("\n");
        sb.append("    groupOnEngineCountryGeoNameId: ").append(this.toIndentedString(this.groupOnEngineCountryGeoNameId)).append("\n");
        sb.append("    groupOnEngineCityGeoNameId: ").append(this.toIndentedString(this.groupOnEngineCityGeoNameId)).append("\n");
        sb.append("    groupOnEngineContinentCode: ").append(this.toIndentedString(this.groupOnEngineContinentCode)).append("\n");
        sb.append("    groupOnEngineConfigurationIdentifier: ").append(this.toIndentedString(this.groupOnEngineConfigurationIdentifier)).append("\n");
        sb.append("    groupOnCountryGeoNameId: ").append(this.toIndentedString(this.groupOnCountryGeoNameId)).append("\n");
        sb.append("    groupOnCityGeoNameId: ").append(this.toIndentedString(this.groupOnCityGeoNameId)).append("\n");
        sb.append("    groupOnContinentCode: ").append(this.toIndentedString(this.groupOnContinentCode)).append("\n");
        sb.append("    groupOnHotelIdentifier: ").append(this.toIndentedString(this.groupOnHotelIdentifier)).append("\n");
        sb.append("    groupOnUserIdentifier: ").append(this.toIndentedString(this.groupOnUserIdentifier)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SeriesEnum {
        HOUR("HOUR"),
        DAY("DAY"),
        MONTH("MONTH"),
        YEAR("YEAR");

        private String value;

        private SeriesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SeriesEnum fromValue(String value) {
            for (SeriesEnum b : SeriesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FilterOnChannelSubTypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION");

        private String value;

        private FilterOnChannelSubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FilterOnChannelSubTypeEnum fromValue(String value) {
            for (FilterOnChannelSubTypeEnum b : FilterOnChannelSubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

