/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.extranet.model.ChartValueAxisLabels;
import travel.wink.sdk.extranet.model.ChartValueAxisLine;

@ApiModel(description="The configuration options of the value axis.")
@JsonPropertyOrder(value={"labels", "line", "axisCrossingValue", "majorUnit"})
public class ChartValueAxis {
    public static final String JSON_PROPERTY_LABELS = "labels";
    private ChartValueAxisLabels labels;
    public static final String JSON_PROPERTY_LINE = "line";
    private ChartValueAxisLine line;
    public static final String JSON_PROPERTY_AXIS_CROSSING_VALUE = "axisCrossingValue";
    private Integer axisCrossingValue;
    public static final String JSON_PROPERTY_MAJOR_UNIT = "majorUnit";
    private Float majorUnit;

    public ChartValueAxis labels(ChartValueAxisLabels labels) {
        this.labels = labels;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartValueAxisLabels getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(ChartValueAxisLabels labels) {
        this.labels = labels;
    }

    public ChartValueAxis line(ChartValueAxisLine line) {
        this.line = line;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="line")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChartValueAxisLine getLine() {
        return this.line;
    }

    @JsonProperty(value="line")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine(ChartValueAxisLine line) {
        this.line = line;
    }

    public ChartValueAxis axisCrossingValue(Integer axisCrossingValue) {
        this.axisCrossingValue = axisCrossingValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="- (Only for objects) The value at which the category axis crosses this axis. - (Only for arrays) The value indices at which the category axes cross the value axis. - (Only for dates) The date at which the category axis crosses this axis.")
    @JsonProperty(value="axisCrossingValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAxisCrossingValue() {
        return this.axisCrossingValue;
    }

    @JsonProperty(value="axisCrossingValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAxisCrossingValue(Integer axisCrossingValue) {
        this.axisCrossingValue = axisCrossingValue;
    }

    public ChartValueAxis majorUnit(Float majorUnit) {
        this.majorUnit = majorUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The interval between major divisions. If `valueAxis.type` is set to `log`, the majorUnit value is used for the base of the logarithm.")
    @JsonProperty(value="majorUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getMajorUnit() {
        return this.majorUnit;
    }

    @JsonProperty(value="majorUnit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMajorUnit(Float majorUnit) {
        this.majorUnit = majorUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartValueAxis chartValueAxis = (ChartValueAxis)o;
        return Objects.equals(this.labels, chartValueAxis.labels) && Objects.equals(this.line, chartValueAxis.line) && Objects.equals(this.axisCrossingValue, chartValueAxis.axisCrossingValue) && Objects.equals(this.majorUnit, chartValueAxis.majorUnit);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.line, this.axisCrossingValue, this.majorUnit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartValueAxis {\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    line: ").append(this.toIndentedString(this.line)).append("\n");
        sb.append("    axisCrossingValue: ").append(this.toIndentedString(this.axisCrossingValue)).append("\n");
        sb.append("    majorUnit: ").append(this.toIndentedString(this.majorUnit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

