package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.InvoiceCollection;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:53.557808+07:00[Asia/Bangkok]")
public class InvoiceApi {
    private ApiClient apiClient;

    public InvoiceApi() {
        this(new ApiClient());
    }

    @Autowired
    public InvoiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Customer Invoices
     * Retrieve invoices for a particular customer.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param customerIdentifier The customerIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInvoicesForCustomerRequestCreation(String hotelIdentifier, String customerIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'customerIdentifier' is set
        if (customerIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'customerIdentifier' when calling showInvoicesForCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("customerIdentifier", customerIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/customer/{customerIdentifier}/invoice/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Customer Invoices
     * Retrieve invoices for a particular customer.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param customerIdentifier The customerIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InvoiceCollection> showInvoicesForCustomer(String hotelIdentifier, String customerIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForCustomerRequestCreation(hotelIdentifier, customerIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForCustomerWithHttpInfo(String hotelIdentifier, String customerIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForCustomerRequestCreation(hotelIdentifier, customerIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Subscription Invoices
     * Retrieve all all subscription invoices for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return List&lt;InvoiceCollection&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInvoicesForHotelRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForHotel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/subscription/invoice/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Subscription Invoices
     * Retrieve all all subscription invoices for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return List&lt;InvoiceCollection&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<InvoiceCollection> showInvoicesForHotel(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForHotelRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<InvoiceCollection>>> showInvoicesForHotelWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForHotelRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Property Invoices
     * Retrieve all invoices for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInvoicesForHotelCustomerRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForHotelCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/customer/invoice/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property Invoices
     * Retrieve all invoices for property.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InvoiceCollection> showInvoicesForHotelCustomer(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForHotelCustomerRequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForHotelCustomerWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForHotelCustomerRequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Invoices
     * Retrieve all invoices for a specific subscription
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param subscriptionIdentifier The subscriptionIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInvoicesForSubscriptionRequestCreation(String hotelIdentifier, String subscriptionIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForSubscription", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'subscriptionIdentifier' is set
        if (subscriptionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'subscriptionIdentifier' when calling showInvoicesForSubscription", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("subscriptionIdentifier", subscriptionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/subscription/{subscriptionIdentifier}/invoice/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Invoices
     * Retrieve all invoices for a specific subscription
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param subscriptionIdentifier The subscriptionIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InvoiceCollection> showInvoicesForSubscription(String hotelIdentifier, String subscriptionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForSubscriptionRequestCreation(hotelIdentifier, subscriptionIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForSubscriptionWithHttpInfo(String hotelIdentifier, String subscriptionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForSubscriptionRequestCreation(hotelIdentifier, subscriptionIdentifier, accept).toEntity(localVarReturnType);
    }
}
