package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.MeetingRoomView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertMeetingRoomRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:53.557808+07:00[Asia/Bangkok]")
public class MeetingRoomApi {
    private ApiClient apiClient;

    public MeetingRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public MeetingRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Meeting Room
     * Create a new meeting room
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new meeting room record and associate it with this hotel identifier
     * @param upsertMeetingRoomRequest The upsertMeetingRoomRequest parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createMeetingRoomRequestCreation(String hotelIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        Object postBody = upsertMeetingRoomRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertMeetingRoomRequest' is set
        if (upsertMeetingRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequest' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Meeting Room
     * Create a new meeting room
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new meeting room record and associate it with this hotel identifier
     * @param upsertMeetingRoomRequest The upsertMeetingRoomRequest parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomView> createMeetingRoom(String hotelIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return createMeetingRoomRequestCreation(hotelIdentifier, upsertMeetingRoomRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> createMeetingRoomWithHttpInfo(String hotelIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return createMeetingRoomRequestCreation(hotelIdentifier, upsertMeetingRoomRequest).toEntity(localVarReturnType);
    }
    /**
     * Delete Meeting Room
     * Remove a meeting room by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove meeting room with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Meeting Room
     * Remove a meeting room by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove meeting room with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Multimedia
     * Remove a meeting room&#39;s video or image by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove media for meeting room with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param accept The accept parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia4RequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove a meeting room&#39;s video or image by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove media for meeting room with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param accept The accept parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomView> removeMultimedia4(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return removeMultimedia4RequestCreation(hotelIdentifier, meetingRoomIdentifier, multimediaIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> removeMultimedia4WithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return removeMultimedia4RequestCreation(hotelIdentifier, meetingRoomIdentifier, multimediaIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Meeting Room
     * Retrieve a meeting room by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show a single meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Show meeting room for identifier
     * @param accept The accept parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Retrieve a meeting room by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show a single meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Show meeting room for identifier
     * @param accept The accept parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomView> showMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return showMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> showMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return showMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Reference Pairs
     * Retrieve list of meeting rooms as key/value pairs (identifier, name)
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting room key/value pairs associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMeetingRoomPairsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoomPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/list/pair", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of meeting rooms as key/value pairs (identifier, name)
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting room key/value pairs associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showMeetingRoomPairs(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showMeetingRoomPairsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showMeetingRoomPairsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showMeetingRoomPairsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Meeting Rooms
     * Retrieve list of meeting rooms
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting rooms associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;MeetingRoomView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMeetingRoomsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Rooms
     * Retrieve list of meeting rooms
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting rooms associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;MeetingRoomView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MeetingRoomView> showMeetingRooms(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return showMeetingRoomsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<MeetingRoomView>>> showMeetingRoomsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return showMeetingRoomsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Meeting Room
     * Update a meeting room by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Update meeting room with this identifier
     * @param upsertMeetingRoomRequest The upsertMeetingRoomRequest parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        Object postBody = upsertMeetingRoomRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertMeetingRoomRequest' is set
        if (upsertMeetingRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequest' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Meeting Room
     * Update a meeting room by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Update meeting room with this identifier
     * @param upsertMeetingRoomRequest The upsertMeetingRoomRequest parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomView> updateMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return updateMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> updateMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequest upsertMeetingRoomRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return updateMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequest).toEntity(localVarReturnType);
    }
    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to a meeting room identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload binary media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Upload binary media for meeting room with this hotel identifier
     * @param files The files parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadMeetingRoomMediaRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to a meeting room identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload binary media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Upload binary media for meeting room with this hotel identifier
     * @param files The files parameter
     * @return MeetingRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomView> uploadMeetingRoomMedia(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return uploadMeetingRoomMediaRequestCreation(hotelIdentifier, meetingRoomIdentifier, files).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomView>> uploadMeetingRoomMediaWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomView> localVarReturnType = new ParameterizedTypeReference<MeetingRoomView>() {};
        return uploadMeetingRoomMediaRequestCreation(hotelIdentifier, meetingRoomIdentifier, files).toEntity(localVarReturnType);
    }
}
