package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.PropertyPolicy;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:53.557808+07:00[Asia/Bangkok]")
public class PolicyApi {
    private ApiClient apiClient;

    public PolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create property policy for this hotel identifier
     * @param propertyPolicy The propertyPolicy parameter
     * @return PropertyPolicy
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPolicyRequestCreation(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        Object postBody = propertyPolicy;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyPolicy' is set
        if (propertyPolicy == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicy' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create property policy for this hotel identifier
     * @param propertyPolicy The propertyPolicy parameter
     * @return PropertyPolicy
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyPolicy> createPolicy(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return createPolicyRequestCreation(hotelIdentifier, propertyPolicy).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyPolicy>> createPolicyWithHttpInfo(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return createPolicyRequestCreation(hotelIdentifier, propertyPolicy).toEntity(localVarReturnType);
    }
    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property policy for this hotel identifier
     * @param accept The accept parameter
     * @return PropertyPolicy
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyPolicyRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property policy for this hotel identifier
     * @param accept The accept parameter
     * @return PropertyPolicy
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyPolicy> showPropertyPolicy(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return showPropertyPolicyRequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyPolicy>> showPropertyPolicyWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return showPropertyPolicyRequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update property policy record for this hotel identifier
     * @param propertyPolicy The propertyPolicy parameter
     * @return PropertyPolicy
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePropertyPolicyRequestCreation(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        Object postBody = propertyPolicy;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyPolicy' is set
        if (propertyPolicy == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicy' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update property policy record for this hotel identifier
     * @param propertyPolicy The propertyPolicy parameter
     * @return PropertyPolicy
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyPolicy> updatePropertyPolicy(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return updatePropertyPolicyRequestCreation(hotelIdentifier, propertyPolicy).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyPolicy>> updatePropertyPolicyWithHttpInfo(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>() {};
        return updatePropertyPolicyRequestCreation(hotelIdentifier, propertyPolicy).toEntity(localVarReturnType);
    }
}
