/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.14.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.BundleDescriptive;
import travel.wink.sdk.extranet.model.LocalizedPriceDescriptive;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PackageOfferDescriptive
 */
@JsonPropertyOrder({
  PackageOfferDescriptive.JSON_PROPERTY_PRICE,
  PackageOfferDescriptive.JSON_PROPERTY_UNIT_PRICE,
  PackageOfferDescriptive.JSON_PROPERTY_PACKAGE_IMAGE_URL,
  PackageOfferDescriptive.JSON_PROPERTY_BUNDLE,
  PackageOfferDescriptive.JSON_PROPERTY_OFFER_DETAILS,
  PackageOfferDescriptive.JSON_PROPERTY_PROMOTION,
  PackageOfferDescriptive.JSON_PROPERTY_GUESTS,
  PackageOfferDescriptive.JSON_PROPERTY_NIGHTS
})
@JsonTypeName("PackageOffer_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:53.557808+07:00[Asia/Bangkok]")
public class PackageOfferDescriptive {
  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPriceDescriptive price;

  public static final String JSON_PROPERTY_UNIT_PRICE = "unitPrice";
  private LocalizedPriceDescriptive unitPrice;

  public static final String JSON_PROPERTY_PACKAGE_IMAGE_URL = "packageImageUrl";
  private String packageImageUrl;

  public static final String JSON_PROPERTY_BUNDLE = "bundle";
  private BundleDescriptive bundle;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<SimpleDescriptionDescriptive> offerDetails = null;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Integer nights;

  public PackageOfferDescriptive() { 
  }

  public PackageOfferDescriptive price(LocalizedPriceDescriptive price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPriceDescriptive getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(LocalizedPriceDescriptive price) {
    this.price = price;
  }


  public PackageOfferDescriptive unitPrice(LocalizedPriceDescriptive unitPrice) {
    
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * Get unitPrice
   * @return unitPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPriceDescriptive getUnitPrice() {
    return unitPrice;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitPrice(LocalizedPriceDescriptive unitPrice) {
    this.unitPrice = unitPrice;
  }


  public PackageOfferDescriptive packageImageUrl(String packageImageUrl) {
    
    this.packageImageUrl = packageImageUrl;
    return this;
  }

   /**
   * Populated for when we send out confirmation emails to travelers.
   * @return packageImageUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Populated for when we send out confirmation emails to travelers.")
  @JsonProperty(JSON_PROPERTY_PACKAGE_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPackageImageUrl() {
    return packageImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageImageUrl(String packageImageUrl) {
    this.packageImageUrl = packageImageUrl;
  }


  public PackageOfferDescriptive bundle(BundleDescriptive bundle) {
    
    this.bundle = bundle;
    return this;
  }

   /**
   * Get bundle
   * @return bundle
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BUNDLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BundleDescriptive getBundle() {
    return bundle;
  }


  @JsonProperty(JSON_PROPERTY_BUNDLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBundle(BundleDescriptive bundle) {
    this.bundle = bundle;
  }


  public PackageOfferDescriptive offerDetails(List<SimpleDescriptionDescriptive> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public PackageOfferDescriptive addOfferDetailsItem(SimpleDescriptionDescriptive offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Localized offer details if any apply
   * @return offerDetails
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Localized offer details if any apply")
  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescriptionDescriptive> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<SimpleDescriptionDescriptive> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public PackageOfferDescriptive promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * If a package is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the package.
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If a package is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the package.")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  public PackageOfferDescriptive guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Number of guests
   * @return guests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of guests")
  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }


  public PackageOfferDescriptive nights(Integer nights) {
    
    this.nights = nights;
    return this;
  }

   /**
   * Number of nights
   * @return nights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of nights")
  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNights() {
    return nights;
  }


  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNights(Integer nights) {
    this.nights = nights;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PackageOfferDescriptive packageOfferDescriptive = (PackageOfferDescriptive) o;
    return Objects.equals(this.price, packageOfferDescriptive.price) &&
        Objects.equals(this.unitPrice, packageOfferDescriptive.unitPrice) &&
        Objects.equals(this.packageImageUrl, packageOfferDescriptive.packageImageUrl) &&
        Objects.equals(this.bundle, packageOfferDescriptive.bundle) &&
        Objects.equals(this.offerDetails, packageOfferDescriptive.offerDetails) &&
        Objects.equals(this.promotion, packageOfferDescriptive.promotion) &&
        Objects.equals(this.guests, packageOfferDescriptive.guests) &&
        Objects.equals(this.nights, packageOfferDescriptive.nights);
  }

  @Override
  public int hashCode() {
    return Objects.hash(price, unitPrice, packageImageUrl, bundle, offerDetails, promotion, guests, nights);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PackageOfferDescriptive {\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    packageImageUrl: ").append(toIndentedString(packageImageUrl)).append("\n");
    sb.append("    bundle: ").append(toIndentedString(bundle)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

