/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 21.14.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AdvanceBookingRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.ArrivalDaysOfWeekRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.AvailableDaysOfWeekRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.BlackoutDateDescriptive;
import travel.wink.sdk.extranet.model.CityRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.ContinentRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.CountryRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.DepartureDaysOfWeekRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.IPRangeRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.LengthOfStayRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.MinutesBeforeBookingStartDateRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.PrepayRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.PromotionRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.RateModifierModifier;
import travel.wink.sdk.extranet.model.RefundableRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.RequiredDaysOfWeekRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.RoomRangeRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.SellDateRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;
import travel.wink.sdk.extranet.model.StayDateRateQualifierDescriptive;
import travel.wink.sdk.extranet.model.TimezoneRateQualifierDescriptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Promotions that go together to make up this ancillary.
 */
@ApiModel(description = "Promotions that go together to make up this ancillary.")
@JsonPropertyOrder({
  RateModifierDescriptive.JSON_PROPERTY_IDENTIFIER,
  RateModifierDescriptive.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateModifierDescriptive.JSON_PROPERTY_NAME,
  RateModifierDescriptive.JSON_PROPERTY_TYPE,
  RateModifierDescriptive.JSON_PROPERTY_MODIFIER,
  RateModifierDescriptive.JSON_PROPERTY_ENABLED,
  RateModifierDescriptive.JSON_PROPERTY_PRICING_TYPE,
  RateModifierDescriptive.JSON_PROPERTY_DESCRIPTIONS,
  RateModifierDescriptive.JSON_PROPERTY_CITY_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_PREPAY_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierDescriptive.JSON_PROPERTY_MASTER_RATE_IDENTIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_PACKAGE_IDENTIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_ADD_ON_IDENTIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_RATE_PLAN_IDENTIFIERS,
  RateModifierDescriptive.JSON_PROPERTY_BLACKOUT_DATES
})
@JsonTypeName("RateModifier_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-06T15:30:53.557808+07:00[Asia/Bangkok]")
public class RateModifierDescriptive {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_MODIFIER = "modifier";
  private RateModifierModifier modifier;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    ADULT("PER_ADULT"),
    
    CHILD("PER_CHILD"),
    
    NIGHT("PER_NIGHT"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    HOUR("PER_HOUR"),
    
    PERSON_PER_STAY("PER_PERSON_PER_STAY"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_STAY("PER_ADULT_PER_STAY"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_STAY("PER_CHILD_PER_STAY"),
    
    USE("PER_USE"),
    
    PERSON_PER_USE("PER_PERSON_PER_USE");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionDescriptive> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_CITY_RATE_QUALIFIERS = "cityRateQualifiers";
  private List<CityRateQualifierDescriptive> cityRateQualifiers = null;

  public static final String JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS = "continentRateQualifiers";
  private List<ContinentRateQualifierDescriptive> continentRateQualifiers = null;

  public static final String JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS = "countryRateQualifiers";
  private List<CountryRateQualifierDescriptive> countryRateQualifiers = null;

  public static final String JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS = "promotionRateQualifiers";
  private List<PromotionRateQualifierDescriptive> promotionRateQualifiers = null;

  public static final String JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS = "ipRangeRateQualifiers";
  private List<IPRangeRateQualifierDescriptive> ipRangeRateQualifiers = null;

  public static final String JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER = "roomRangeRateQualifier";
  private RoomRangeRateQualifierDescriptive roomRangeRateQualifier;

  public static final String JSON_PROPERTY_PREPAY_RATE_QUALIFIER = "prepayRateQualifier";
  private PrepayRateQualifierDescriptive prepayRateQualifier;

  public static final String JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER = "refundableRateQualifier";
  private RefundableRateQualifierDescriptive refundableRateQualifier;

  public static final String JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS = "timezoneRateQualifiers";
  private List<TimezoneRateQualifierDescriptive> timezoneRateQualifiers = null;

  public static final String JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER = "lastMinuteRateQualifier";
  private MinutesBeforeBookingStartDateRateQualifierDescriptive lastMinuteRateQualifier;

  public static final String JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER = "lengthOfStayRateQualifier";
  private LengthOfStayRateQualifierDescriptive lengthOfStayRateQualifier;

  public static final String JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER = "advanceBookingRateQualifier";
  private AdvanceBookingRateQualifierDescriptive advanceBookingRateQualifier;

  public static final String JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS = "stayDateRateQualifiers";
  private List<StayDateRateQualifierDescriptive> stayDateRateQualifiers = null;

  public static final String JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS = "sellDateRateQualifiers";
  private List<SellDateRateQualifierDescriptive> sellDateRateQualifiers = null;

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER = "availableDaysOfWeekRateQualifier";
  private AvailableDaysOfWeekRateQualifierDescriptive availableDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER = "arrivalDaysOfWeekRateQualifier";
  private ArrivalDaysOfWeekRateQualifierDescriptive arrivalDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER = "departureDaysOfWeekRateQualifier";
  private DepartureDaysOfWeekRateQualifierDescriptive departureDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER = "requiredDaysOfWeekRateQualifier";
  private RequiredDaysOfWeekRateQualifierDescriptive requiredDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIERS = "masterRateIdentifiers";
  private List<String> masterRateIdentifiers = null;

  public static final String JSON_PROPERTY_PACKAGE_IDENTIFIERS = "packageIdentifiers";
  private List<String> packageIdentifiers = null;

  public static final String JSON_PROPERTY_ADD_ON_IDENTIFIERS = "addOnIdentifiers";
  private List<String> addOnIdentifiers = null;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIERS = "ratePlanIdentifiers";
  private List<String> ratePlanIdentifiers = null;

  public static final String JSON_PROPERTY_BLACKOUT_DATES = "blackoutDates";
  private List<BlackoutDateDescriptive> blackoutDates = null;

  public RateModifierDescriptive() { 
  }

  public RateModifierDescriptive identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RateModifierDescriptive hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Hotel identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateModifierDescriptive name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Early bird", required = true, value = "Internal name of promotion.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RateModifierDescriptive type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "DISCOUNT", required = true, value = "Set whether you want the price to go up or down when the rules of this promotion have been satisfied.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RateModifierDescriptive modifier(RateModifierModifier modifier) {
    
    this.modifier = modifier;
    return this;
  }

   /**
   * Get modifier
   * @return modifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RateModifierModifier getModifier() {
    return modifier;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifier(RateModifierModifier modifier) {
    this.modifier = modifier;
  }


  public RateModifierDescriptive enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion is enabled or not.
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this promotion is enabled or not.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public RateModifierDescriptive pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   * @return pricingType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "PER_PERSON_PER_NIGHT", required = true, value = "This determines whether this discount should be applied per night, per stay or per person - per night")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RateModifierDescriptive descriptions(List<SimpleDescriptionDescriptive> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public RateModifierDescriptive addDescriptionsItem(SimpleDescriptionDescriptive descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing promotion. At least one English entry is required.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Localized descriptions describing promotion. At least one English entry is required.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionDescriptive> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionDescriptive> descriptions) {
    this.descriptions = descriptions;
  }


  public RateModifierDescriptive cityRateQualifiers(List<CityRateQualifierDescriptive> cityRateQualifiers) {
    
    this.cityRateQualifiers = cityRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addCityRateQualifiersItem(CityRateQualifierDescriptive cityRateQualifiersItem) {
    if (this.cityRateQualifiers == null) {
      this.cityRateQualifiers = new ArrayList<>();
    }
    this.cityRateQualifiers.add(cityRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific cities. See [Geo-IP city geoname data](#operation/searchForCity)
   * @return cityRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific cities. See [Geo-IP city geoname data](#operation/searchForCity)")
  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CityRateQualifierDescriptive> getCityRateQualifiers() {
    return cityRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityRateQualifiers(List<CityRateQualifierDescriptive> cityRateQualifiers) {
    this.cityRateQualifiers = cityRateQualifiers;
  }


  public RateModifierDescriptive continentRateQualifiers(List<ContinentRateQualifierDescriptive> continentRateQualifiers) {
    
    this.continentRateQualifiers = continentRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addContinentRateQualifiersItem(ContinentRateQualifierDescriptive continentRateQualifiersItem) {
    if (this.continentRateQualifiers == null) {
      this.continentRateQualifiers = new ArrayList<>();
    }
    this.continentRateQualifiers.add(continentRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific continents. See [Geo-IP continent geoname data](#operation/showContinents)
   * @return continentRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific continents. See [Geo-IP continent geoname data](#operation/showContinents)")
  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ContinentRateQualifierDescriptive> getContinentRateQualifiers() {
    return continentRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentRateQualifiers(List<ContinentRateQualifierDescriptive> continentRateQualifiers) {
    this.continentRateQualifiers = continentRateQualifiers;
  }


  public RateModifierDescriptive countryRateQualifiers(List<CountryRateQualifierDescriptive> countryRateQualifiers) {
    
    this.countryRateQualifiers = countryRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addCountryRateQualifiersItem(CountryRateQualifierDescriptive countryRateQualifiersItem) {
    if (this.countryRateQualifiers == null) {
      this.countryRateQualifiers = new ArrayList<>();
    }
    this.countryRateQualifiers.add(countryRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific countries. See [Geo-IP country geoname data](#operation/showCountries)
   * @return countryRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific countries. See [Geo-IP country geoname data](#operation/showCountries)")
  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CountryRateQualifierDescriptive> getCountryRateQualifiers() {
    return countryRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryRateQualifiers(List<CountryRateQualifierDescriptive> countryRateQualifiers) {
    this.countryRateQualifiers = countryRateQualifiers;
  }


  public RateModifierDescriptive promotionRateQualifiers(List<PromotionRateQualifierDescriptive> promotionRateQualifiers) {
    
    this.promotionRateQualifiers = promotionRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addPromotionRateQualifiersItem(PromotionRateQualifierDescriptive promotionRateQualifiersItem) {
    if (this.promotionRateQualifiers == null) {
      this.promotionRateQualifiers = new ArrayList<>();
    }
    this.promotionRateQualifiers.add(promotionRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion by requiring users to enter a promo code.
   * @return promotionRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion by requiring users to enter a promo code.")
  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PromotionRateQualifierDescriptive> getPromotionRateQualifiers() {
    return promotionRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionRateQualifiers(List<PromotionRateQualifierDescriptive> promotionRateQualifiers) {
    this.promotionRateQualifiers = promotionRateQualifiers;
  }


  public RateModifierDescriptive ipRangeRateQualifiers(List<IPRangeRateQualifierDescriptive> ipRangeRateQualifiers) {
    
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addIpRangeRateQualifiersItem(IPRangeRateQualifierDescriptive ipRangeRateQualifiersItem) {
    if (this.ipRangeRateQualifiers == null) {
      this.ipRangeRateQualifiers = new ArrayList<>();
    }
    this.ipRangeRateQualifiers.add(ipRangeRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific IP ranges.
   * @return ipRangeRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific IP ranges.")
  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IPRangeRateQualifierDescriptive> getIpRangeRateQualifiers() {
    return ipRangeRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpRangeRateQualifiers(List<IPRangeRateQualifierDescriptive> ipRangeRateQualifiers) {
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
  }


  public RateModifierDescriptive roomRangeRateQualifier(RoomRangeRateQualifierDescriptive roomRangeRateQualifier) {
    
    this.roomRangeRateQualifier = roomRangeRateQualifier;
    return this;
  }

   /**
   * Get roomRangeRateQualifier
   * @return roomRangeRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomRangeRateQualifierDescriptive getRoomRangeRateQualifier() {
    return roomRangeRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRangeRateQualifier(RoomRangeRateQualifierDescriptive roomRangeRateQualifier) {
    this.roomRangeRateQualifier = roomRangeRateQualifier;
  }


  public RateModifierDescriptive prepayRateQualifier(PrepayRateQualifierDescriptive prepayRateQualifier) {
    
    this.prepayRateQualifier = prepayRateQualifier;
    return this;
  }

   /**
   * Get prepayRateQualifier
   * @return prepayRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrepayRateQualifierDescriptive getPrepayRateQualifier() {
    return prepayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrepayRateQualifier(PrepayRateQualifierDescriptive prepayRateQualifier) {
    this.prepayRateQualifier = prepayRateQualifier;
  }


  public RateModifierDescriptive refundableRateQualifier(RefundableRateQualifierDescriptive refundableRateQualifier) {
    
    this.refundableRateQualifier = refundableRateQualifier;
    return this;
  }

   /**
   * Get refundableRateQualifier
   * @return refundableRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableRateQualifierDescriptive getRefundableRateQualifier() {
    return refundableRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableRateQualifier(RefundableRateQualifierDescriptive refundableRateQualifier) {
    this.refundableRateQualifier = refundableRateQualifier;
  }


  public RateModifierDescriptive timezoneRateQualifiers(List<TimezoneRateQualifierDescriptive> timezoneRateQualifiers) {
    
    this.timezoneRateQualifiers = timezoneRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addTimezoneRateQualifiersItem(TimezoneRateQualifierDescriptive timezoneRateQualifiersItem) {
    if (this.timezoneRateQualifiers == null) {
      this.timezoneRateQualifiers = new ArrayList<>();
    }
    this.timezoneRateQualifiers.add(timezoneRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific time zones. See [Geo-IP timezone geoname data](#operation/showTimezones)
   * @return timezoneRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific time zones. See [Geo-IP timezone geoname data](#operation/showTimezones)")
  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TimezoneRateQualifierDescriptive> getTimezoneRateQualifiers() {
    return timezoneRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezoneRateQualifiers(List<TimezoneRateQualifierDescriptive> timezoneRateQualifiers) {
    this.timezoneRateQualifiers = timezoneRateQualifiers;
  }


  public RateModifierDescriptive lastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifierDescriptive lastMinuteRateQualifier) {
    
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
    return this;
  }

   /**
   * Get lastMinuteRateQualifier
   * @return lastMinuteRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MinutesBeforeBookingStartDateRateQualifierDescriptive getLastMinuteRateQualifier() {
    return lastMinuteRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifierDescriptive lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
  }


  public RateModifierDescriptive lengthOfStayRateQualifier(LengthOfStayRateQualifierDescriptive lengthOfStayRateQualifier) {
    
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
    return this;
  }

   /**
   * Get lengthOfStayRateQualifier
   * @return lengthOfStayRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LengthOfStayRateQualifierDescriptive getLengthOfStayRateQualifier() {
    return lengthOfStayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLengthOfStayRateQualifier(LengthOfStayRateQualifierDescriptive lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
  }


  public RateModifierDescriptive advanceBookingRateQualifier(AdvanceBookingRateQualifierDescriptive advanceBookingRateQualifier) {
    
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
    return this;
  }

   /**
   * Get advanceBookingRateQualifier
   * @return advanceBookingRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceBookingRateQualifierDescriptive getAdvanceBookingRateQualifier() {
    return advanceBookingRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceBookingRateQualifier(AdvanceBookingRateQualifierDescriptive advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
  }


  public RateModifierDescriptive stayDateRateQualifiers(List<StayDateRateQualifierDescriptive> stayDateRateQualifiers) {
    
    this.stayDateRateQualifiers = stayDateRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addStayDateRateQualifiersItem(StayDateRateQualifierDescriptive stayDateRateQualifiersItem) {
    if (this.stayDateRateQualifiers == null) {
      this.stayDateRateQualifiers = new ArrayList<>();
    }
    this.stayDateRateQualifiers.add(stayDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific stay dates the user wants to arrive.
   * @return stayDateRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific stay dates the user wants to arrive.")
  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<StayDateRateQualifierDescriptive> getStayDateRateQualifiers() {
    return stayDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayDateRateQualifiers(List<StayDateRateQualifierDescriptive> stayDateRateQualifiers) {
    this.stayDateRateQualifiers = stayDateRateQualifiers;
  }


  public RateModifierDescriptive sellDateRateQualifiers(List<SellDateRateQualifierDescriptive> sellDateRateQualifiers) {
    
    this.sellDateRateQualifiers = sellDateRateQualifiers;
    return this;
  }

  public RateModifierDescriptive addSellDateRateQualifiersItem(SellDateRateQualifierDescriptive sellDateRateQualifiersItem) {
    if (this.sellDateRateQualifiers == null) {
      this.sellDateRateQualifiers = new ArrayList<>();
    }
    this.sellDateRateQualifiers.add(sellDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific dates the booking is made.
   * @return sellDateRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific dates the booking is made.")
  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SellDateRateQualifierDescriptive> getSellDateRateQualifiers() {
    return sellDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellDateRateQualifiers(List<SellDateRateQualifierDescriptive> sellDateRateQualifiers) {
    this.sellDateRateQualifiers = sellDateRateQualifiers;
  }


  public RateModifierDescriptive availableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifierDescriptive availableDaysOfWeekRateQualifier) {
    
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get availableDaysOfWeekRateQualifier
   * @return availableDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AvailableDaysOfWeekRateQualifierDescriptive getAvailableDaysOfWeekRateQualifier() {
    return availableDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifierDescriptive availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
  }


  public RateModifierDescriptive arrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifierDescriptive arrivalDaysOfWeekRateQualifier) {
    
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get arrivalDaysOfWeekRateQualifier
   * @return arrivalDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ArrivalDaysOfWeekRateQualifierDescriptive getArrivalDaysOfWeekRateQualifier() {
    return arrivalDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifierDescriptive arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
  }


  public RateModifierDescriptive departureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifierDescriptive departureDaysOfWeekRateQualifier) {
    
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get departureDaysOfWeekRateQualifier
   * @return departureDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DepartureDaysOfWeekRateQualifierDescriptive getDepartureDaysOfWeekRateQualifier() {
    return departureDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifierDescriptive departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
  }


  public RateModifierDescriptive requiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifierDescriptive requiredDaysOfWeekRateQualifier) {
    
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get requiredDaysOfWeekRateQualifier
   * @return requiredDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RequiredDaysOfWeekRateQualifierDescriptive getRequiredDaysOfWeekRateQualifier() {
    return requiredDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifierDescriptive requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
  }


  public RateModifierDescriptive masterRateIdentifiers(List<String> masterRateIdentifiers) {
    
    this.masterRateIdentifiers = masterRateIdentifiers;
    return this;
  }

  public RateModifierDescriptive addMasterRateIdentifiersItem(String masterRateIdentifiersItem) {
    if (this.masterRateIdentifiers == null) {
      this.masterRateIdentifiers = new ArrayList<>();
    }
    this.masterRateIdentifiers.add(masterRateIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific master rates.
   * @return masterRateIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"master-rate-1\",\"master-rate-2\"]", value = "Restrict on specific master rates.")
  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMasterRateIdentifiers() {
    return masterRateIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateIdentifiers(List<String> masterRateIdentifiers) {
    this.masterRateIdentifiers = masterRateIdentifiers;
  }


  public RateModifierDescriptive packageIdentifiers(List<String> packageIdentifiers) {
    
    this.packageIdentifiers = packageIdentifiers;
    return this;
  }

  public RateModifierDescriptive addPackageIdentifiersItem(String packageIdentifiersItem) {
    if (this.packageIdentifiers == null) {
      this.packageIdentifiers = new ArrayList<>();
    }
    this.packageIdentifiers.add(packageIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific packages.
   * @return packageIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"package-1\",\"package-2\"]", value = "Restrict on specific packages.")
  @JsonProperty(JSON_PROPERTY_PACKAGE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPackageIdentifiers() {
    return packageIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageIdentifiers(List<String> packageIdentifiers) {
    this.packageIdentifiers = packageIdentifiers;
  }


  public RateModifierDescriptive addOnIdentifiers(List<String> addOnIdentifiers) {
    
    this.addOnIdentifiers = addOnIdentifiers;
    return this;
  }

  public RateModifierDescriptive addAddOnIdentifiersItem(String addOnIdentifiersItem) {
    if (this.addOnIdentifiers == null) {
      this.addOnIdentifiers = new ArrayList<>();
    }
    this.addOnIdentifiers.add(addOnIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific add-ons.
   * @return addOnIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"add-on-1\",\"add-on-2\"]", value = "Restrict on specific add-ons.")
  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAddOnIdentifiers() {
    return addOnIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnIdentifiers(List<String> addOnIdentifiers) {
    this.addOnIdentifiers = addOnIdentifiers;
  }


  public RateModifierDescriptive ratePlanIdentifiers(List<String> ratePlanIdentifiers) {
    
    this.ratePlanIdentifiers = ratePlanIdentifiers;
    return this;
  }

  public RateModifierDescriptive addRatePlanIdentifiersItem(String ratePlanIdentifiersItem) {
    if (this.ratePlanIdentifiers == null) {
      this.ratePlanIdentifiers = new ArrayList<>();
    }
    this.ratePlanIdentifiers.add(ratePlanIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific rate plans.
   * @return ratePlanIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"rate-plan-1\",\"rate-plan-2\"]", value = "Restrict on specific rate plans.")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRatePlanIdentifiers() {
    return ratePlanIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifiers(List<String> ratePlanIdentifiers) {
    this.ratePlanIdentifiers = ratePlanIdentifiers;
  }


  public RateModifierDescriptive blackoutDates(List<BlackoutDateDescriptive> blackoutDates) {
    
    this.blackoutDates = blackoutDates;
    return this;
  }

  public RateModifierDescriptive addBlackoutDatesItem(BlackoutDateDescriptive blackoutDatesItem) {
    if (this.blackoutDates == null) {
      this.blackoutDates = new ArrayList<>();
    }
    this.blackoutDates.add(blackoutDatesItem);
    return this;
  }

   /**
   * Exclude this promotion from specific date ranges.
   * @return blackoutDates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Exclude this promotion from specific date ranges.")
  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BlackoutDateDescriptive> getBlackoutDates() {
    return blackoutDates;
  }


  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlackoutDates(List<BlackoutDateDescriptive> blackoutDates) {
    this.blackoutDates = blackoutDates;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateModifierDescriptive rateModifierDescriptive = (RateModifierDescriptive) o;
    return Objects.equals(this.identifier, rateModifierDescriptive.identifier) &&
        Objects.equals(this.hotelIdentifier, rateModifierDescriptive.hotelIdentifier) &&
        Objects.equals(this.name, rateModifierDescriptive.name) &&
        Objects.equals(this.type, rateModifierDescriptive.type) &&
        Objects.equals(this.modifier, rateModifierDescriptive.modifier) &&
        Objects.equals(this.enabled, rateModifierDescriptive.enabled) &&
        Objects.equals(this.pricingType, rateModifierDescriptive.pricingType) &&
        Objects.equals(this.descriptions, rateModifierDescriptive.descriptions) &&
        Objects.equals(this.cityRateQualifiers, rateModifierDescriptive.cityRateQualifiers) &&
        Objects.equals(this.continentRateQualifiers, rateModifierDescriptive.continentRateQualifiers) &&
        Objects.equals(this.countryRateQualifiers, rateModifierDescriptive.countryRateQualifiers) &&
        Objects.equals(this.promotionRateQualifiers, rateModifierDescriptive.promotionRateQualifiers) &&
        Objects.equals(this.ipRangeRateQualifiers, rateModifierDescriptive.ipRangeRateQualifiers) &&
        Objects.equals(this.roomRangeRateQualifier, rateModifierDescriptive.roomRangeRateQualifier) &&
        Objects.equals(this.prepayRateQualifier, rateModifierDescriptive.prepayRateQualifier) &&
        Objects.equals(this.refundableRateQualifier, rateModifierDescriptive.refundableRateQualifier) &&
        Objects.equals(this.timezoneRateQualifiers, rateModifierDescriptive.timezoneRateQualifiers) &&
        Objects.equals(this.lastMinuteRateQualifier, rateModifierDescriptive.lastMinuteRateQualifier) &&
        Objects.equals(this.lengthOfStayRateQualifier, rateModifierDescriptive.lengthOfStayRateQualifier) &&
        Objects.equals(this.advanceBookingRateQualifier, rateModifierDescriptive.advanceBookingRateQualifier) &&
        Objects.equals(this.stayDateRateQualifiers, rateModifierDescriptive.stayDateRateQualifiers) &&
        Objects.equals(this.sellDateRateQualifiers, rateModifierDescriptive.sellDateRateQualifiers) &&
        Objects.equals(this.availableDaysOfWeekRateQualifier, rateModifierDescriptive.availableDaysOfWeekRateQualifier) &&
        Objects.equals(this.arrivalDaysOfWeekRateQualifier, rateModifierDescriptive.arrivalDaysOfWeekRateQualifier) &&
        Objects.equals(this.departureDaysOfWeekRateQualifier, rateModifierDescriptive.departureDaysOfWeekRateQualifier) &&
        Objects.equals(this.requiredDaysOfWeekRateQualifier, rateModifierDescriptive.requiredDaysOfWeekRateQualifier) &&
        Objects.equals(this.masterRateIdentifiers, rateModifierDescriptive.masterRateIdentifiers) &&
        Objects.equals(this.packageIdentifiers, rateModifierDescriptive.packageIdentifiers) &&
        Objects.equals(this.addOnIdentifiers, rateModifierDescriptive.addOnIdentifiers) &&
        Objects.equals(this.ratePlanIdentifiers, rateModifierDescriptive.ratePlanIdentifiers) &&
        Objects.equals(this.blackoutDates, rateModifierDescriptive.blackoutDates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, type, modifier, enabled, pricingType, descriptions, cityRateQualifiers, continentRateQualifiers, countryRateQualifiers, promotionRateQualifiers, ipRangeRateQualifiers, roomRangeRateQualifier, prepayRateQualifier, refundableRateQualifier, timezoneRateQualifiers, lastMinuteRateQualifier, lengthOfStayRateQualifier, advanceBookingRateQualifier, stayDateRateQualifiers, sellDateRateQualifiers, availableDaysOfWeekRateQualifier, arrivalDaysOfWeekRateQualifier, departureDaysOfWeekRateQualifier, requiredDaysOfWeekRateQualifier, masterRateIdentifiers, packageIdentifiers, addOnIdentifiers, ratePlanIdentifiers, blackoutDates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateModifierDescriptive {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    modifier: ").append(toIndentedString(modifier)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    cityRateQualifiers: ").append(toIndentedString(cityRateQualifiers)).append("\n");
    sb.append("    continentRateQualifiers: ").append(toIndentedString(continentRateQualifiers)).append("\n");
    sb.append("    countryRateQualifiers: ").append(toIndentedString(countryRateQualifiers)).append("\n");
    sb.append("    promotionRateQualifiers: ").append(toIndentedString(promotionRateQualifiers)).append("\n");
    sb.append("    ipRangeRateQualifiers: ").append(toIndentedString(ipRangeRateQualifiers)).append("\n");
    sb.append("    roomRangeRateQualifier: ").append(toIndentedString(roomRangeRateQualifier)).append("\n");
    sb.append("    prepayRateQualifier: ").append(toIndentedString(prepayRateQualifier)).append("\n");
    sb.append("    refundableRateQualifier: ").append(toIndentedString(refundableRateQualifier)).append("\n");
    sb.append("    timezoneRateQualifiers: ").append(toIndentedString(timezoneRateQualifiers)).append("\n");
    sb.append("    lastMinuteRateQualifier: ").append(toIndentedString(lastMinuteRateQualifier)).append("\n");
    sb.append("    lengthOfStayRateQualifier: ").append(toIndentedString(lengthOfStayRateQualifier)).append("\n");
    sb.append("    advanceBookingRateQualifier: ").append(toIndentedString(advanceBookingRateQualifier)).append("\n");
    sb.append("    stayDateRateQualifiers: ").append(toIndentedString(stayDateRateQualifiers)).append("\n");
    sb.append("    sellDateRateQualifiers: ").append(toIndentedString(sellDateRateQualifiers)).append("\n");
    sb.append("    availableDaysOfWeekRateQualifier: ").append(toIndentedString(availableDaysOfWeekRateQualifier)).append("\n");
    sb.append("    arrivalDaysOfWeekRateQualifier: ").append(toIndentedString(arrivalDaysOfWeekRateQualifier)).append("\n");
    sb.append("    departureDaysOfWeekRateQualifier: ").append(toIndentedString(departureDaysOfWeekRateQualifier)).append("\n");
    sb.append("    requiredDaysOfWeekRateQualifier: ").append(toIndentedString(requiredDaysOfWeekRateQualifier)).append("\n");
    sb.append("    masterRateIdentifiers: ").append(toIndentedString(masterRateIdentifiers)).append("\n");
    sb.append("    packageIdentifiers: ").append(toIndentedString(packageIdentifiers)).append("\n");
    sb.append("    addOnIdentifiers: ").append(toIndentedString(addOnIdentifiers)).append("\n");
    sb.append("    ratePlanIdentifiers: ").append(toIndentedString(ratePlanIdentifiers)).append("\n");
    sb.append("    blackoutDates: ").append(toIndentedString(blackoutDates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

