/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"startDate", "endDate", "adults", "children", "guests", "nights", "hours"})
public class Itinerary {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private OffsetDateTime startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private OffsetDateTime endDate;
    public static final String JSON_PROPERTY_ADULTS = "adults";
    private Integer adults;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private Integer children;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    private Integer guests;
    public static final String JSON_PROPERTY_NIGHTS = "nights";
    private Long nights;
    public static final String JSON_PROPERTY_HOURS = "hours";
    private Long hours;

    public Itinerary startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Start date")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public Itinerary endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="End date")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public Itinerary adults(Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(required=true, value="Number of adults")
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdults(Integer adults) {
        this.adults = adults;
    }

    public Itinerary children(Integer children) {
        this.children = children;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(required=true, value="Number of children")
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChildren(Integer children) {
        this.children = children;
    }

    public Itinerary guests(Integer guests) {
        this.guests = guests;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of adults and children")
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuests(Integer guests) {
        this.guests = guests;
    }

    public Itinerary nights(Long nights) {
        this.nights = nights;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of room nights")
    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNights() {
        return this.nights;
    }

    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNights(Long nights) {
        this.nights = nights;
    }

    public Itinerary hours(Long hours) {
        this.hours = hours;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of hours between start and end dates. Used for itineraries that require bookings that occur within hours and not days. E.g. Meeting room reservation.")
    @JsonProperty(value="hours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHours() {
        return this.hours;
    }

    @JsonProperty(value="hours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHours(Long hours) {
        this.hours = hours;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Itinerary itinerary = (Itinerary)o;
        return Objects.equals(this.startDate, itinerary.startDate) && Objects.equals(this.endDate, itinerary.endDate) && Objects.equals(this.adults, itinerary.adults) && Objects.equals(this.children, itinerary.children) && Objects.equals(this.guests, itinerary.guests) && Objects.equals(this.nights, itinerary.nights) && Objects.equals(this.hours, itinerary.hours);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.adults, this.children, this.guests, this.nights, this.hours);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Itinerary {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("    nights: ").append(this.toIndentedString(this.nights)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

