/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.MasterRateRatePlan;
import travel.wink.sdk.extranet.model.MasterRateRoom;

@ApiModel(description="A MasterRate pairs up a room type with a rate plan and some optional perks.")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "name", "guestRoomIdentifier", "ratePlanIdentifier", "room", "ratePlan", "enabled", "perkTypes", "perksValue"})
public class MasterRate {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_GUEST_ROOM_IDENTIFIER = "guestRoomIdentifier";
    private UUID guestRoomIdentifier;
    public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
    private UUID ratePlanIdentifier;
    public static final String JSON_PROPERTY_ROOM = "room";
    private MasterRateRoom room;
    public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
    private MasterRateRatePlan ratePlan;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
    private List<PerkTypesEnum> perkTypes = null;
    public static final String JSON_PROPERTY_PERKS_VALUE = "perksValue";
    private Integer perksValue;

    public MasterRate() {
    }

    @JsonCreator
    public MasterRate(@JsonProperty(value="name") String name) {
        this();
        this.name = name;
    }

    public MasterRate identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public MasterRate hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    @Nullable
    @ApiModelProperty(example="Premium King - BAR", value="Internal name of master rate. The name is generated by guest room and rate plan names respectively.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public MasterRate guestRoomIdentifier(UUID guestRoomIdentifier) {
        this.guestRoomIdentifier = guestRoomIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Guest room ID")
    @JsonProperty(value="guestRoomIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getGuestRoomIdentifier() {
        return this.guestRoomIdentifier;
    }

    @JsonProperty(value="guestRoomIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuestRoomIdentifier(UUID guestRoomIdentifier) {
        this.guestRoomIdentifier = guestRoomIdentifier;
    }

    public MasterRate ratePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Rate plan ID")
    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRatePlanIdentifier() {
        return this.ratePlanIdentifier;
    }

    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
    }

    public MasterRate room(MasterRateRoom room) {
        this.room = room;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MasterRateRoom getRoom() {
        return this.room;
    }

    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoom(MasterRateRoom room) {
        this.room = room;
    }

    public MasterRate ratePlan(MasterRateRatePlan ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MasterRateRatePlan getRatePlan() {
        return this.ratePlan;
    }

    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatePlan(MasterRateRatePlan ratePlan) {
        this.ratePlan = ratePlan;
    }

    public MasterRate enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Flag to enable / disable master rate across all sales channels")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public MasterRate perkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
        return this;
    }

    public MasterRate addPerkTypesItem(PerkTypesEnum perkTypesItem) {
        if (this.perkTypes == null) {
            this.perkTypes = new ArrayList<PerkTypesEnum>();
        }
        this.perkTypes.add(perkTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PerkTypesEnum> getPerkTypes() {
        return this.perkTypes;
    }

    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
    }

    public MasterRate perksValue(Integer perksValue) {
        this.perksValue = perksValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="perksValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerksValue() {
        return this.perksValue;
    }

    @JsonProperty(value="perksValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerksValue(Integer perksValue) {
        this.perksValue = perksValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MasterRate masterRate = (MasterRate)o;
        return Objects.equals(this.identifier, masterRate.identifier) && Objects.equals(this.hotelIdentifier, masterRate.hotelIdentifier) && Objects.equals(this.name, masterRate.name) && Objects.equals(this.guestRoomIdentifier, masterRate.guestRoomIdentifier) && Objects.equals(this.ratePlanIdentifier, masterRate.ratePlanIdentifier) && Objects.equals(this.room, masterRate.room) && Objects.equals(this.ratePlan, masterRate.ratePlan) && Objects.equals(this.enabled, masterRate.enabled) && Objects.equals(this.perkTypes, masterRate.perkTypes) && Objects.equals(this.perksValue, masterRate.perksValue);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.hotelIdentifier, this.name, this.guestRoomIdentifier, this.ratePlanIdentifier, this.room, this.ratePlan, this.enabled, this.perkTypes, this.perksValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MasterRate {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    guestRoomIdentifier: ").append(this.toIndentedString(this.guestRoomIdentifier)).append("\n");
        sb.append("    ratePlanIdentifier: ").append(this.toIndentedString(this.ratePlanIdentifier)).append("\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    ratePlan: ").append(this.toIndentedString(this.ratePlan)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    perkTypes: ").append(this.toIndentedString(this.perkTypes)).append("\n");
        sb.append("    perksValue: ").append(this.toIndentedString(this.perksValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PerkTypesEnum {
        LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
        WINE("PERK_WINE"),
        FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
        FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
        FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
        TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
        TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
        GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
        EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
        ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
        LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
        AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
        AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
        BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
        BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
        BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

        private String value;

        private PerkTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PerkTypesEnum fromValue(String value) {
            for (PerkTypesEnum b : PerkTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

