/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import travel.wink.sdk.extranet.model.Address;
import travel.wink.sdk.extranet.model.Contact;
import travel.wink.sdk.extranet.model.HotelOnMapLocation;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.PropertyPolicy;
import travel.wink.sdk.extranet.model.Recognition;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.Social;

@ApiModel(description="Combined property data.")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "name", "localName", "chain", "brand", "urlName", "starRating", "bookings", "aggregateReviewRating", "location", "shortDescriptions", "longDescriptions", "aggregateGreendexRating", "lifestyleTypes", "totalReviews", "available", "hotelAvailable", "reservations", "socials", "images", "videos", "policy", "thirdPartyReviews", "attractions", "recreations", "pois", "restaurants", "meetingRooms", "spas", "bundles", "upgrades", "fullNameOfGeneralManager", "profilePictureIdentifierGeneralManager", "messagesOfGeneralManager", "locationCategory", "segmentCategory", "hotelCategory", "architecturalStyle", "whenBuilt", "multimediaIdentifier", "imageIdentifier", "imageAngle", "videoIdentifier", "currencyCode", "membershipRateDiscount", "priceScore", "perkScore", "packageScore", "loyaltyScore", "popularScore", "experienceScore", "availabilityScore", "views", "hotelAmenityCodes", "propertyAccessibilityCodes", "propertySecurityCodes", "numberOfRooms", "address", "active", "urlParameters"})
public class HotelOnMap {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
    private String localName;
    public static final String JSON_PROPERTY_CHAIN = "chain";
    private String chain;
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    private String urlName;
    public static final String JSON_PROPERTY_STAR_RATING = "starRating";
    private Integer starRating;
    public static final String JSON_PROPERTY_BOOKINGS = "bookings";
    private Long bookings = 0L;
    public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
    private Float aggregateReviewRating = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_LOCATION = "location";
    private HotelOnMapLocation location;
    public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
    private List<SimpleDescription> shortDescriptions = null;
    public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
    private List<SimpleDescription> longDescriptions = null;
    public static final String JSON_PROPERTY_AGGREGATE_GREENDEX_RATING = "aggregateGreendexRating";
    private Float aggregateGreendexRating = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
    private List<LifestyleTypesEnum> lifestyleTypes = null;
    public static final String JSON_PROPERTY_TOTAL_REVIEWS = "totalReviews";
    private Integer totalReviews = 0;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available = false;
    public static final String JSON_PROPERTY_HOTEL_AVAILABLE = "hotelAvailable";
    private Boolean hotelAvailable = false;
    public static final String JSON_PROPERTY_RESERVATIONS = "reservations";
    private Contact reservations;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<Social> socials = null;
    public static final String JSON_PROPERTY_IMAGES = "images";
    private List<Multimedia> images = null;
    public static final String JSON_PROPERTY_VIDEOS = "videos";
    private List<Multimedia> videos = null;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private PropertyPolicy policy;
    public static final String JSON_PROPERTY_THIRD_PARTY_REVIEWS = "thirdPartyReviews";
    private List<Recognition> thirdPartyReviews = null;
    public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
    private Integer attractions = 0;
    public static final String JSON_PROPERTY_RECREATIONS = "recreations";
    private Integer recreations = 0;
    public static final String JSON_PROPERTY_POIS = "pois";
    private Integer pois = 0;
    public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
    private Integer restaurants = 0;
    public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
    private Integer meetingRooms = 0;
    public static final String JSON_PROPERTY_SPAS = "spas";
    private Integer spas = 0;
    public static final String JSON_PROPERTY_BUNDLES = "bundles";
    private Integer bundles = 0;
    public static final String JSON_PROPERTY_UPGRADES = "upgrades";
    private Integer upgrades = 0;
    public static final String JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER = "fullNameOfGeneralManager";
    private String fullNameOfGeneralManager;
    public static final String JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER = "profilePictureIdentifierGeneralManager";
    private String profilePictureIdentifierGeneralManager;
    public static final String JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER = "messagesOfGeneralManager";
    private List<SimpleDescription> messagesOfGeneralManager = null;
    public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
    private String locationCategory;
    public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
    private String segmentCategory;
    public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
    private String hotelCategory;
    public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
    private String architecturalStyle;
    public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
    private String whenBuilt;
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
    private String multimediaIdentifier;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_IMAGE_ANGLE = "imageAngle";
    private String imageAngle;
    public static final String JSON_PROPERTY_VIDEO_IDENTIFIER = "videoIdentifier";
    private String videoIdentifier;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT = "membershipRateDiscount";
    private Float membershipRateDiscount = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_PRICE_SCORE = "priceScore";
    private Integer priceScore = 0;
    public static final String JSON_PROPERTY_PERK_SCORE = "perkScore";
    private Integer perkScore = 0;
    public static final String JSON_PROPERTY_PACKAGE_SCORE = "packageScore";
    private Integer packageScore = 0;
    public static final String JSON_PROPERTY_LOYALTY_SCORE = "loyaltyScore";
    private Integer loyaltyScore = 0;
    public static final String JSON_PROPERTY_POPULAR_SCORE = "popularScore";
    private Integer popularScore = 0;
    public static final String JSON_PROPERTY_EXPERIENCE_SCORE = "experienceScore";
    private Integer experienceScore = 0;
    public static final String JSON_PROPERTY_AVAILABILITY_SCORE = "availabilityScore";
    private Integer availabilityScore = 0;
    public static final String JSON_PROPERTY_VIEWS = "views";
    private Long views = 0L;
    public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
    private List<String> hotelAmenityCodes = null;
    public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
    private List<String> propertyAccessibilityCodes = null;
    public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
    private List<String> propertySecurityCodes = null;
    public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
    private Integer numberOfRooms = 0;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_URL_PARAMETERS = "urlParameters";
    private String urlParameters;

    public HotelOnMap identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="document-1", value="Unique record identifier. This is NOT the same as the unique hotel record identifier.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public HotelOnMap hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique hotel record identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public HotelOnMap name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="The Loveliest Hotel", value="Hotel trade name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public HotelOnMap localName(String localName) {
        this.localName = localName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Det Beste Hotellet", value="Hotel local name if different from the trade name or if it is the local language.")
    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalName() {
        return this.localName;
    }

    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public HotelOnMap chain(String chain) {
        this.chain = chain;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Hotel chain", value="Name of hotel chain if applicable.")
    @JsonProperty(value="chain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChain() {
        return this.chain;
    }

    @JsonProperty(value="chain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChain(String chain) {
        this.chain = chain;
    }

    public HotelOnMap brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Hotel brand", value="Name of hotel brand")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public HotelOnMap urlName(String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="the-loveliest-hotel-new-york-united-states", value="Unique URL-friendly name slug of hotel")
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public HotelOnMap starRating(Integer starRating) {
        this.starRating = starRating;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=6L)
    @ApiModelProperty(example="4", value="Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.")
    @JsonProperty(value="starRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=6L) Integer getStarRating() {
        return this.starRating;
    }

    @JsonProperty(value="starRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStarRating(Integer starRating) {
        this.starRating = starRating;
    }

    public HotelOnMap bookings(Long bookings) {
        this.bookings = bookings;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6054", value="Number of bookings for this property on the wink.travel payment.")
    @JsonProperty(value="bookings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBookings() {
        return this.bookings;
    }

    @JsonProperty(value="bookings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookings(Long bookings) {
        this.bookings = bookings;
    }

    public HotelOnMap aggregateReviewRating(Float aggregateReviewRating) {
        this.aggregateReviewRating = aggregateReviewRating;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7.8", value="Aggregate score based on all current user reviews.")
    @JsonProperty(value="aggregateReviewRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getAggregateReviewRating() {
        return this.aggregateReviewRating;
    }

    @JsonProperty(value="aggregateReviewRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregateReviewRating(Float aggregateReviewRating) {
        this.aggregateReviewRating = aggregateReviewRating;
    }

    public HotelOnMap location(HotelOnMapLocation location) {
        this.location = location;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelOnMapLocation getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(HotelOnMapLocation location) {
        this.location = location;
    }

    public HotelOnMap shortDescriptions(List<SimpleDescription> shortDescriptions) {
        this.shortDescriptions = shortDescriptions;
        return this;
    }

    public HotelOnMap addShortDescriptionsItem(SimpleDescription shortDescriptionsItem) {
        if (this.shortDescriptions == null) {
            this.shortDescriptions = new ArrayList<SimpleDescription>();
        }
        this.shortDescriptions.add(shortDescriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="A localized list of short property descriptions")
    @JsonProperty(value="shortDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getShortDescriptions() {
        return this.shortDescriptions;
    }

    @JsonProperty(value="shortDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShortDescriptions(List<SimpleDescription> shortDescriptions) {
        this.shortDescriptions = shortDescriptions;
    }

    public HotelOnMap longDescriptions(List<SimpleDescription> longDescriptions) {
        this.longDescriptions = longDescriptions;
        return this;
    }

    public HotelOnMap addLongDescriptionsItem(SimpleDescription longDescriptionsItem) {
        if (this.longDescriptions == null) {
            this.longDescriptions = new ArrayList<SimpleDescription>();
        }
        this.longDescriptions.add(longDescriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="A localized list of longer property descriptions")
    @JsonProperty(value="longDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getLongDescriptions() {
        return this.longDescriptions;
    }

    @JsonProperty(value="longDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLongDescriptions(List<SimpleDescription> longDescriptions) {
        this.longDescriptions = longDescriptions;
    }

    public HotelOnMap aggregateGreendexRating(Float aggregateGreendexRating) {
        this.aggregateGreendexRating = aggregateGreendexRating;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7.0", value="Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.")
    @JsonProperty(value="aggregateGreendexRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getAggregateGreendexRating() {
        return this.aggregateGreendexRating;
    }

    @JsonProperty(value="aggregateGreendexRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregateGreendexRating(Float aggregateGreendexRating) {
        this.aggregateGreendexRating = aggregateGreendexRating;
    }

    public HotelOnMap lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
        this.lifestyleTypes = lifestyleTypes;
        return this;
    }

    public HotelOnMap addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
        if (this.lifestyleTypes == null) {
            this.lifestyleTypes = new ArrayList<LifestyleTypesEnum>();
        }
        this.lifestyleTypes.add(lifestyleTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lifestyleTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LifestyleTypesEnum> getLifestyleTypes() {
        return this.lifestyleTypes;
    }

    @JsonProperty(value="lifestyleTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
        this.lifestyleTypes = lifestyleTypes;
    }

    public HotelOnMap totalReviews(Integer totalReviews) {
        this.totalReviews = totalReviews;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="989", value="Count of total reviews left by users at this property.")
    @JsonProperty(value="totalReviews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalReviews() {
        return this.totalReviews;
    }

    @JsonProperty(value="totalReviews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalReviews(Integer totalReviews) {
        this.totalReviews = totalReviews;
    }

    public HotelOnMap available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag indicating whether the payment has made this property available for sale.")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public HotelOnMap hotelAvailable(Boolean hotelAvailable) {
        this.hotelAvailable = hotelAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag indicating whether the property has made this property available for sale.")
    @JsonProperty(value="hotelAvailable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHotelAvailable() {
        return this.hotelAvailable;
    }

    @JsonProperty(value="hotelAvailable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelAvailable(Boolean hotelAvailable) {
        this.hotelAvailable = hotelAvailable;
    }

    public HotelOnMap reservations(Contact reservations) {
        this.reservations = reservations;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="reservations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Contact getReservations() {
        return this.reservations;
    }

    @JsonProperty(value="reservations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservations(Contact reservations) {
        this.reservations = reservations;
    }

    public HotelOnMap socials(List<Social> socials) {
        this.socials = socials;
        return this;
    }

    public HotelOnMap addSocialsItem(Social socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<Social>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Property's social network accounts")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Social> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<Social> socials) {
        this.socials = socials;
    }

    public HotelOnMap images(List<Multimedia> images) {
        this.images = images;
        return this;
    }

    public HotelOnMap addImagesItem(Multimedia imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<Multimedia>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Property images.")
    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Multimedia> getImages() {
        return this.images;
    }

    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImages(List<Multimedia> images) {
        this.images = images;
    }

    public HotelOnMap videos(List<Multimedia> videos) {
        this.videos = videos;
        return this;
    }

    public HotelOnMap addVideosItem(Multimedia videosItem) {
        if (this.videos == null) {
            this.videos = new ArrayList<Multimedia>();
        }
        this.videos.add(videosItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Property videos.")
    @JsonProperty(value="videos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Multimedia> getVideos() {
        return this.videos;
    }

    @JsonProperty(value="videos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVideos(List<Multimedia> videos) {
        this.videos = videos;
    }

    public HotelOnMap policy(PropertyPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PropertyPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(PropertyPolicy policy) {
        this.policy = policy;
    }

    public HotelOnMap thirdPartyReviews(List<Recognition> thirdPartyReviews) {
        this.thirdPartyReviews = thirdPartyReviews;
        return this;
    }

    public HotelOnMap addThirdPartyReviewsItem(Recognition thirdPartyReviewsItem) {
        if (this.thirdPartyReviews == null) {
            this.thirdPartyReviews = new ArrayList<Recognition>();
        }
        this.thirdPartyReviews.add(thirdPartyReviewsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Array of awards and third party reviews given to property by certified / non-certified providers.")
    @JsonProperty(value="thirdPartyReviews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Recognition> getThirdPartyReviews() {
        return this.thirdPartyReviews;
    }

    @JsonProperty(value="thirdPartyReviews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThirdPartyReviews(List<Recognition> thirdPartyReviews) {
        this.thirdPartyReviews = thirdPartyReviews;
    }

    public HotelOnMap attractions(Integer attractions) {
        this.attractions = attractions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Number of attractions property has listed on its profile.")
    @JsonProperty(value="attractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAttractions() {
        return this.attractions;
    }

    @JsonProperty(value="attractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttractions(Integer attractions) {
        this.attractions = attractions;
    }

    public HotelOnMap recreations(Integer recreations) {
        this.recreations = recreations;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="Number of activites property has listed on its profile.")
    @JsonProperty(value="recreations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRecreations() {
        return this.recreations;
    }

    @JsonProperty(value="recreations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecreations(Integer recreations) {
        this.recreations = recreations;
    }

    public HotelOnMap pois(Integer pois) {
        this.pois = pois;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9", value="Number of places property has listed on its profile.")
    @JsonProperty(value="pois")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPois() {
        return this.pois;
    }

    @JsonProperty(value="pois")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPois(Integer pois) {
        this.pois = pois;
    }

    public HotelOnMap restaurants(Integer restaurants) {
        this.restaurants = restaurants;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Number of restaurants property has on its profile.")
    @JsonProperty(value="restaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRestaurants() {
        return this.restaurants;
    }

    @JsonProperty(value="restaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestaurants(Integer restaurants) {
        this.restaurants = restaurants;
    }

    public HotelOnMap meetingRooms(Integer meetingRooms) {
        this.meetingRooms = meetingRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Number of meeting rooms property has on its profile.")
    @JsonProperty(value="meetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMeetingRooms() {
        return this.meetingRooms;
    }

    @JsonProperty(value="meetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeetingRooms(Integer meetingRooms) {
        this.meetingRooms = meetingRooms;
    }

    public HotelOnMap spas(Integer spas) {
        this.spas = spas;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Number of spas property has on its profile.")
    @JsonProperty(value="spas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSpas() {
        return this.spas;
    }

    @JsonProperty(value="spas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpas(Integer spas) {
        this.spas = spas;
    }

    public HotelOnMap bundles(Integer bundles) {
        this.bundles = bundles;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Number of packages property has on its profile.")
    @JsonProperty(value="bundles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBundles() {
        return this.bundles;
    }

    @JsonProperty(value="bundles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBundles(Integer bundles) {
        this.bundles = bundles;
    }

    public HotelOnMap upgrades(Integer upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Number of add-ons property has on its profile.")
    @JsonProperty(value="upgrades")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUpgrades() {
        return this.upgrades;
    }

    @JsonProperty(value="upgrades")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpgrades(Integer upgrades) {
        this.upgrades = upgrades;
    }

    public HotelOnMap fullNameOfGeneralManager(String fullNameOfGeneralManager) {
        this.fullNameOfGeneralManager = fullNameOfGeneralManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="John Smith", value="Full name of the property's current and active general manager.")
    @JsonProperty(value="fullNameOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullNameOfGeneralManager() {
        return this.fullNameOfGeneralManager;
    }

    @JsonProperty(value="fullNameOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullNameOfGeneralManager(String fullNameOfGeneralManager) {
        this.fullNameOfGeneralManager = fullNameOfGeneralManager;
    }

    public HotelOnMap profilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
        this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cloudinary-identifier-1", value="Cloudinary identifier referencing image of general manager.")
    @JsonProperty(value="profilePictureIdentifierGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProfilePictureIdentifierGeneralManager() {
        return this.profilePictureIdentifierGeneralManager;
    }

    @JsonProperty(value="profilePictureIdentifierGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
        this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
    }

    public HotelOnMap messagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
        this.messagesOfGeneralManager = messagesOfGeneralManager;
        return this;
    }

    public HotelOnMap addMessagesOfGeneralManagerItem(SimpleDescription messagesOfGeneralManagerItem) {
        if (this.messagesOfGeneralManager == null) {
            this.messagesOfGeneralManager = new ArrayList<SimpleDescription>();
        }
        this.messagesOfGeneralManager.add(messagesOfGeneralManagerItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="We are excited to see you on our premises sooner than you can say lickedy split!", value="A list of localized welcome messages created by the property's general manager.")
    @JsonProperty(value="messagesOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getMessagesOfGeneralManager() {
        return this.messagesOfGeneralManager;
    }

    @JsonProperty(value="messagesOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
        this.messagesOfGeneralManager = messagesOfGeneralManager;
    }

    public HotelOnMap locationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="34", value="Supported OTA specification `LOC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocationCategory() {
        return this.locationCategory;
    }

    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
    }

    public HotelOnMap segmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Supported OTA specification `SEG` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSegmentCategory() {
        return this.segmentCategory;
    }

    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSegmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
    }

    public HotelOnMap hotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="45", value="Supported OTA specification `PCT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelCategory() {
        return this.hotelCategory;
    }

    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
    }

    public HotelOnMap architecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Supported OTA specification `ARC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchitecturalStyle() {
        return this.architecturalStyle;
    }

    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchitecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
    }

    public HotelOnMap whenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1927", value="Year the property was constructed.")
    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhenBuilt() {
        return this.whenBuilt;
    }

    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
    }

    public HotelOnMap multimediaIdentifier(String multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="media-1", value="Featured image identifier for this property.")
    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMultimediaIdentifier() {
        return this.multimediaIdentifier;
    }

    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimediaIdentifier(String multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
    }

    public HotelOnMap imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Featured Cloudinary image identifier for this property.")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public HotelOnMap imageAngle(String imageAngle) {
        this.imageAngle = imageAngle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-90", value="Meta data information about image angle that gives integrators a chance to crop this image properly.")
    @JsonProperty(value="imageAngle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageAngle() {
        return this.imageAngle;
    }

    @JsonProperty(value="imageAngle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageAngle(String imageAngle) {
        this.imageAngle = imageAngle;
    }

    public HotelOnMap videoIdentifier(String videoIdentifier) {
        this.videoIdentifier = videoIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Featured Cloudinary video identifier for this property.")
    @JsonProperty(value="videoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVideoIdentifier() {
        return this.videoIdentifier;
    }

    @JsonProperty(value="videoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVideoIdentifier(String videoIdentifier) {
        this.videoIdentifier = videoIdentifier;
    }

    public HotelOnMap currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency code for property.")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public HotelOnMap membershipRateDiscount(Float membershipRateDiscount) {
        this.membershipRateDiscount = membershipRateDiscount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.2", value="Average percent member discount weighed across all sales channels.")
    @JsonProperty(value="membershipRateDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getMembershipRateDiscount() {
        return this.membershipRateDiscount;
    }

    @JsonProperty(value="membershipRateDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMembershipRateDiscount(Float membershipRateDiscount) {
        this.membershipRateDiscount = membershipRateDiscount;
    }

    public HotelOnMap priceScore(Integer priceScore) {
        this.priceScore = priceScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9", value="A property's price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it's there to compare it against other properties.")
    @JsonProperty(value="priceScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPriceScore() {
        return this.priceScore;
    }

    @JsonProperty(value="priceScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriceScore(Integer priceScore) {
        this.priceScore = priceScore;
    }

    public HotelOnMap perkScore(Integer perkScore) {
        this.perkScore = perkScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="A property's perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it's there to compare it against other properties.")
    @JsonProperty(value="perkScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerkScore() {
        return this.perkScore;
    }

    @JsonProperty(value="perkScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkScore(Integer perkScore) {
        this.perkScore = perkScore;
    }

    public HotelOnMap packageScore(Integer packageScore) {
        this.packageScore = packageScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="A property's package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it's there to compare it against other properties.")
    @JsonProperty(value="packageScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPackageScore() {
        return this.packageScore;
    }

    @JsonProperty(value="packageScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackageScore(Integer packageScore) {
        this.packageScore = packageScore;
    }

    public HotelOnMap loyaltyScore(Integer loyaltyScore) {
        this.loyaltyScore = loyaltyScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="A property's loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it's there to compare it against other properties.")
    @JsonProperty(value="loyaltyScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLoyaltyScore() {
        return this.loyaltyScore;
    }

    @JsonProperty(value="loyaltyScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoyaltyScore(Integer loyaltyScore) {
        this.loyaltyScore = loyaltyScore;
    }

    public HotelOnMap popularScore(Integer popularScore) {
        this.popularScore = popularScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="45", value="A property's popular score is based on calculating number of bookings across room types. There is no max score; it's there to compare it against other properties.")
    @JsonProperty(value="popularScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPopularScore() {
        return this.popularScore;
    }

    @JsonProperty(value="popularScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPopularScore(Integer popularScore) {
        this.popularScore = popularScore;
    }

    public HotelOnMap experienceScore(Integer experienceScore) {
        this.experienceScore = experienceScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="A property's experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it's there to compare it against other properties.")
    @JsonProperty(value="experienceScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExperienceScore() {
        return this.experienceScore;
    }

    @JsonProperty(value="experienceScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperienceScore(Integer experienceScore) {
        this.experienceScore = experienceScore;
    }

    public HotelOnMap availabilityScore(Integer availabilityScore) {
        this.availabilityScore = availabilityScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="A property's availability score is based on general availability of all room types. If most room types are always unavailable, the attractiveness of this property goes down. We use this as our primary benchmark to decide how and when to feature properties. There is no max score; it's there to compare it against other properties.")
    @JsonProperty(value="availabilityScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAvailabilityScore() {
        return this.availabilityScore;
    }

    @JsonProperty(value="availabilityScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailabilityScore(Integer availabilityScore) {
        this.availabilityScore = availabilityScore;
    }

    public HotelOnMap views(Long views) {
        this.views = views;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10432", value="Total number of user views of this property.")
    @JsonProperty(value="views")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getViews() {
        return this.views;
    }

    @JsonProperty(value="views")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViews(Long views) {
        this.views = views;
    }

    public HotelOnMap hotelAmenityCodes(List<String> hotelAmenityCodes) {
        this.hotelAmenityCodes = hotelAmenityCodes;
        return this;
    }

    public HotelOnMap addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
        if (this.hotelAmenityCodes == null) {
            this.hotelAmenityCodes = new ArrayList<String>();
        }
        this.hotelAmenityCodes.add(hotelAmenityCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\",\"7\"]", value="Supported OTA specification `HAC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="hotelAmenityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHotelAmenityCodes() {
        return this.hotelAmenityCodes;
    }

    @JsonProperty(value="hotelAmenityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
        this.hotelAmenityCodes = hotelAmenityCodes;
    }

    public HotelOnMap propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
        this.propertyAccessibilityCodes = propertyAccessibilityCodes;
        return this;
    }

    public HotelOnMap addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
        if (this.propertyAccessibilityCodes == null) {
            this.propertyAccessibilityCodes = new ArrayList<String>();
        }
        this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\",\"7\"]", value="Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="propertyAccessibilityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPropertyAccessibilityCodes() {
        return this.propertyAccessibilityCodes;
    }

    @JsonProperty(value="propertyAccessibilityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
        this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    }

    public HotelOnMap propertySecurityCodes(List<String> propertySecurityCodes) {
        this.propertySecurityCodes = propertySecurityCodes;
        return this;
    }

    public HotelOnMap addPropertySecurityCodesItem(String propertySecurityCodesItem) {
        if (this.propertySecurityCodes == null) {
            this.propertySecurityCodes = new ArrayList<String>();
        }
        this.propertySecurityCodes.add(propertySecurityCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\",\"7\"]", value="Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="propertySecurityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPropertySecurityCodes() {
        return this.propertySecurityCodes;
    }

    @JsonProperty(value="propertySecurityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
        this.propertySecurityCodes = propertySecurityCodes;
    }

    public HotelOnMap numberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="32", value="Number of rooms / keys for this property.")
    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public HotelOnMap address(Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public HotelOnMap active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="A property is considered active when both available and hotelAvailable flags are true.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public HotelOnMap urlParameters(String urlParameters) {
        this.urlParameters = urlParameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Convenience data point that creates url friendly query parameters of property.")
    @JsonProperty(value="urlParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrlParameters() {
        return this.urlParameters;
    }

    @JsonProperty(value="urlParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrlParameters(String urlParameters) {
        this.urlParameters = urlParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelOnMap hotelOnMap = (HotelOnMap)o;
        return Objects.equals(this.identifier, hotelOnMap.identifier) && Objects.equals(this.hotelIdentifier, hotelOnMap.hotelIdentifier) && Objects.equals(this.name, hotelOnMap.name) && Objects.equals(this.localName, hotelOnMap.localName) && Objects.equals(this.chain, hotelOnMap.chain) && Objects.equals(this.brand, hotelOnMap.brand) && Objects.equals(this.urlName, hotelOnMap.urlName) && Objects.equals(this.starRating, hotelOnMap.starRating) && Objects.equals(this.bookings, hotelOnMap.bookings) && Objects.equals(this.aggregateReviewRating, hotelOnMap.aggregateReviewRating) && Objects.equals(this.location, hotelOnMap.location) && Objects.equals(this.shortDescriptions, hotelOnMap.shortDescriptions) && Objects.equals(this.longDescriptions, hotelOnMap.longDescriptions) && Objects.equals(this.aggregateGreendexRating, hotelOnMap.aggregateGreendexRating) && Objects.equals(this.lifestyleTypes, hotelOnMap.lifestyleTypes) && Objects.equals(this.totalReviews, hotelOnMap.totalReviews) && Objects.equals(this.available, hotelOnMap.available) && Objects.equals(this.hotelAvailable, hotelOnMap.hotelAvailable) && Objects.equals(this.reservations, hotelOnMap.reservations) && Objects.equals(this.socials, hotelOnMap.socials) && Objects.equals(this.images, hotelOnMap.images) && Objects.equals(this.videos, hotelOnMap.videos) && Objects.equals(this.policy, hotelOnMap.policy) && Objects.equals(this.thirdPartyReviews, hotelOnMap.thirdPartyReviews) && Objects.equals(this.attractions, hotelOnMap.attractions) && Objects.equals(this.recreations, hotelOnMap.recreations) && Objects.equals(this.pois, hotelOnMap.pois) && Objects.equals(this.restaurants, hotelOnMap.restaurants) && Objects.equals(this.meetingRooms, hotelOnMap.meetingRooms) && Objects.equals(this.spas, hotelOnMap.spas) && Objects.equals(this.bundles, hotelOnMap.bundles) && Objects.equals(this.upgrades, hotelOnMap.upgrades) && Objects.equals(this.fullNameOfGeneralManager, hotelOnMap.fullNameOfGeneralManager) && Objects.equals(this.profilePictureIdentifierGeneralManager, hotelOnMap.profilePictureIdentifierGeneralManager) && Objects.equals(this.messagesOfGeneralManager, hotelOnMap.messagesOfGeneralManager) && Objects.equals(this.locationCategory, hotelOnMap.locationCategory) && Objects.equals(this.segmentCategory, hotelOnMap.segmentCategory) && Objects.equals(this.hotelCategory, hotelOnMap.hotelCategory) && Objects.equals(this.architecturalStyle, hotelOnMap.architecturalStyle) && Objects.equals(this.whenBuilt, hotelOnMap.whenBuilt) && Objects.equals(this.multimediaIdentifier, hotelOnMap.multimediaIdentifier) && Objects.equals(this.imageIdentifier, hotelOnMap.imageIdentifier) && Objects.equals(this.imageAngle, hotelOnMap.imageAngle) && Objects.equals(this.videoIdentifier, hotelOnMap.videoIdentifier) && Objects.equals(this.currencyCode, hotelOnMap.currencyCode) && Objects.equals(this.membershipRateDiscount, hotelOnMap.membershipRateDiscount) && Objects.equals(this.priceScore, hotelOnMap.priceScore) && Objects.equals(this.perkScore, hotelOnMap.perkScore) && Objects.equals(this.packageScore, hotelOnMap.packageScore) && Objects.equals(this.loyaltyScore, hotelOnMap.loyaltyScore) && Objects.equals(this.popularScore, hotelOnMap.popularScore) && Objects.equals(this.experienceScore, hotelOnMap.experienceScore) && Objects.equals(this.availabilityScore, hotelOnMap.availabilityScore) && Objects.equals(this.views, hotelOnMap.views) && Objects.equals(this.hotelAmenityCodes, hotelOnMap.hotelAmenityCodes) && Objects.equals(this.propertyAccessibilityCodes, hotelOnMap.propertyAccessibilityCodes) && Objects.equals(this.propertySecurityCodes, hotelOnMap.propertySecurityCodes) && Objects.equals(this.numberOfRooms, hotelOnMap.numberOfRooms) && Objects.equals(this.address, hotelOnMap.address) && Objects.equals(this.active, hotelOnMap.active) && Objects.equals(this.urlParameters, hotelOnMap.urlParameters);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.hotelIdentifier, this.name, this.localName, this.chain, this.brand, this.urlName, this.starRating, this.bookings, this.aggregateReviewRating, this.location, this.shortDescriptions, this.longDescriptions, this.aggregateGreendexRating, this.lifestyleTypes, this.totalReviews, this.available, this.hotelAvailable, this.reservations, this.socials, this.images, this.videos, this.policy, this.thirdPartyReviews, this.attractions, this.recreations, this.pois, this.restaurants, this.meetingRooms, this.spas, this.bundles, this.upgrades, this.fullNameOfGeneralManager, this.profilePictureIdentifierGeneralManager, this.messagesOfGeneralManager, this.locationCategory, this.segmentCategory, this.hotelCategory, this.architecturalStyle, this.whenBuilt, this.multimediaIdentifier, this.imageIdentifier, this.imageAngle, this.videoIdentifier, this.currencyCode, this.membershipRateDiscount, this.priceScore, this.perkScore, this.packageScore, this.loyaltyScore, this.popularScore, this.experienceScore, this.availabilityScore, this.views, this.hotelAmenityCodes, this.propertyAccessibilityCodes, this.propertySecurityCodes, this.numberOfRooms, this.address, this.active, this.urlParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelOnMap {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    localName: ").append(this.toIndentedString(this.localName)).append("\n");
        sb.append("    chain: ").append(this.toIndentedString(this.chain)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    starRating: ").append(this.toIndentedString(this.starRating)).append("\n");
        sb.append("    bookings: ").append(this.toIndentedString(this.bookings)).append("\n");
        sb.append("    aggregateReviewRating: ").append(this.toIndentedString(this.aggregateReviewRating)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    shortDescriptions: ").append(this.toIndentedString(this.shortDescriptions)).append("\n");
        sb.append("    longDescriptions: ").append(this.toIndentedString(this.longDescriptions)).append("\n");
        sb.append("    aggregateGreendexRating: ").append(this.toIndentedString(this.aggregateGreendexRating)).append("\n");
        sb.append("    lifestyleTypes: ").append(this.toIndentedString(this.lifestyleTypes)).append("\n");
        sb.append("    totalReviews: ").append(this.toIndentedString(this.totalReviews)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    hotelAvailable: ").append(this.toIndentedString(this.hotelAvailable)).append("\n");
        sb.append("    reservations: ").append(this.toIndentedString(this.reservations)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    videos: ").append(this.toIndentedString(this.videos)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    thirdPartyReviews: ").append(this.toIndentedString(this.thirdPartyReviews)).append("\n");
        sb.append("    attractions: ").append(this.toIndentedString(this.attractions)).append("\n");
        sb.append("    recreations: ").append(this.toIndentedString(this.recreations)).append("\n");
        sb.append("    pois: ").append(this.toIndentedString(this.pois)).append("\n");
        sb.append("    restaurants: ").append(this.toIndentedString(this.restaurants)).append("\n");
        sb.append("    meetingRooms: ").append(this.toIndentedString(this.meetingRooms)).append("\n");
        sb.append("    spas: ").append(this.toIndentedString(this.spas)).append("\n");
        sb.append("    bundles: ").append(this.toIndentedString(this.bundles)).append("\n");
        sb.append("    upgrades: ").append(this.toIndentedString(this.upgrades)).append("\n");
        sb.append("    fullNameOfGeneralManager: ").append(this.toIndentedString(this.fullNameOfGeneralManager)).append("\n");
        sb.append("    profilePictureIdentifierGeneralManager: ").append(this.toIndentedString(this.profilePictureIdentifierGeneralManager)).append("\n");
        sb.append("    messagesOfGeneralManager: ").append(this.toIndentedString(this.messagesOfGeneralManager)).append("\n");
        sb.append("    locationCategory: ").append(this.toIndentedString(this.locationCategory)).append("\n");
        sb.append("    segmentCategory: ").append(this.toIndentedString(this.segmentCategory)).append("\n");
        sb.append("    hotelCategory: ").append(this.toIndentedString(this.hotelCategory)).append("\n");
        sb.append("    architecturalStyle: ").append(this.toIndentedString(this.architecturalStyle)).append("\n");
        sb.append("    whenBuilt: ").append(this.toIndentedString(this.whenBuilt)).append("\n");
        sb.append("    multimediaIdentifier: ").append(this.toIndentedString(this.multimediaIdentifier)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    imageAngle: ").append(this.toIndentedString(this.imageAngle)).append("\n");
        sb.append("    videoIdentifier: ").append(this.toIndentedString(this.videoIdentifier)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    membershipRateDiscount: ").append(this.toIndentedString(this.membershipRateDiscount)).append("\n");
        sb.append("    priceScore: ").append(this.toIndentedString(this.priceScore)).append("\n");
        sb.append("    perkScore: ").append(this.toIndentedString(this.perkScore)).append("\n");
        sb.append("    packageScore: ").append(this.toIndentedString(this.packageScore)).append("\n");
        sb.append("    loyaltyScore: ").append(this.toIndentedString(this.loyaltyScore)).append("\n");
        sb.append("    popularScore: ").append(this.toIndentedString(this.popularScore)).append("\n");
        sb.append("    experienceScore: ").append(this.toIndentedString(this.experienceScore)).append("\n");
        sb.append("    availabilityScore: ").append(this.toIndentedString(this.availabilityScore)).append("\n");
        sb.append("    views: ").append(this.toIndentedString(this.views)).append("\n");
        sb.append("    hotelAmenityCodes: ").append(this.toIndentedString(this.hotelAmenityCodes)).append("\n");
        sb.append("    propertyAccessibilityCodes: ").append(this.toIndentedString(this.propertyAccessibilityCodes)).append("\n");
        sb.append("    propertySecurityCodes: ").append(this.toIndentedString(this.propertySecurityCodes)).append("\n");
        sb.append("    numberOfRooms: ").append(this.toIndentedString(this.numberOfRooms)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    urlParameters: ").append(this.toIndentedString(this.urlParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LifestyleTypesEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypesEnum fromValue(String value) {
            for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

