/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.extranet.model.MoneysDescriptive;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;
import travel.wink.sdk.extranet.model.SimpleMultimediaDescriptive;

@ApiModel(description="This is one bookable unit that can stand alongside a restaurant / meeting room etc.")
@JsonPropertyOrder(value={"identifier", "name", "descriptions", "pricingType", "fee", "percentDiscount", "multimedias", "minPax", "maxPax"})
@JsonTypeName(value="TransactionalTravelInventory_Descriptive")
public class TransactionalTravelInventoryDescriptive {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionDescriptive> descriptions = new ArrayList<SimpleDescriptionDescriptive>();
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_FEE = "fee";
    private MoneysDescriptive fee;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    private Double percentDiscount;
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaDescriptive> multimedias = new ArrayList<SimpleMultimediaDescriptive>();
    public static final String JSON_PROPERTY_MIN_PAX = "minPax";
    private Integer minPax;
    public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
    private Integer maxPax;

    public TransactionalTravelInventoryDescriptive identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique transactional identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public TransactionalTravelInventoryDescriptive name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1 hour session", required=true, value="Internal name of transactional inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public TransactionalTravelInventoryDescriptive descriptions(List<SimpleDescriptionDescriptive> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public TransactionalTravelInventoryDescriptive addDescriptionsItem(SimpleDescriptionDescriptive descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescriptionDescriptive> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionDescriptive> descriptions) {
        this.descriptions = descriptions;
    }

    public TransactionalTravelInventoryDescriptive pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="How this inventory item should be priced.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public TransactionalTravelInventoryDescriptive fee(MoneysDescriptive fee) {
        this.fee = fee;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysDescriptive getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFee(MoneysDescriptive fee) {
        this.fee = fee;
    }

    public TransactionalTravelInventoryDescriptive percentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.2", required=true, value="Expected savings. Indicate how much the traveler is [usually] saving by booking it through this payment. Example: 20% discount.")
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") @DecimalMax(value="1.0") Double getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPercentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public TransactionalTravelInventoryDescriptive multimedias(List<SimpleMultimediaDescriptive> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public TransactionalTravelInventoryDescriptive addMultimediasItem(SimpleMultimediaDescriptive multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of item.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimediaDescriptive> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimediaDescriptive> multimedias) {
        this.multimedias = multimedias;
    }

    public TransactionalTravelInventoryDescriptive minPax(Integer minPax) {
        this.minPax = minPax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Whether there is a limit to minimum group size.")
    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinPax() {
        return this.minPax;
    }

    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinPax(Integer minPax) {
        this.minPax = minPax;
    }

    public TransactionalTravelInventoryDescriptive maxPax(Integer maxPax) {
        this.maxPax = maxPax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Whether there is a limit to maximum group size.")
    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxPax() {
        return this.maxPax;
    }

    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxPax(Integer maxPax) {
        this.maxPax = maxPax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionalTravelInventoryDescriptive transactionalTravelInventoryDescriptive = (TransactionalTravelInventoryDescriptive)o;
        return Objects.equals(this.identifier, transactionalTravelInventoryDescriptive.identifier) && Objects.equals(this.name, transactionalTravelInventoryDescriptive.name) && Objects.equals(this.descriptions, transactionalTravelInventoryDescriptive.descriptions) && Objects.equals((Object)this.pricingType, (Object)transactionalTravelInventoryDescriptive.pricingType) && Objects.equals(this.fee, transactionalTravelInventoryDescriptive.fee) && Objects.equals(this.percentDiscount, transactionalTravelInventoryDescriptive.percentDiscount) && Objects.equals(this.multimedias, transactionalTravelInventoryDescriptive.multimedias) && Objects.equals(this.minPax, transactionalTravelInventoryDescriptive.minPax) && Objects.equals(this.maxPax, transactionalTravelInventoryDescriptive.maxPax);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.descriptions, this.pricingType, this.fee, this.percentDiscount, this.multimedias, this.minPax, this.maxPax});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionalTravelInventoryDescriptive {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    minPax: ").append(this.toIndentedString(this.minPax)).append("\n");
        sb.append("    maxPax: ").append(this.toIndentedString(this.maxPax)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        PERSON_PER_USE("PER_PERSON_PER_USE"),
        USE("PER_USE"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

