package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.Announcement;
import travel.wink.sdk.extranet.model.AnnouncementView;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:36:20.822132243+07:00[Asia/Bangkok]")
public class AnnouncementApi {
    private ApiClient apiClient;

    public AnnouncementApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnnouncementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create announcement for this hotel identifier
     * @param announcement The announcement parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAnnouncementRequestCreation(String hotelIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        Object postBody = announcement;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcement' is set
        if (announcement == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcement' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create announcement for this hotel identifier
     * @param announcement The announcement parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementView> createAnnouncement(String hotelIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return createAnnouncementRequestCreation(hotelIdentifier, announcement, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementView>> createAnnouncementWithHttpInfo(String hotelIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return createAnnouncementRequestCreation(hotelIdentifier, announcement, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove announcement for this hotel identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove announcement for this hotel identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcement for this hotel identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcement for this hotel identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementView> showAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementView>> showAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcements for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AnnouncementView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnnouncementsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncements", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcements for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AnnouncementView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AnnouncementView> showAnnouncements(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<AnnouncementView>>> showAnnouncementsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update announcement for this hotel identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param announcement The announcement parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        Object postBody = announcement;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcement' is set
        if (announcement == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcement' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update announcement for this hotel identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param announcement The announcement parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementView> updateAnnouncement(String hotelIdentifier, String announcementIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, announcement, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementView>> updateAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>() {};
        return updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, announcement, winkVersion).toEntity(localVarReturnType);
    }
}
