package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.HotelView;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpdateLocationRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:36:20.822132243+07:00[Asia/Bangkok]")
public class GeoLocationApi {
    private ApiClient apiClient;

    public GeoLocationApi() {
        this(new ApiClient());
    }

    @Autowired
    public GeoLocationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Set geo-location
     * Update property geo-location. Note: x &#x3D; longitude, y &#x3D; latitude, type &#x3D; Point, coordinates &#x3D; [longitude, latitude].
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update geo-location for this hotel identifier
     * @param updateLocationRequest The updateLocationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateGeoLocationRequestCreation(String hotelIdentifier, UpdateLocationRequest updateLocationRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = updateLocationRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateLocationRequest' is set
        if (updateLocationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateLocationRequest' when calling updateGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/location", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set geo-location
     * Update property geo-location. Note: x &#x3D; longitude, y &#x3D; latitude, type &#x3D; Point, coordinates &#x3D; [longitude, latitude].
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update geo-location for this hotel identifier
     * @param updateLocationRequest The updateLocationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> updateGeoLocation(String hotelIdentifier, UpdateLocationRequest updateLocationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateGeoLocationRequestCreation(hotelIdentifier, updateLocationRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> updateGeoLocationWithHttpInfo(String hotelIdentifier, UpdateLocationRequest updateLocationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return updateGeoLocationRequestCreation(hotelIdentifier, updateLocationRequest, winkVersion).toEntity(localVarReturnType);
    }
}
