/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 23.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.DescriptiveReasonDescriptive;
import travel.wink.sdk.extranet.model.DescriptiveRoomTypeWithPriceConfigurationsDescriptive;
import travel.wink.sdk.extranet.model.InventoryDescriptive;
import travel.wink.sdk.extranet.model.MasterRateDescriptive;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DescriptiveRoomDescriptive
 */
@JsonPropertyOrder({
  DescriptiveRoomDescriptive.JSON_PROPERTY_IDENTIFIER,
  DescriptiveRoomDescriptive.JSON_PROPERTY_ROOM_NAME,
  DescriptiveRoomDescriptive.JSON_PROPERTY_ACCESSIBLE_MASTER_RATES,
  DescriptiveRoomDescriptive.JSON_PROPERTY_INACCESSIBLE_MASTER_RATES,
  DescriptiveRoomDescriptive.JSON_PROPERTY_ACCESSIBLE_INVENTORY,
  DescriptiveRoomDescriptive.JSON_PROPERTY_ACCESSIBLE_RATE_PLANS,
  DescriptiveRoomDescriptive.JSON_PROPERTY_INACCESSIBLE_RATE_PLANS,
  DescriptiveRoomDescriptive.JSON_PROPERTY_ACCESSIBLE_AVAILABILITY,
  DescriptiveRoomDescriptive.JSON_PROPERTY_INACCESSIBLE_AVAILABILITY
})
@JsonTypeName("DescriptiveRoom_Descriptive")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:36:20.822132243+07:00[Asia/Bangkok]")
public class DescriptiveRoomDescriptive {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ROOM_NAME = "roomName";
  private String roomName;

  public static final String JSON_PROPERTY_ACCESSIBLE_MASTER_RATES = "accessibleMasterRates";
  private List<MasterRateDescriptive> accessibleMasterRates = null;

  public static final String JSON_PROPERTY_INACCESSIBLE_MASTER_RATES = "inaccessibleMasterRates";
  private List<DescriptiveReasonDescriptive> inaccessibleMasterRates = null;

  public static final String JSON_PROPERTY_ACCESSIBLE_INVENTORY = "accessibleInventory";
  private List<InventoryDescriptive> accessibleInventory = null;

  public static final String JSON_PROPERTY_ACCESSIBLE_RATE_PLANS = "accessibleRatePlans";
  private List<DescriptiveReasonDescriptive> accessibleRatePlans = null;

  public static final String JSON_PROPERTY_INACCESSIBLE_RATE_PLANS = "inaccessibleRatePlans";
  private List<DescriptiveReasonDescriptive> inaccessibleRatePlans = null;

  public static final String JSON_PROPERTY_ACCESSIBLE_AVAILABILITY = "accessibleAvailability";
  private List<DescriptiveRoomTypeWithPriceConfigurationsDescriptive> accessibleAvailability = null;

  public static final String JSON_PROPERTY_INACCESSIBLE_AVAILABILITY = "inaccessibleAvailability";
  private List<DescriptiveReasonDescriptive> inaccessibleAvailability = null;

  public DescriptiveRoomDescriptive() { 
  }

  public DescriptiveRoomDescriptive identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Get identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public DescriptiveRoomDescriptive roomName(String roomName) {
    
    this.roomName = roomName;
    return this;
  }

   /**
   * Get roomName
   * @return roomName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomName() {
    return roomName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomName(String roomName) {
    this.roomName = roomName;
  }


  public DescriptiveRoomDescriptive accessibleMasterRates(List<MasterRateDescriptive> accessibleMasterRates) {
    
    this.accessibleMasterRates = accessibleMasterRates;
    return this;
  }

  public DescriptiveRoomDescriptive addAccessibleMasterRatesItem(MasterRateDescriptive accessibleMasterRatesItem) {
    if (this.accessibleMasterRates == null) {
      this.accessibleMasterRates = new ArrayList<>();
    }
    this.accessibleMasterRates.add(accessibleMasterRatesItem);
    return this;
  }

   /**
   * Get accessibleMasterRates
   * @return accessibleMasterRates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MasterRateDescriptive> getAccessibleMasterRates() {
    return accessibleMasterRates;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleMasterRates(List<MasterRateDescriptive> accessibleMasterRates) {
    this.accessibleMasterRates = accessibleMasterRates;
  }


  public DescriptiveRoomDescriptive inaccessibleMasterRates(List<DescriptiveReasonDescriptive> inaccessibleMasterRates) {
    
    this.inaccessibleMasterRates = inaccessibleMasterRates;
    return this;
  }

  public DescriptiveRoomDescriptive addInaccessibleMasterRatesItem(DescriptiveReasonDescriptive inaccessibleMasterRatesItem) {
    if (this.inaccessibleMasterRates == null) {
      this.inaccessibleMasterRates = new ArrayList<>();
    }
    this.inaccessibleMasterRates.add(inaccessibleMasterRatesItem);
    return this;
  }

   /**
   * Get inaccessibleMasterRates
   * @return inaccessibleMasterRates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonDescriptive> getInaccessibleMasterRates() {
    return inaccessibleMasterRates;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleMasterRates(List<DescriptiveReasonDescriptive> inaccessibleMasterRates) {
    this.inaccessibleMasterRates = inaccessibleMasterRates;
  }


  public DescriptiveRoomDescriptive accessibleInventory(List<InventoryDescriptive> accessibleInventory) {
    
    this.accessibleInventory = accessibleInventory;
    return this;
  }

  public DescriptiveRoomDescriptive addAccessibleInventoryItem(InventoryDescriptive accessibleInventoryItem) {
    if (this.accessibleInventory == null) {
      this.accessibleInventory = new ArrayList<>();
    }
    this.accessibleInventory.add(accessibleInventoryItem);
    return this;
  }

   /**
   * Get accessibleInventory
   * @return accessibleInventory
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<InventoryDescriptive> getAccessibleInventory() {
    return accessibleInventory;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleInventory(List<InventoryDescriptive> accessibleInventory) {
    this.accessibleInventory = accessibleInventory;
  }


  public DescriptiveRoomDescriptive accessibleRatePlans(List<DescriptiveReasonDescriptive> accessibleRatePlans) {
    
    this.accessibleRatePlans = accessibleRatePlans;
    return this;
  }

  public DescriptiveRoomDescriptive addAccessibleRatePlansItem(DescriptiveReasonDescriptive accessibleRatePlansItem) {
    if (this.accessibleRatePlans == null) {
      this.accessibleRatePlans = new ArrayList<>();
    }
    this.accessibleRatePlans.add(accessibleRatePlansItem);
    return this;
  }

   /**
   * Get accessibleRatePlans
   * @return accessibleRatePlans
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonDescriptive> getAccessibleRatePlans() {
    return accessibleRatePlans;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleRatePlans(List<DescriptiveReasonDescriptive> accessibleRatePlans) {
    this.accessibleRatePlans = accessibleRatePlans;
  }


  public DescriptiveRoomDescriptive inaccessibleRatePlans(List<DescriptiveReasonDescriptive> inaccessibleRatePlans) {
    
    this.inaccessibleRatePlans = inaccessibleRatePlans;
    return this;
  }

  public DescriptiveRoomDescriptive addInaccessibleRatePlansItem(DescriptiveReasonDescriptive inaccessibleRatePlansItem) {
    if (this.inaccessibleRatePlans == null) {
      this.inaccessibleRatePlans = new ArrayList<>();
    }
    this.inaccessibleRatePlans.add(inaccessibleRatePlansItem);
    return this;
  }

   /**
   * Get inaccessibleRatePlans
   * @return inaccessibleRatePlans
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonDescriptive> getInaccessibleRatePlans() {
    return inaccessibleRatePlans;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleRatePlans(List<DescriptiveReasonDescriptive> inaccessibleRatePlans) {
    this.inaccessibleRatePlans = inaccessibleRatePlans;
  }


  public DescriptiveRoomDescriptive accessibleAvailability(List<DescriptiveRoomTypeWithPriceConfigurationsDescriptive> accessibleAvailability) {
    
    this.accessibleAvailability = accessibleAvailability;
    return this;
  }

  public DescriptiveRoomDescriptive addAccessibleAvailabilityItem(DescriptiveRoomTypeWithPriceConfigurationsDescriptive accessibleAvailabilityItem) {
    if (this.accessibleAvailability == null) {
      this.accessibleAvailability = new ArrayList<>();
    }
    this.accessibleAvailability.add(accessibleAvailabilityItem);
    return this;
  }

   /**
   * Get accessibleAvailability
   * @return accessibleAvailability
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveRoomTypeWithPriceConfigurationsDescriptive> getAccessibleAvailability() {
    return accessibleAvailability;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleAvailability(List<DescriptiveRoomTypeWithPriceConfigurationsDescriptive> accessibleAvailability) {
    this.accessibleAvailability = accessibleAvailability;
  }


  public DescriptiveRoomDescriptive inaccessibleAvailability(List<DescriptiveReasonDescriptive> inaccessibleAvailability) {
    
    this.inaccessibleAvailability = inaccessibleAvailability;
    return this;
  }

  public DescriptiveRoomDescriptive addInaccessibleAvailabilityItem(DescriptiveReasonDescriptive inaccessibleAvailabilityItem) {
    if (this.inaccessibleAvailability == null) {
      this.inaccessibleAvailability = new ArrayList<>();
    }
    this.inaccessibleAvailability.add(inaccessibleAvailabilityItem);
    return this;
  }

   /**
   * Get inaccessibleAvailability
   * @return inaccessibleAvailability
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonDescriptive> getInaccessibleAvailability() {
    return inaccessibleAvailability;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleAvailability(List<DescriptiveReasonDescriptive> inaccessibleAvailability) {
    this.inaccessibleAvailability = inaccessibleAvailability;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DescriptiveRoomDescriptive descriptiveRoomDescriptive = (DescriptiveRoomDescriptive) o;
    return Objects.equals(this.identifier, descriptiveRoomDescriptive.identifier) &&
        Objects.equals(this.roomName, descriptiveRoomDescriptive.roomName) &&
        Objects.equals(this.accessibleMasterRates, descriptiveRoomDescriptive.accessibleMasterRates) &&
        Objects.equals(this.inaccessibleMasterRates, descriptiveRoomDescriptive.inaccessibleMasterRates) &&
        Objects.equals(this.accessibleInventory, descriptiveRoomDescriptive.accessibleInventory) &&
        Objects.equals(this.accessibleRatePlans, descriptiveRoomDescriptive.accessibleRatePlans) &&
        Objects.equals(this.inaccessibleRatePlans, descriptiveRoomDescriptive.inaccessibleRatePlans) &&
        Objects.equals(this.accessibleAvailability, descriptiveRoomDescriptive.accessibleAvailability) &&
        Objects.equals(this.inaccessibleAvailability, descriptiveRoomDescriptive.inaccessibleAvailability);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, roomName, accessibleMasterRates, inaccessibleMasterRates, accessibleInventory, accessibleRatePlans, inaccessibleRatePlans, accessibleAvailability, inaccessibleAvailability);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DescriptiveRoomDescriptive {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    roomName: ").append(toIndentedString(roomName)).append("\n");
    sb.append("    accessibleMasterRates: ").append(toIndentedString(accessibleMasterRates)).append("\n");
    sb.append("    inaccessibleMasterRates: ").append(toIndentedString(inaccessibleMasterRates)).append("\n");
    sb.append("    accessibleInventory: ").append(toIndentedString(accessibleInventory)).append("\n");
    sb.append("    accessibleRatePlans: ").append(toIndentedString(accessibleRatePlans)).append("\n");
    sb.append("    inaccessibleRatePlans: ").append(toIndentedString(inaccessibleRatePlans)).append("\n");
    sb.append("    accessibleAvailability: ").append(toIndentedString(accessibleAvailability)).append("\n");
    sb.append("    inaccessibleAvailability: ").append(toIndentedString(inaccessibleAvailability)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

