/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CompanyDetailsBookingSalesMetrics;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.PageCompanyBookingSalesMetrics;
import travel.wink.sdk.extranet.model.State;

public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec browseAffiliatesRequestCreation(String hotelIdentifier, State state, String winkVersion) throws WebClientResponseException {
        State postBody = state;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling browseAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling browseAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageCompanyBookingSalesMetrics> localVarReturnType = new ParameterizedTypeReference<PageCompanyBookingSalesMetrics>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageCompanyBookingSalesMetrics> browseAffiliates(String hotelIdentifier, State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageCompanyBookingSalesMetrics> localVarReturnType = new ParameterizedTypeReference<PageCompanyBookingSalesMetrics>(){};
        return this.browseAffiliatesRequestCreation(hotelIdentifier, state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageCompanyBookingSalesMetrics>> browseAffiliatesWithHttpInfo(String hotelIdentifier, State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageCompanyBookingSalesMetrics> localVarReturnType = new ParameterizedTypeReference<PageCompanyBookingSalesMetrics>(){};
        return this.browseAffiliatesRequestCreation(hotelIdentifier, state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAffiliateRequestCreation(String hotelIdentifier, String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAffiliate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAffiliate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyDetailsBookingSalesMetrics> localVarReturnType = new ParameterizedTypeReference<CompanyDetailsBookingSalesMetrics>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/{companyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyDetailsBookingSalesMetrics> showAffiliate(String hotelIdentifier, String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyDetailsBookingSalesMetrics> localVarReturnType = new ParameterizedTypeReference<CompanyDetailsBookingSalesMetrics>(){};
        return this.showAffiliateRequestCreation(hotelIdentifier, companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyDetailsBookingSalesMetrics>> showAffiliateWithHttpInfo(String hotelIdentifier, String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyDetailsBookingSalesMetrics> localVarReturnType = new ParameterizedTypeReference<CompanyDetailsBookingSalesMetrics>(){};
        return this.showAffiliateRequestCreation(hotelIdentifier, companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showUniqueCityListRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showUniqueCityList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showUniqueCityList(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showUniqueCityListRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showUniqueCityListWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showUniqueCityListRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showUniqueCountryListRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showUniqueCountryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showUniqueCountryList(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showUniqueCountryListRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showUniqueCountryListWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showUniqueCountryListRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

