/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.Announcement;
import travel.wink.sdk.extranet.model.AnnouncementView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;

public class AnnouncementApi {
    private ApiClient apiClient;

    public AnnouncementApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnnouncementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAnnouncementRequestCreation(String hotelIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        Announcement postBody = announcement;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcement == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcement' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementView> createAnnouncement(String hotelIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.createAnnouncementRequestCreation(hotelIdentifier, announcement, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementView>> createAnnouncementWithHttpInfo(String hotelIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.createAnnouncementRequestCreation(hotelIdentifier, announcement, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementView> showAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementView>> showAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAnnouncementsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncements", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AnnouncementView> showAnnouncements(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AnnouncementView>>> showAnnouncementsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        Announcement postBody = announcement;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcement == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcement' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementView> updateAnnouncement(String hotelIdentifier, String announcementIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, announcement, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementView>> updateAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, Announcement announcement, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementView> localVarReturnType = new ParameterizedTypeReference<AnnouncementView>(){};
        return this.updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, announcement, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

