/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CancellationPolicyRemovableResponse;
import travel.wink.sdk.extranet.model.CancellationPolicyView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.UpsertCancellationPolicyRequest;

public class CancellationPolicyApi {
    private ApiClient apiClient;

    public CancellationPolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CancellationPolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCancellationPolicyRequestCreation(String hotelIdentifier, UpsertCancellationPolicyRequest upsertCancellationPolicyRequest, String winkVersion) throws WebClientResponseException {
        UpsertCancellationPolicyRequest postBody = upsertCancellationPolicyRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCancellationPolicyRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequest' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyView> createCancellationPolicy(String hotelIdentifier, UpsertCancellationPolicyRequest upsertCancellationPolicyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyView>> createCancellationPolicyWithHttpInfo(String hotelIdentifier, UpsertCancellationPolicyRequest upsertCancellationPolicyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec isCancellationPolicyRemovableRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyRemovableResponse> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}/removable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyRemovableResponse> isCancellationPolicyRemovable(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponse> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponse>(){};
        return this.isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyRemovableResponse>> isCancellationPolicyRemovableWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponse> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponse>(){};
        return this.isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyView> showCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyView>> showCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCancellationPolicyListRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CancellationPolicyView> showCancellationPolicyList(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CancellationPolicyView>>> showCancellationPolicyListWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequest upsertCancellationPolicyRequest, String winkVersion) throws WebClientResponseException {
        UpsertCancellationPolicyRequest postBody = upsertCancellationPolicyRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCancellationPolicyRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequest' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyView> updateCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequest upsertCancellationPolicyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyView>> updateCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequest upsertCancellationPolicyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyView> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyView>(){};
        return this.updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

