/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.BundleView;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.PackageRemovableResponse;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.UpsertBundleRequest;

public class PackageApi {
    private ApiClient apiClient;

    public PackageApi() {
        this(new ApiClient());
    }

    @Autowired
    public PackageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addMediaRequestCreation(String hotelIdentifier, String packageIdentifier, Multimedia multimedia, String winkVersion) throws WebClientResponseException {
        Multimedia postBody = multimedia;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling addMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling addMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimedia' when calling addMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BundleView> addMedia(String hotelIdentifier, String packageIdentifier, Multimedia multimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.addMediaRequestCreation(hotelIdentifier, packageIdentifier, multimedia, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> addMediaWithHttpInfo(String hotelIdentifier, String packageIdentifier, Multimedia multimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.addMediaRequestCreation(hotelIdentifier, packageIdentifier, multimedia, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createPackageRequestCreation(String hotelIdentifier, UpsertBundleRequest upsertBundleRequest, String winkVersion) throws WebClientResponseException {
        UpsertBundleRequest postBody = upsertBundleRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBundleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBundleRequest' when calling createPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BundleView> createPackage(String hotelIdentifier, UpsertBundleRequest upsertBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.createPackageRequestCreation(hotelIdentifier, upsertBundleRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> createPackageWithHttpInfo(String hotelIdentifier, UpsertBundleRequest upsertBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.createPackageRequestCreation(hotelIdentifier, upsertBundleRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removableBundleRequestCreation(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling removableBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PackageRemovableResponse> localVarReturnType = new ParameterizedTypeReference<PackageRemovableResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/removable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PackageRemovableResponse> removableBundle(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PackageRemovableResponse> localVarReturnType = new ParameterizedTypeReference<PackageRemovableResponse>(){};
        return this.removableBundleRequestCreation(hotelIdentifier, packageIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PackageRemovableResponse>> removableBundleWithHttpInfo(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PackageRemovableResponse> localVarReturnType = new ParameterizedTypeReference<PackageRemovableResponse>(){};
        return this.removableBundleRequestCreation(hotelIdentifier, packageIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeMultimedia5RequestCreation(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia5", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling removeMultimedia5", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia5", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BundleView> removeMultimedia5(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.removeMultimedia5RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> removeMultimedia5WithHttpInfo(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.removeMultimedia5RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removePackageRequestCreation(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling removePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removePackage(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removePackageRequestCreation(hotelIdentifier, packageIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removePackageWithHttpInfo(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removePackageRequestCreation(hotelIdentifier, packageIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPackageRequestCreation(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling showPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BundleView> showPackage(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.showPackageRequestCreation(hotelIdentifier, packageIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> showPackageWithHttpInfo(String hotelIdentifier, String packageIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.showPackageRequestCreation(hotelIdentifier, packageIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPackagesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPackages", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BundleView> showPackages(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.showPackagesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BundleView>>> showPackagesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.showPackagesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateMultimedia1RequestCreation(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, Multimedia multimedia, String winkVersion) throws WebClientResponseException {
        Multimedia postBody = multimedia;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimedia' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BundleView> updateMultimedia1(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, Multimedia multimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.updateMultimedia1RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, multimedia, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> updateMultimedia1WithHttpInfo(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, Multimedia multimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.updateMultimedia1RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, multimedia, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updatePackageRequestCreation(String hotelIdentifier, String packageIdentifier, UpsertBundleRequest upsertBundleRequest, String winkVersion) throws WebClientResponseException {
        UpsertBundleRequest postBody = upsertBundleRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling updatePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBundleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBundleRequest' when calling updatePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BundleView> updatePackage(String hotelIdentifier, String packageIdentifier, UpsertBundleRequest upsertBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.updatePackageRequestCreation(hotelIdentifier, packageIdentifier, upsertBundleRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> updatePackageWithHttpInfo(String hotelIdentifier, String packageIdentifier, UpsertBundleRequest upsertBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.updatePackageRequestCreation(hotelIdentifier, packageIdentifier, upsertBundleRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec uploadBinaryPackageMediaRequestCreation(String hotelIdentifier, String packageIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadBinaryPackageMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling uploadBinaryPackageMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadBinaryPackageMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BundleView> uploadBinaryPackageMedia(String hotelIdentifier, String packageIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.uploadBinaryPackageMediaRequestCreation(hotelIdentifier, packageIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> uploadBinaryPackageMediaWithHttpInfo(String hotelIdentifier, String packageIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>(){};
        return this.uploadBinaryPackageMediaRequestCreation(hotelIdentifier, packageIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

