/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.RateModifierBundleView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.UpsertRateModifierBundleRequest;

public class PromotionBundleApi {
    private ApiClient apiClient;

    public PromotionBundleApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionBundleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRateModifierBundleRequestCreation(String hotelIdentifier, UpsertRateModifierBundleRequest upsertRateModifierBundleRequest, String winkVersion) throws WebClientResponseException {
        UpsertRateModifierBundleRequest postBody = upsertRateModifierBundleRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierBundleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequest' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierBundleView> createRateModifierBundle(String hotelIdentifier, UpsertRateModifierBundleRequest upsertRateModifierBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleView>> createRateModifierBundleWithHttpInfo(String hotelIdentifier, UpsertRateModifierBundleRequest upsertRateModifierBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierBundleView> showRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleView>> showRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showRateModifierBundlesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateModifierBundleView> showRateModifierBundles(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateModifierBundleView>>> showRateModifierBundlesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequest upsertRateModifierBundleRequest, String winkVersion) throws WebClientResponseException {
        UpsertRateModifierBundleRequest postBody = upsertRateModifierBundleRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierBundleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequest' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierBundleView> updateRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequest upsertRateModifierBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleView>> updateRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequest upsertRateModifierBundleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>(){};
        return this.updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

