/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.SalesChannelRelationshipRequestView;
import travel.wink.sdk.extranet.model.UpsertSalesChannelRelationshipRequestRequest;

public class SalesChannelRelationshipRequestsApi {
    private ApiClient apiClient;

    public SalesChannelRelationshipRequestsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelRelationshipRequestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSalesChannelRequestRequestCreation(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        UpsertSalesChannelRelationshipRequestRequest postBody = upsertSalesChannelRelationshipRequestRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSalesChannelRelationshipRequestRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSalesChannelRelationshipRequestRequest' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRelationshipRequestView> createSalesChannelRequest(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRelationshipRequestView>> createSalesChannelRequestWithHttpInfo(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeSalesChannelRequestRequestCreation(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request/{salesChannelRequestIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRelationshipRequestView> removeSalesChannelRequest(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRelationshipRequestView>> removeSalesChannelRequestWithHttpInfo(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSalesChannelRequestsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelRelationshipRequestView> showSalesChannelRequests(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelRelationshipRequestView>>> showSalesChannelRequestsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(){};
        return this.showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

