/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.AddressDescriptive;
import travel.wink.sdk.extranet.model.ContactDescriptive;
import travel.wink.sdk.extranet.model.DowPatternGroupDescriptive;
import travel.wink.sdk.extranet.model.GeoJsonPointDescriptive;
import travel.wink.sdk.extranet.model.MoneysDescriptive;
import travel.wink.sdk.extranet.model.MultimediaDescriptive;
import travel.wink.sdk.extranet.model.RatePlanDescriptive;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;
import travel.wink.sdk.extranet.model.SocialDescriptive;
import travel.wink.sdk.extranet.model.TransactionalTravelInventoryDescriptive;
import travel.wink.sdk.extranet.model.TravelInventoryRecognitionDescriptive;

@ApiModel(description="The original add-on record created by the property.")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "applicableStart", "applicableEnd", "reservationRequiredInd", "opens", "closes", "fee", "percentDiscount", "daysOfWeek", "transactionalInventoryList", "recognitionList", "numberOfUnits", "pricingType", "ratePlanIdentifier", "ratePlan", "mandatory"})
@JsonTypeName(value="AddOn_Descriptive")
public class AddOnDescriptive {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointDescriptive location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionDescriptive> descriptions = new ArrayList<SimpleDescriptionDescriptive>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<MultimediaDescriptive> multimedias = new ArrayList<MultimediaDescriptive>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactDescriptive contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressDescriptive address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures = null;
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures = null;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<SocialDescriptive> socials = null;
    public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
    private LocalDate applicableStart;
    public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
    private LocalDate applicableEnd;
    public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
    private Boolean reservationRequiredInd;
    public static final String JSON_PROPERTY_OPENS = "opens";
    private String opens;
    public static final String JSON_PROPERTY_CLOSES = "closes";
    private String closes;
    public static final String JSON_PROPERTY_FEE = "fee";
    private MoneysDescriptive fee;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    private Double percentDiscount;
    public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
    private DowPatternGroupDescriptive daysOfWeek;
    public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
    private List<TransactionalTravelInventoryDescriptive> transactionalInventoryList = null;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    private List<TravelInventoryRecognitionDescriptive> recognitionList = null;
    public static final String JSON_PROPERTY_NUMBER_OF_UNITS = "numberOfUnits";
    private Integer numberOfUnits = 0;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType = PricingTypeEnum.PERSON_PER_STAY;
    public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
    private UUID ratePlanIdentifier;
    public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
    private RatePlanDescriptive ratePlan;
    public static final String JSON_PROPERTY_MANDATORY = "mandatory";
    private Boolean mandatory = false;

    public AddOnDescriptive identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public AddOnDescriptive hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public AddOnDescriptive featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public AddOnDescriptive lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Indicate the type of lifestyle this inventory should be associated with.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public AddOnDescriptive location(GeoJsonPointDescriptive location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointDescriptive getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPointDescriptive location) {
        this.location = location;
    }

    public AddOnDescriptive descriptions(List<SimpleDescriptionDescriptive> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public AddOnDescriptive addDescriptionsItem(SimpleDescriptionDescriptive descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescriptionDescriptive> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionDescriptive> descriptions) {
        this.descriptions = descriptions;
    }

    public AddOnDescriptive multimedias(List<MultimediaDescriptive> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public AddOnDescriptive addMultimediasItem(MultimediaDescriptive multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of inventory.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<MultimediaDescriptive> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<MultimediaDescriptive> multimedias) {
        this.multimedias = multimedias;
    }

    public AddOnDescriptive contact(ContactDescriptive contact) {
        this.contact = contact;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactDescriptive getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContact(ContactDescriptive contact) {
        this.contact = contact;
    }

    public AddOnDescriptive address(AddressDescriptive address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressDescriptive getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressDescriptive address) {
        this.address = address;
    }

    public AddOnDescriptive commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicate whether sales channels receive commission for selling this inventory.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public AddOnDescriptive name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Archery lesson", required=true, value="Internal name of inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public AddOnDescriptive proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `PRX` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public AddOnDescriptive sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Use this property to sort an inventory in a list of activities.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public AddOnDescriptive minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `AQC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public AddOnDescriptive bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public AddOnDescriptive active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Modify inventory availability with this flag.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public AddOnDescriptive disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public AddOnDescriptive addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public AddOnDescriptive securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public AddOnDescriptive addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public AddOnDescriptive socials(List<SocialDescriptive> socials) {
        this.socials = socials;
        return this;
    }

    public AddOnDescriptive addSocialsItem(SocialDescriptive socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialDescriptive>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Social network accounts for inventory (if applicable).")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SocialDescriptive> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<SocialDescriptive> socials) {
        this.socials = socials;
    }

    public AddOnDescriptive applicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Thu Jan 01 07:00:00 ICT 1970", value="Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.")
    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableStart() {
        return this.applicableStart;
    }

    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
    }

    public AddOnDescriptive applicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Tue Dec 01 07:00:00 ICT 1970", value="End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.")
    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableEnd() {
        return this.applicableEnd;
    }

    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
    }

    public AddOnDescriptive reservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Indicates whether a reservation is required to participate in this inventory.")
    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReservationRequiredInd() {
        return this.reservationRequiredInd;
    }

    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
    }

    public AddOnDescriptive opens(String opens) {
        this.opens = opens;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="09:00", value="Opening time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpens() {
        return this.opens;
    }

    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpens(String opens) {
        this.opens = opens;
    }

    public AddOnDescriptive closes(String closes) {
        this.closes = closes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="17:30", value="Closing time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloses() {
        return this.closes;
    }

    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloses(String closes) {
        this.closes = closes;
    }

    public AddOnDescriptive fee(MoneysDescriptive fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysDescriptive getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(MoneysDescriptive fee) {
        this.fee = fee;
    }

    public AddOnDescriptive percentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.2", required=true, value="Expected savings. Indicate how much the traveler is [usually] saving by booking it through this payment. Example: 20% discount.")
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") @DecimalMax(value="1.0") Double getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPercentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public AddOnDescriptive daysOfWeek(DowPatternGroupDescriptive daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupDescriptive getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDaysOfWeek(DowPatternGroupDescriptive daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public AddOnDescriptive transactionalInventoryList(List<TransactionalTravelInventoryDescriptive> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
        return this;
    }

    public AddOnDescriptive addTransactionalInventoryListItem(TransactionalTravelInventoryDescriptive transactionalInventoryListItem) {
        if (this.transactionalInventoryList == null) {
            this.transactionalInventoryList = new ArrayList<TransactionalTravelInventoryDescriptive>();
        }
        this.transactionalInventoryList.add(transactionalInventoryListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransactionalTravelInventoryDescriptive> getTransactionalInventoryList() {
        return this.transactionalInventoryList;
    }

    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionalInventoryList(List<TransactionalTravelInventoryDescriptive> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
    }

    public AddOnDescriptive recognitionList(List<TravelInventoryRecognitionDescriptive> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public AddOnDescriptive addRecognitionListItem(TravelInventoryRecognitionDescriptive recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionDescriptive>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TravelInventoryRecognitionDescriptive> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(List<TravelInventoryRecognitionDescriptive> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public AddOnDescriptive numberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="10", required=true, value="Total number of add-ons available to purchase.")
    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getNumberOfUnits() {
        return this.numberOfUnits;
    }

    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public AddOnDescriptive pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PER_USE", required=true, value="Pricing types define how this add-on is sold.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public AddOnDescriptive ratePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Pass an optional rate plan identifier if you want to add more complex restrictions to this add-on. Example: You want the add-on to only be available when a specific room is available.")
    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getRatePlanIdentifier() {
        return this.ratePlanIdentifier;
    }

    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
    }

    public AddOnDescriptive ratePlan(RatePlanDescriptive ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RatePlanDescriptive getRatePlan() {
        return this.ratePlan;
    }

    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatePlan(RatePlanDescriptive ratePlan) {
        this.ratePlan = ratePlan;
    }

    public AddOnDescriptive mandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Make this add-on mandatory for all guests by enabling this flag.")
    @JsonProperty(value="mandatory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @JsonProperty(value="mandatory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddOnDescriptive addOnDescriptive = (AddOnDescriptive)o;
        return Objects.equals(this.identifier, addOnDescriptive.identifier) && Objects.equals(this.hotelIdentifier, addOnDescriptive.hotelIdentifier) && Objects.equals(this.featuredInd, addOnDescriptive.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)addOnDescriptive.lifestyleType) && Objects.equals(this.location, addOnDescriptive.location) && Objects.equals(this.descriptions, addOnDescriptive.descriptions) && Objects.equals(this.multimedias, addOnDescriptive.multimedias) && Objects.equals(this.contact, addOnDescriptive.contact) && Objects.equals(this.address, addOnDescriptive.address) && Objects.equals(this.commissionable, addOnDescriptive.commissionable) && Objects.equals(this.name, addOnDescriptive.name) && Objects.equals(this.proximityCode, addOnDescriptive.proximityCode) && Objects.equals(this.sort, addOnDescriptive.sort) && Objects.equals(this.minAgeAppropriateCode, addOnDescriptive.minAgeAppropriateCode) && Objects.equals(this.bookable, addOnDescriptive.bookable) && Objects.equals(this.active, addOnDescriptive.active) && Objects.equals(this.disabilityFeatures, addOnDescriptive.disabilityFeatures) && Objects.equals(this.securityFeatures, addOnDescriptive.securityFeatures) && Objects.equals(this.socials, addOnDescriptive.socials) && Objects.equals(this.applicableStart, addOnDescriptive.applicableStart) && Objects.equals(this.applicableEnd, addOnDescriptive.applicableEnd) && Objects.equals(this.reservationRequiredInd, addOnDescriptive.reservationRequiredInd) && Objects.equals(this.opens, addOnDescriptive.opens) && Objects.equals(this.closes, addOnDescriptive.closes) && Objects.equals(this.fee, addOnDescriptive.fee) && Objects.equals(this.percentDiscount, addOnDescriptive.percentDiscount) && Objects.equals(this.daysOfWeek, addOnDescriptive.daysOfWeek) && Objects.equals(this.transactionalInventoryList, addOnDescriptive.transactionalInventoryList) && Objects.equals(this.recognitionList, addOnDescriptive.recognitionList) && Objects.equals(this.numberOfUnits, addOnDescriptive.numberOfUnits) && Objects.equals((Object)this.pricingType, (Object)addOnDescriptive.pricingType) && Objects.equals(this.ratePlanIdentifier, addOnDescriptive.ratePlanIdentifier) && Objects.equals(this.ratePlan, addOnDescriptive.ratePlan) && Objects.equals(this.mandatory, addOnDescriptive.mandatory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.applicableStart, this.applicableEnd, this.reservationRequiredInd, this.opens, this.closes, this.fee, this.percentDiscount, this.daysOfWeek, this.transactionalInventoryList, this.recognitionList, this.numberOfUnits, this.pricingType, this.ratePlanIdentifier, this.ratePlan, this.mandatory});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddOnDescriptive {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    applicableStart: ").append(this.toIndentedString(this.applicableStart)).append("\n");
        sb.append("    applicableEnd: ").append(this.toIndentedString(this.applicableEnd)).append("\n");
        sb.append("    reservationRequiredInd: ").append(this.toIndentedString(this.reservationRequiredInd)).append("\n");
        sb.append("    opens: ").append(this.toIndentedString(this.opens)).append("\n");
        sb.append("    closes: ").append(this.toIndentedString(this.closes)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    transactionalInventoryList: ").append(this.toIndentedString(this.transactionalInventoryList)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    ratePlanIdentifier: ").append(this.toIndentedString(this.ratePlanIdentifier)).append("\n");
        sb.append("    ratePlan: ").append(this.toIndentedString(this.ratePlan)).append("\n");
        sb.append("    mandatory: ").append(this.toIndentedString(this.mandatory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        PERSON_PER_STAY("PER_PERSON_PER_STAY"),
        NIGHT("PER_NIGHT"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        USE("PER_USE");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

