/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.extranet.model.Attraction;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "attraction", "featuredImageIdentifier"})
public class AttractionView {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_ATTRACTION = "attraction";
    private Attraction attraction;
    public static final String JSON_PROPERTY_FEATURED_IMAGE_IDENTIFIER = "featuredImageIdentifier";
    private String featuredImageIdentifier;

    public AttractionView() {
    }

    @JsonCreator
    public AttractionView(@JsonProperty(value="id") UUID id, @JsonProperty(value="createdDate") LocalDateTime createdDate, @JsonProperty(value="lastUpdate") LocalDateTime lastUpdate, @JsonProperty(value="version") Long version) {
        this();
        this.id = id;
        this.createdDate = createdDate;
        this.lastUpdate = lastUpdate;
        this.version = version;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique document identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public AttractionView attraction(Attraction attraction) {
        this.attraction = attraction;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="attraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Attraction getAttraction() {
        return this.attraction;
    }

    @JsonProperty(value="attraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttraction(Attraction attraction) {
        this.attraction = attraction;
    }

    public AttractionView featuredImageIdentifier(String featuredImageIdentifier) {
        this.featuredImageIdentifier = featuredImageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="featuredImageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFeaturedImageIdentifier() {
        return this.featuredImageIdentifier;
    }

    @JsonProperty(value="featuredImageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeaturedImageIdentifier(String featuredImageIdentifier) {
        this.featuredImageIdentifier = featuredImageIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttractionView attractionView = (AttractionView)o;
        return Objects.equals(this.id, attractionView.id) && Objects.equals(this.createdDate, attractionView.createdDate) && Objects.equals(this.lastUpdate, attractionView.lastUpdate) && Objects.equals(this.version, attractionView.version) && Objects.equals(this.attraction, attractionView.attraction) && Objects.equals(this.featuredImageIdentifier, attractionView.featuredImageIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDate, this.lastUpdate, this.version, this.attraction, this.featuredImageIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttractionView {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attraction: ").append(this.toIndentedString(this.attraction)).append("\n");
        sb.append("    featuredImageIdentifier: ").append(this.toIndentedString(this.featuredImageIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

