/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"start", "end", "startTimezone", "endTimezone", "isAllDay", "recurrenceRule", "recurrenceId", "recurrenceException", "bookingIdentifier", "type", "attendees"})
public class CreateScheduleItemRequest {
    public static final String JSON_PROPERTY_START = "start";
    private LocalDateTime start;
    public static final String JSON_PROPERTY_END = "end";
    private LocalDateTime end;
    public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
    private String startTimezone;
    public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
    private String endTimezone;
    public static final String JSON_PROPERTY_IS_ALL_DAY = "isAllDay";
    private Boolean isAllDay = false;
    public static final String JSON_PROPERTY_RECURRENCE_RULE = "recurrenceRule";
    private String recurrenceRule;
    public static final String JSON_PROPERTY_RECURRENCE_ID = "recurrenceId";
    private String recurrenceId;
    public static final String JSON_PROPERTY_RECURRENCE_EXCEPTION = "recurrenceException";
    private List<LocalDateTime> recurrenceException = null;
    public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
    private UUID bookingIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ATTENDEES = "attendees";
    private Integer attendees = 1;

    public CreateScheduleItemRequest start(LocalDateTime start) {
        this.start = start;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Start date time of scheduled event")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public CreateScheduleItemRequest end(LocalDateTime end) {
        this.end = end;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="End date time of scheduled event")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public CreateScheduleItemRequest startTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Schedule timezone")
    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStartTimezone() {
        return this.startTimezone;
    }

    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
    }

    public CreateScheduleItemRequest endTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Schedule timezone")
    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEndTimezone() {
        return this.endTimezone;
    }

    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
    }

    public CreateScheduleItemRequest isAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Flag indicating whether this is an all day event.")
    @JsonProperty(value="isAllDay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsAllDay() {
        return this.isAllDay;
    }

    @JsonProperty(value="isAllDay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
    }

    public CreateScheduleItemRequest recurrenceRule(String recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="FREQ=DAILY;COUNT=5;", value="If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)")
    @JsonProperty(value="recurrenceRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    @JsonProperty(value="recurrenceRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceRule(String recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
    }

    public CreateScheduleItemRequest recurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="schedule-parent-1", value="The parent ID of the recurring event.")
    @JsonProperty(value="recurrenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    @JsonProperty(value="recurrenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public CreateScheduleItemRequest recurrenceException(List<LocalDateTime> recurrenceException) {
        this.recurrenceException = recurrenceException;
        return this;
    }

    public CreateScheduleItemRequest addRecurrenceExceptionItem(LocalDateTime recurrenceExceptionItem) {
        if (this.recurrenceException == null) {
            this.recurrenceException = new ArrayList<LocalDateTime>();
        }
        this.recurrenceException.add(recurrenceExceptionItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="[\"2017-12-22T03:07:58.742+0000\"]", value="Exceptions to the recurrence rule.")
    @JsonProperty(value="recurrenceException")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalDateTime> getRecurrenceException() {
        return this.recurrenceException;
    }

    @JsonProperty(value="recurrenceException")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceException(List<LocalDateTime> recurrenceException) {
        this.recurrenceException = recurrenceException;
    }

    public CreateScheduleItemRequest bookingIdentifier(UUID bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Booking identifier this scheduled event was created as part of.")
    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getBookingIdentifier() {
        return this.bookingIdentifier;
    }

    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookingIdentifier(UUID bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
    }

    public CreateScheduleItemRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="MEETING_ROOM", required=true, value="The type of travel inventory.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateScheduleItemRequest attendees(Integer attendees) {
        this.attendees = attendees;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="2", required=true, value="Number of guests attending this event.")
    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttendees(Integer attendees) {
        this.attendees = attendees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateScheduleItemRequest createScheduleItemRequest = (CreateScheduleItemRequest)o;
        return Objects.equals(this.start, createScheduleItemRequest.start) && Objects.equals(this.end, createScheduleItemRequest.end) && Objects.equals(this.startTimezone, createScheduleItemRequest.startTimezone) && Objects.equals(this.endTimezone, createScheduleItemRequest.endTimezone) && Objects.equals(this.isAllDay, createScheduleItemRequest.isAllDay) && Objects.equals(this.recurrenceRule, createScheduleItemRequest.recurrenceRule) && Objects.equals(this.recurrenceId, createScheduleItemRequest.recurrenceId) && Objects.equals(this.recurrenceException, createScheduleItemRequest.recurrenceException) && Objects.equals(this.bookingIdentifier, createScheduleItemRequest.bookingIdentifier) && Objects.equals((Object)this.type, (Object)createScheduleItemRequest.type) && Objects.equals(this.attendees, createScheduleItemRequest.attendees);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.start, this.end, this.startTimezone, this.endTimezone, this.isAllDay, this.recurrenceRule, this.recurrenceId, this.recurrenceException, this.bookingIdentifier, this.type, this.attendees});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateScheduleItemRequest {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    startTimezone: ").append(this.toIndentedString(this.startTimezone)).append("\n");
        sb.append("    endTimezone: ").append(this.toIndentedString(this.endTimezone)).append("\n");
        sb.append("    isAllDay: ").append(this.toIndentedString(this.isAllDay)).append("\n");
        sb.append("    recurrenceRule: ").append(this.toIndentedString(this.recurrenceRule)).append("\n");
        sb.append("    recurrenceId: ").append(this.toIndentedString(this.recurrenceId)).append("\n");
        sb.append("    recurrenceException: ").append(this.toIndentedString(this.recurrenceException)).append("\n");
        sb.append("    bookingIdentifier: ").append(this.toIndentedString(this.bookingIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

