/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description="Property information.")
@JsonPropertyOrder(value={"name", "localName", "legalName", "currencyCode", "numberOfRooms", "locationCategory", "segmentCategory", "hotelCategory", "architecturalStyle", "whenBuilt", "hotelChain", "hotelBrand", "channelManagerIdentifier", "channelManager", "otherChannelManager", "licenseNumber"})
public class HotelInformation {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
    private String localName;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    private String legalName;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
    private Integer numberOfRooms;
    public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
    private String locationCategory;
    public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
    private String segmentCategory;
    public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
    private String hotelCategory;
    public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
    private String architecturalStyle;
    public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
    private String whenBuilt;
    public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
    private String hotelChain;
    public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
    private String hotelBrand;
    public static final String JSON_PROPERTY_CHANNEL_MANAGER_IDENTIFIER = "channelManagerIdentifier";
    private UUID channelManagerIdentifier;
    public static final String JSON_PROPERTY_CHANNEL_MANAGER = "channelManager";
    private ChannelManagerEnum channelManager = ChannelManagerEnum.TRAVELIKO;
    public static final String JSON_PROPERTY_OTHER_CHANNEL_MANAGER = "otherChannelManager";
    private String otherChannelManager;
    public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
    private String licenseNumber;

    public HotelInformation name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="The Getaway resort - Ubud", required=true, value="Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public HotelInformation localName(String localName) {
        this.localName = localName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Resor Ubud Getaway", value="Name of the hotel in its local language if you use it for domestic guests.")
    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalName() {
        return this.localName;
    }

    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public HotelInformation legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Getaway Resorts Limited", required=true, value="Legal name of your hotel as it is registered.")
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public HotelInformation currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="INR", required=true, value="Valid 3-character ISO currency code. Find our [supported currency codes here](#operation/showCurrencies).")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public HotelInformation numberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="40", required=true, value="Number of rooms / keys for property")
    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public HotelInformation locationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="34", value="Supported OTA specification `LOC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocationCategory() {
        return this.locationCategory;
    }

    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
    }

    public HotelInformation segmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Supported OTA specification `SEG` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSegmentCategory() {
        return this.segmentCategory;
    }

    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSegmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
    }

    public HotelInformation hotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="45", value="Supported OTA specification `PCT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelCategory() {
        return this.hotelCategory;
    }

    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
    }

    public HotelInformation architecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Supported OTA specification `ARC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchitecturalStyle() {
        return this.architecturalStyle;
    }

    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchitecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
    }

    public HotelInformation whenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1927", value="Year the property was constructed.")
    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhenBuilt() {
        return this.whenBuilt;
    }

    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
    }

    public HotelInformation hotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Getaway Resorts", value="Hotel chain name if property is part of that chain.")
    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelChain() {
        return this.hotelChain;
    }

    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
    }

    public HotelInformation hotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Happy Resorts", value="Hotel brand name if property is part of that brand.")
    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelBrand() {
        return this.hotelBrand;
    }

    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
    }

    public HotelInformation channelManagerIdentifier(UUID channelManagerIdentifier) {
        this.channelManagerIdentifier = channelManagerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Property's channel manager. Rate ownership is decided based on the channel manager selected.")
    @JsonProperty(value="channelManagerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getChannelManagerIdentifier() {
        return this.channelManagerIdentifier;
    }

    @JsonProperty(value="channelManagerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelManagerIdentifier(UUID channelManagerIdentifier) {
        this.channelManagerIdentifier = channelManagerIdentifier;
    }

    public HotelInformation channelManager(ChannelManagerEnum channelManager) {
        this.channelManager = channelManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OTHER_CHANNEL_MANAGER", value="Property's channel manager. Rate ownership is decided based on the channel manager selected. Defaults to `TRAVELIKO` which is the same as no channel manager and rate ownership goes to the payment.")
    @JsonProperty(value="channelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelManagerEnum getChannelManager() {
        return this.channelManager;
    }

    @JsonProperty(value="channelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelManager(ChannelManagerEnum channelManager) {
        this.channelManager = channelManager;
    }

    public HotelInformation otherChannelManager(String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CM X", value="If the property is currently using a channel manager but it isn't yet part of our list, chose 'OTHER_CHANNEL_MANAGER' as channelManager and fill in the name of the channel manager here")
    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOtherChannelManager() {
        return this.otherChannelManager;
    }

    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOtherChannelManager(String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
    }

    public HotelInformation licenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC1234", value="If the property has a valid license number to run a hotel in their country, add it here.")
    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelInformation hotelInformation = (HotelInformation)o;
        return Objects.equals(this.name, hotelInformation.name) && Objects.equals(this.localName, hotelInformation.localName) && Objects.equals(this.legalName, hotelInformation.legalName) && Objects.equals(this.currencyCode, hotelInformation.currencyCode) && Objects.equals(this.numberOfRooms, hotelInformation.numberOfRooms) && Objects.equals(this.locationCategory, hotelInformation.locationCategory) && Objects.equals(this.segmentCategory, hotelInformation.segmentCategory) && Objects.equals(this.hotelCategory, hotelInformation.hotelCategory) && Objects.equals(this.architecturalStyle, hotelInformation.architecturalStyle) && Objects.equals(this.whenBuilt, hotelInformation.whenBuilt) && Objects.equals(this.hotelChain, hotelInformation.hotelChain) && Objects.equals(this.hotelBrand, hotelInformation.hotelBrand) && Objects.equals(this.channelManagerIdentifier, hotelInformation.channelManagerIdentifier) && Objects.equals((Object)this.channelManager, (Object)hotelInformation.channelManager) && Objects.equals(this.otherChannelManager, hotelInformation.otherChannelManager) && Objects.equals(this.licenseNumber, hotelInformation.licenseNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.localName, this.legalName, this.currencyCode, this.numberOfRooms, this.locationCategory, this.segmentCategory, this.hotelCategory, this.architecturalStyle, this.whenBuilt, this.hotelChain, this.hotelBrand, this.channelManagerIdentifier, this.channelManager, this.otherChannelManager, this.licenseNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelInformation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    localName: ").append(this.toIndentedString(this.localName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    numberOfRooms: ").append(this.toIndentedString(this.numberOfRooms)).append("\n");
        sb.append("    locationCategory: ").append(this.toIndentedString(this.locationCategory)).append("\n");
        sb.append("    segmentCategory: ").append(this.toIndentedString(this.segmentCategory)).append("\n");
        sb.append("    hotelCategory: ").append(this.toIndentedString(this.hotelCategory)).append("\n");
        sb.append("    architecturalStyle: ").append(this.toIndentedString(this.architecturalStyle)).append("\n");
        sb.append("    whenBuilt: ").append(this.toIndentedString(this.whenBuilt)).append("\n");
        sb.append("    hotelChain: ").append(this.toIndentedString(this.hotelChain)).append("\n");
        sb.append("    hotelBrand: ").append(this.toIndentedString(this.hotelBrand)).append("\n");
        sb.append("    channelManagerIdentifier: ").append(this.toIndentedString(this.channelManagerIdentifier)).append("\n");
        sb.append("    channelManager: ").append(this.toIndentedString((Object)this.channelManager)).append("\n");
        sb.append("    otherChannelManager: ").append(this.toIndentedString(this.otherChannelManager)).append("\n");
        sb.append("    licenseNumber: ").append(this.toIndentedString(this.licenseNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ChannelManagerEnum {
        TRAVELIKO("TRAVELIKO"),
        SITEMINDER("SITEMINDER"),
        FASTBOOKING("FASTBOOKING"),
        RATEGAIN("RATEGAIN"),
        CLOUD_BEDS("CLOUD_BEDS"),
        YIELD_PLANET("YIELD_PLANET"),
        TRAVELCLICK("TRAVELCLICK"),
        HOTEL_GURU("HOTEL_GURU"),
        OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
        BOOKING_JINI("BOOKING_JINI"),
        HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
        ALLOTZ("ALLOTZ"),
        DEDGE("DEDGE"),
        RATE_TIGER("RATE_TIGER"),
        RESAVENUE("RESAVENUE"),
        COMANCHE("COMANCHE"),
        OMNIBEES("OMNIBEES"),
        EZEE("EZEE"),
        SYNXIS("SYNXIS");

        private String value;

        private ChannelManagerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelManagerEnum fromValue(String value) {
            for (ChannelManagerEnum b : ChannelManagerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

