/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.extranet.model.SimpleDescriptionDescriptive;

@ApiModel(description="An object representation of either an image or a video with metadata.")
@JsonPropertyOrder(value={"multimediaIdentifier", "identifier", "hotelIdentifier", "type", "source", "sort", "published", "category", "captions", "lifestyleType", "angle", "width", "height", "isLandscape"})
@JsonTypeName(value="Multimedia_Descriptive")
public class MultimediaDescriptive {
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
    private UUID multimediaIdentifier;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.CLOUDINARY;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort = 999;
    public static final String JSON_PROPERTY_PUBLISHED = "published";
    private Boolean published = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private String category;
    public static final String JSON_PROPERTY_CAPTIONS = "captions";
    private List<SimpleDescriptionDescriptive> captions = null;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_ANGLE = "angle";
    private String angle;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height;
    public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
    private Boolean isLandscape;

    public MultimediaDescriptive multimediaIdentifier(UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Document identifier")
    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getMultimediaIdentifier() {
        return this.multimediaIdentifier;
    }

    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimediaIdentifier(UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
    }

    public MultimediaDescriptive identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cloudinary-image-1", value="Use this identifier to communicate with Cloudinary.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public MultimediaDescriptive hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Owner identifier of property that owns the multimedia record.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public MultimediaDescriptive type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IMAGE", value="Whether Cloudinary media is a VIDEO or IMAGE.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MultimediaDescriptive source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CLOUDINARY", value="Currently ONLY using Cloudinary to store all image / video assets.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public MultimediaDescriptive sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Sort allows you to control how you want to sort this record in a list of media records.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public MultimediaDescriptive published(Boolean published) {
        this.published = published;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Instead of deleting the media, choose to un-publish it instead for later re-use. Could be you keep seasonal images of the property.")
    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublished(Boolean published) {
        this.published = published;
    }

    public MultimediaDescriptive category(String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `PIC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(String category) {
        this.category = category;
    }

    public MultimediaDescriptive captions(List<SimpleDescriptionDescriptive> captions) {
        this.captions = captions;
        return this;
    }

    public MultimediaDescriptive addCaptionsItem(SimpleDescriptionDescriptive captionsItem) {
        if (this.captions == null) {
            this.captions = new ArrayList<SimpleDescriptionDescriptive>();
        }
        this.captions.add(captionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Localized media captions to give user some context about where this media was taken.")
    @JsonProperty(value="captions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescriptionDescriptive> getCaptions() {
        return this.captions;
    }

    @JsonProperty(value="captions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptions(List<SimpleDescriptionDescriptive> captions) {
        this.captions = captions;
    }

    public MultimediaDescriptive lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public MultimediaDescriptive angle(String angle) {
        this.angle = angle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-90", value="Media angle")
    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAngle() {
        return this.angle;
    }

    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAngle(String angle) {
        this.angle = angle;
    }

    public MultimediaDescriptive width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2560", value="Media width in pixels.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public MultimediaDescriptive height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1600", value="Media height in pixels.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public MultimediaDescriptive isLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="True if media width is greater or equal to height")
    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsLandscape() {
        return this.isLandscape;
    }

    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultimediaDescriptive multimediaDescriptive = (MultimediaDescriptive)o;
        return Objects.equals(this.multimediaIdentifier, multimediaDescriptive.multimediaIdentifier) && Objects.equals(this.identifier, multimediaDescriptive.identifier) && Objects.equals(this.hotelIdentifier, multimediaDescriptive.hotelIdentifier) && Objects.equals((Object)this.type, (Object)multimediaDescriptive.type) && Objects.equals((Object)this.source, (Object)multimediaDescriptive.source) && Objects.equals(this.sort, multimediaDescriptive.sort) && Objects.equals(this.published, multimediaDescriptive.published) && Objects.equals(this.category, multimediaDescriptive.category) && Objects.equals(this.captions, multimediaDescriptive.captions) && Objects.equals((Object)this.lifestyleType, (Object)multimediaDescriptive.lifestyleType) && Objects.equals(this.angle, multimediaDescriptive.angle) && Objects.equals(this.width, multimediaDescriptive.width) && Objects.equals(this.height, multimediaDescriptive.height) && Objects.equals(this.isLandscape, multimediaDescriptive.isLandscape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.multimediaIdentifier, this.identifier, this.hotelIdentifier, this.type, this.source, this.sort, this.published, this.category, this.captions, this.lifestyleType, this.angle, this.width, this.height, this.isLandscape});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultimediaDescriptive {\n");
        sb.append("    multimediaIdentifier: ").append(this.toIndentedString(this.multimediaIdentifier)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    captions: ").append(this.toIndentedString(this.captions)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    isLandscape: ").append(this.toIndentedString(this.isLandscape)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        YOUTUBE("YOUTUBE"),
        CLOUDINARY("CLOUDINARY");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        IMAGE("IMAGE"),
        VIDEO("VIDEO");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

