/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.Address;
import travel.wink.sdk.extranet.model.Contact;

@JsonPropertyOrder(value={"identifier", "start", "startTimezone", "end", "endTimezone", "title", "description", "recurrenceRule", "recurrenceId", "recurrenceException", "ownerIdentifier", "bookingIdentifier", "bookingOwnerIdentifier", "hotelIdentifier", "type", "attendees", "email", "fullName", "firstName", "lastName", "venueName", "localizedVenueName", "contact", "address", "created", "lastModified", "sequence", "emailHeaderLogoUrl", "logoIdentifier", "allDay"})
public class ScheduleItem {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_START = "start";
    private LocalDateTime start;
    public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
    private String startTimezone;
    public static final String JSON_PROPERTY_END = "end";
    private LocalDateTime end;
    public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
    private String endTimezone;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_RECURRENCE_RULE = "recurrenceRule";
    private String recurrenceRule;
    public static final String JSON_PROPERTY_RECURRENCE_ID = "recurrenceId";
    private String recurrenceId;
    public static final String JSON_PROPERTY_RECURRENCE_EXCEPTION = "recurrenceException";
    private List<LocalDateTime> recurrenceException = null;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
    private UUID bookingIdentifier;
    public static final String JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER = "bookingOwnerIdentifier";
    private UUID bookingOwnerIdentifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ATTENDEES = "attendees";
    private Integer attendees = 1;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private String fullName;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_VENUE_NAME = "venueName";
    private String venueName;
    public static final String JSON_PROPERTY_LOCALIZED_VENUE_NAME = "localizedVenueName";
    private String localizedVenueName;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private Contact contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_CREATED = "created";
    private LocalDateTime created;
    public static final String JSON_PROPERTY_LAST_MODIFIED = "lastModified";
    private LocalDateTime lastModified;
    public static final String JSON_PROPERTY_SEQUENCE = "sequence";
    private Long sequence;
    public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
    private String emailHeaderLogoUrl;
    public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
    private String logoIdentifier;
    public static final String JSON_PROPERTY_ALL_DAY = "allDay";
    private Boolean allDay;

    public ScheduleItem identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique schedule identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public ScheduleItem start(LocalDateTime start) {
        this.start = start;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Start date time of scheduled event")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public ScheduleItem startTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Schedule timezone")
    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartTimezone() {
        return this.startTimezone;
    }

    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
    }

    public ScheduleItem end(LocalDateTime end) {
        this.end = end;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="End date time of scheduled event")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public ScheduleItem endTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Schedule timezone")
    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndTimezone() {
        return this.endTimezone;
    }

    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
    }

    public ScheduleItem title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Jane Doe +1", value="Title of scheduled event.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public ScheduleItem description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Reservation for Jane Doe - 2 PAX", value="Description of scheduled event.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ScheduleItem recurrenceRule(String recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="FREQ=DAILY;COUNT=5;", value="If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)")
    @JsonProperty(value="recurrenceRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    @JsonProperty(value="recurrenceRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceRule(String recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
    }

    public ScheduleItem recurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="schedule-parent-1", value="The parent ID of the recurring event.")
    @JsonProperty(value="recurrenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    @JsonProperty(value="recurrenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public ScheduleItem recurrenceException(List<LocalDateTime> recurrenceException) {
        this.recurrenceException = recurrenceException;
        return this;
    }

    public ScheduleItem addRecurrenceExceptionItem(LocalDateTime recurrenceExceptionItem) {
        if (this.recurrenceException == null) {
            this.recurrenceException = new ArrayList<LocalDateTime>();
        }
        this.recurrenceException.add(recurrenceExceptionItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="[\"2017-12-22T03:07:58.742+0000\"]", value="Exceptions to the recurrence rule.")
    @JsonProperty(value="recurrenceException")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalDateTime> getRecurrenceException() {
        return this.recurrenceException;
    }

    @JsonProperty(value="recurrenceException")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceException(List<LocalDateTime> recurrenceException) {
        this.recurrenceException = recurrenceException;
    }

    public ScheduleItem ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The unique identifier of the travel inventory you are creating a scheduled event for.")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public ScheduleItem bookingIdentifier(UUID bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Booking identifier this scheduled event was created as part of.")
    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getBookingIdentifier() {
        return this.bookingIdentifier;
    }

    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingIdentifier(UUID bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
    }

    public ScheduleItem bookingOwnerIdentifier(UUID bookingOwnerIdentifier) {
        this.bookingOwnerIdentifier = bookingOwnerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Which company owns this schedule. (Owner of the engine)")
    @JsonProperty(value="bookingOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getBookingOwnerIdentifier() {
        return this.bookingOwnerIdentifier;
    }

    @JsonProperty(value="bookingOwnerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingOwnerIdentifier(UUID bookingOwnerIdentifier) {
        this.bookingOwnerIdentifier = bookingOwnerIdentifier;
    }

    public ScheduleItem hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Hotel identifier that owns the travel inventory.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public ScheduleItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MEETING_ROOM", value="The type of travel inventory.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ScheduleItem attendees(Integer attendees) {
        this.attendees = attendees;
        return this;
    }

    @Nullable
    @Min(value=1L)
    @ApiModelProperty(example="2", value="Number of guests attending this event.")
    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=1L) Integer getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttendees(Integer attendees) {
        this.attendees = attendees;
    }

    public ScheduleItem email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="jane@doe.com", required=true, value="Email of the person scheduling this event.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public ScheduleItem fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Jane Doe", value="Full name of person scheduling this event.")
    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public ScheduleItem firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Jane", value="First name of person scheduling this event.")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public ScheduleItem lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Doe", value="Last name of person scheduling this event.")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public ScheduleItem venueName(String venueName) {
        this.venueName = venueName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Restaurant 1", value="Name of venue attendees will visit.")
    @JsonProperty(value="venueName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVenueName() {
        return this.venueName;
    }

    @JsonProperty(value="venueName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVenueName(String venueName) {
        this.venueName = venueName;
    }

    public ScheduleItem localizedVenueName(String localizedVenueName) {
        this.localizedVenueName = localizedVenueName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="The Great Angus", value="Localized name of venue attendees will visit.")
    @JsonProperty(value="localizedVenueName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalizedVenueName() {
        return this.localizedVenueName;
    }

    @JsonProperty(value="localizedVenueName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalizedVenueName(String localizedVenueName) {
        this.localizedVenueName = localizedVenueName;
    }

    public ScheduleItem contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Contact getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public ScheduleItem address(Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public ScheduleItem created(LocalDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date time this schedule event was created.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public ScheduleItem lastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Last date time this scheduled event was modified.")
    @JsonProperty(value="lastModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty(value="lastModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public ScheduleItem sequence(Long sequence) {
        this.sequence = sequence;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="Schedule event recurring sequence")
    @JsonProperty(value="sequence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSequence() {
        return this.sequence;
    }

    @JsonProperty(value="sequence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public ScheduleItem emailHeaderLogoUrl(String emailHeaderLogoUrl) {
        this.emailHeaderLogoUrl = emailHeaderLogoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://path.to/my-image.jpg", value="Venue owner logo")
    @JsonProperty(value="emailHeaderLogoUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailHeaderLogoUrl() {
        return this.emailHeaderLogoUrl;
    }

    @JsonProperty(value="emailHeaderLogoUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
        this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    }

    public ScheduleItem logoIdentifier(String logoIdentifier) {
        this.logoIdentifier = logoIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="my-image", value="Cloudinary image identifier of logo")
    @JsonProperty(value="logoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoIdentifier() {
        return this.logoIdentifier;
    }

    @JsonProperty(value="logoIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoIdentifier(String logoIdentifier) {
        this.logoIdentifier = logoIdentifier;
    }

    public ScheduleItem allDay(Boolean allDay) {
        this.allDay = allDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="allDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllDay() {
        return this.allDay;
    }

    @JsonProperty(value="allDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllDay(Boolean allDay) {
        this.allDay = allDay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleItem scheduleItem = (ScheduleItem)o;
        return Objects.equals(this.identifier, scheduleItem.identifier) && Objects.equals(this.start, scheduleItem.start) && Objects.equals(this.startTimezone, scheduleItem.startTimezone) && Objects.equals(this.end, scheduleItem.end) && Objects.equals(this.endTimezone, scheduleItem.endTimezone) && Objects.equals(this.title, scheduleItem.title) && Objects.equals(this.description, scheduleItem.description) && Objects.equals(this.recurrenceRule, scheduleItem.recurrenceRule) && Objects.equals(this.recurrenceId, scheduleItem.recurrenceId) && Objects.equals(this.recurrenceException, scheduleItem.recurrenceException) && Objects.equals(this.ownerIdentifier, scheduleItem.ownerIdentifier) && Objects.equals(this.bookingIdentifier, scheduleItem.bookingIdentifier) && Objects.equals(this.bookingOwnerIdentifier, scheduleItem.bookingOwnerIdentifier) && Objects.equals(this.hotelIdentifier, scheduleItem.hotelIdentifier) && Objects.equals((Object)this.type, (Object)scheduleItem.type) && Objects.equals(this.attendees, scheduleItem.attendees) && Objects.equals(this.email, scheduleItem.email) && Objects.equals(this.fullName, scheduleItem.fullName) && Objects.equals(this.firstName, scheduleItem.firstName) && Objects.equals(this.lastName, scheduleItem.lastName) && Objects.equals(this.venueName, scheduleItem.venueName) && Objects.equals(this.localizedVenueName, scheduleItem.localizedVenueName) && Objects.equals(this.contact, scheduleItem.contact) && Objects.equals(this.address, scheduleItem.address) && Objects.equals(this.created, scheduleItem.created) && Objects.equals(this.lastModified, scheduleItem.lastModified) && Objects.equals(this.sequence, scheduleItem.sequence) && Objects.equals(this.emailHeaderLogoUrl, scheduleItem.emailHeaderLogoUrl) && Objects.equals(this.logoIdentifier, scheduleItem.logoIdentifier) && Objects.equals(this.allDay, scheduleItem.allDay);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.start, this.startTimezone, this.end, this.endTimezone, this.title, this.description, this.recurrenceRule, this.recurrenceId, this.recurrenceException, this.ownerIdentifier, this.bookingIdentifier, this.bookingOwnerIdentifier, this.hotelIdentifier, this.type, this.attendees, this.email, this.fullName, this.firstName, this.lastName, this.venueName, this.localizedVenueName, this.contact, this.address, this.created, this.lastModified, this.sequence, this.emailHeaderLogoUrl, this.logoIdentifier, this.allDay});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleItem {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    startTimezone: ").append(this.toIndentedString(this.startTimezone)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    endTimezone: ").append(this.toIndentedString(this.endTimezone)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    recurrenceRule: ").append(this.toIndentedString(this.recurrenceRule)).append("\n");
        sb.append("    recurrenceId: ").append(this.toIndentedString(this.recurrenceId)).append("\n");
        sb.append("    recurrenceException: ").append(this.toIndentedString(this.recurrenceException)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    bookingIdentifier: ").append(this.toIndentedString(this.bookingIdentifier)).append("\n");
        sb.append("    bookingOwnerIdentifier: ").append(this.toIndentedString(this.bookingOwnerIdentifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    venueName: ").append(this.toIndentedString(this.venueName)).append("\n");
        sb.append("    localizedVenueName: ").append(this.toIndentedString(this.localizedVenueName)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("    emailHeaderLogoUrl: ").append(this.toIndentedString(this.emailHeaderLogoUrl)).append("\n");
        sb.append("    logoIdentifier: ").append(this.toIndentedString(this.logoIdentifier)).append("\n");
        sb.append("    allDay: ").append(this.toIndentedString(this.allDay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

