/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"start", "end", "startTimezone", "endTimezone", "isAllDay", "attendees"})
public class UpdateScheduleItemRequest {
    public static final String JSON_PROPERTY_START = "start";
    private LocalDateTime start;
    public static final String JSON_PROPERTY_END = "end";
    private LocalDateTime end;
    public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
    private String startTimezone;
    public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
    private String endTimezone;
    public static final String JSON_PROPERTY_IS_ALL_DAY = "isAllDay";
    private Boolean isAllDay = false;
    public static final String JSON_PROPERTY_ATTENDEES = "attendees";
    private Integer attendees = 1;

    public UpdateScheduleItemRequest start(LocalDateTime start) {
        this.start = start;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Start date time of scheduled event")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public UpdateScheduleItemRequest end(LocalDateTime end) {
        this.end = end;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="End date time of scheduled event")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public UpdateScheduleItemRequest startTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Schedule timezone")
    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStartTimezone() {
        return this.startTimezone;
    }

    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
    }

    public UpdateScheduleItemRequest endTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Schedule timezone")
    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEndTimezone() {
        return this.endTimezone;
    }

    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
    }

    public UpdateScheduleItemRequest isAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Flag indicating whether this is an all day event.")
    @JsonProperty(value="isAllDay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsAllDay() {
        return this.isAllDay;
    }

    @JsonProperty(value="isAllDay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
    }

    public UpdateScheduleItemRequest attendees(Integer attendees) {
        this.attendees = attendees;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="2", required=true, value="Number of guests attending this event.")
    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttendees(Integer attendees) {
        this.attendees = attendees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateScheduleItemRequest updateScheduleItemRequest = (UpdateScheduleItemRequest)o;
        return Objects.equals(this.start, updateScheduleItemRequest.start) && Objects.equals(this.end, updateScheduleItemRequest.end) && Objects.equals(this.startTimezone, updateScheduleItemRequest.startTimezone) && Objects.equals(this.endTimezone, updateScheduleItemRequest.endTimezone) && Objects.equals(this.isAllDay, updateScheduleItemRequest.isAllDay) && Objects.equals(this.attendees, updateScheduleItemRequest.attendees);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.startTimezone, this.endTimezone, this.isAllDay, this.attendees);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateScheduleItemRequest {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    startTimezone: ").append(this.toIndentedString(this.startTimezone)).append("\n");
        sb.append("    endTimezone: ").append(this.toIndentedString(this.endTimezone)).append("\n");
        sb.append("    isAllDay: ").append(this.toIndentedString(this.isAllDay)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

