/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 24.0.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Indicate which days this inventory is open.
 */
@ApiModel(description = "Indicate which days this inventory is open.")
@JsonPropertyOrder({
  DowPatternGroupSupplierDetails.JSON_PROPERTY_MON,
  DowPatternGroupSupplierDetails.JSON_PROPERTY_TUE,
  DowPatternGroupSupplierDetails.JSON_PROPERTY_WED,
  DowPatternGroupSupplierDetails.JSON_PROPERTY_THU,
  DowPatternGroupSupplierDetails.JSON_PROPERTY_FRI,
  DowPatternGroupSupplierDetails.JSON_PROPERTY_SAT,
  DowPatternGroupSupplierDetails.JSON_PROPERTY_SUN,
  DowPatternGroupSupplierDetails.JSON_PROPERTY_DISABLED
})
@JsonTypeName("DowPatternGroup_SupplierDetails")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-06T16:57:39.147628191+07:00[Asia/Bangkok]")
public class DowPatternGroupSupplierDetails {
  public static final String JSON_PROPERTY_MON = "mon";
  private Boolean mon;

  public static final String JSON_PROPERTY_TUE = "tue";
  private Boolean tue;

  public static final String JSON_PROPERTY_WED = "wed";
  private Boolean wed;

  public static final String JSON_PROPERTY_THU = "thu";
  private Boolean thu;

  public static final String JSON_PROPERTY_FRI = "fri";
  private Boolean fri;

  public static final String JSON_PROPERTY_SAT = "sat";
  private Boolean sat;

  public static final String JSON_PROPERTY_SUN = "sun";
  private Boolean sun;

  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled;

  public DowPatternGroupSupplierDetails() { 
  }

  public DowPatternGroupSupplierDetails mon(Boolean mon) {
    
    this.mon = mon;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Monday.
   * @return mon
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Monday.")
  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMon() {
    return mon;
  }


  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMon(Boolean mon) {
    this.mon = mon;
  }


  public DowPatternGroupSupplierDetails tue(Boolean tue) {
    
    this.tue = tue;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Tuesday.
   * @return tue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Tuesday.")
  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTue() {
    return tue;
  }


  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTue(Boolean tue) {
    this.tue = tue;
  }


  public DowPatternGroupSupplierDetails wed(Boolean wed) {
    
    this.wed = wed;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Wednesday.
   * @return wed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Wednesday.")
  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getWed() {
    return wed;
  }


  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWed(Boolean wed) {
    this.wed = wed;
  }


  public DowPatternGroupSupplierDetails thu(Boolean thu) {
    
    this.thu = thu;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Thursday.
   * @return thu
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Thursday.")
  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getThu() {
    return thu;
  }


  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThu(Boolean thu) {
    this.thu = thu;
  }


  public DowPatternGroupSupplierDetails fri(Boolean fri) {
    
    this.fri = fri;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Friday.
   * @return fri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Friday.")
  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFri() {
    return fri;
  }


  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFri(Boolean fri) {
    this.fri = fri;
  }


  public DowPatternGroupSupplierDetails sat(Boolean sat) {
    
    this.sat = sat;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Saturday.
   * @return sat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Saturday.")
  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSat() {
    return sat;
  }


  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSat(Boolean sat) {
    this.sat = sat;
  }


  public DowPatternGroupSupplierDetails sun(Boolean sun) {
    
    this.sun = sun;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Sunday.
   * @return sun
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Sunday.")
  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSun() {
    return sun;
  }


  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSun(Boolean sun) {
    this.sun = sun;
  }


  public DowPatternGroupSupplierDetails disabled(Boolean disabled) {
    
    this.disabled = disabled;
    return this;
  }

   /**
   * Convenience property to quickly determine if this existing object has any active days enabled.
   * @return disabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Convenience property to quickly determine if this existing object has any active days enabled.")
  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisabled() {
    return disabled;
  }


  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DowPatternGroupSupplierDetails dowPatternGroupSupplierDetails = (DowPatternGroupSupplierDetails) o;
    return Objects.equals(this.mon, dowPatternGroupSupplierDetails.mon) &&
        Objects.equals(this.tue, dowPatternGroupSupplierDetails.tue) &&
        Objects.equals(this.wed, dowPatternGroupSupplierDetails.wed) &&
        Objects.equals(this.thu, dowPatternGroupSupplierDetails.thu) &&
        Objects.equals(this.fri, dowPatternGroupSupplierDetails.fri) &&
        Objects.equals(this.sat, dowPatternGroupSupplierDetails.sat) &&
        Objects.equals(this.sun, dowPatternGroupSupplierDetails.sun) &&
        Objects.equals(this.disabled, dowPatternGroupSupplierDetails.disabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mon, tue, wed, thu, fri, sat, sun, disabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DowPatternGroupSupplierDetails {\n");
    sb.append("    mon: ").append(toIndentedString(mon)).append("\n");
    sb.append("    tue: ").append(toIndentedString(tue)).append("\n");
    sb.append("    wed: ").append(toIndentedString(wed)).append("\n");
    sb.append("    thu: ").append(toIndentedString(thu)).append("\n");
    sb.append("    fri: ").append(toIndentedString(fri)).append("\n");
    sb.append("    sat: ").append(toIndentedString(sat)).append("\n");
    sb.append("    sun: ").append(toIndentedString(sun)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

