/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import travel.wink.sdk.extranet.model.AggregateGreendexAnswerSupplier;
import travel.wink.sdk.extranet.model.AggregateGreendexScoreByCategorySupplier;

@ApiModel(description="Properties that answered the Green Index questionnaire [full or partial], will have aggregate scores available.")
@JsonPropertyOrder(value={"hotelIdentifier", "list", "highScore", "totalScore", "aggregateScore", "scoresByCategory"})
@JsonTypeName(value="AggregateGreendexAnswers_Supplier")
public class AggregateGreendexAnswersSupplier {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_LIST = "list";
    private List<AggregateGreendexAnswerSupplier> _list = null;
    public static final String JSON_PROPERTY_HIGH_SCORE = "highScore";
    private Integer highScore;
    public static final String JSON_PROPERTY_TOTAL_SCORE = "totalScore";
    private Integer totalScore;
    public static final String JSON_PROPERTY_AGGREGATE_SCORE = "aggregateScore";
    private Float aggregateScore;
    public static final String JSON_PROPERTY_SCORES_BY_CATEGORY = "scoresByCategory";
    private List<AggregateGreendexScoreByCategorySupplier> scoresByCategory = null;

    public AggregateGreendexAnswersSupplier hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public AggregateGreendexAnswersSupplier _list(List<AggregateGreendexAnswerSupplier> _list) {
        this._list = _list;
        return this;
    }

    public AggregateGreendexAnswersSupplier addListItem(AggregateGreendexAnswerSupplier _listItem) {
        if (this._list == null) {
            this._list = new ArrayList<AggregateGreendexAnswerSupplier>();
        }
        this._list.add(_listItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AggregateGreendexAnswerSupplier> getList() {
        return this._list;
    }

    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setList(List<AggregateGreendexAnswerSupplier> _list) {
        this._list = _list;
    }

    public AggregateGreendexAnswersSupplier highScore(Integer highScore) {
        this.highScore = highScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="The highest possible score from all questions")
    @JsonProperty(value="highScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHighScore() {
        return this.highScore;
    }

    @JsonProperty(value="highScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHighScore(Integer highScore) {
        this.highScore = highScore;
    }

    public AggregateGreendexAnswersSupplier totalScore(Integer totalScore) {
        this.totalScore = totalScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="50", value="The total score from all questions answered")
    @JsonProperty(value="totalScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalScore() {
        return this.totalScore;
    }

    @JsonProperty(value="totalScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalScore(Integer totalScore) {
        this.totalScore = totalScore;
    }

    public AggregateGreendexAnswersSupplier aggregateScore(Float aggregateScore) {
        this.aggregateScore = aggregateScore;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @DecimalMax(value="1")
    @ApiModelProperty(value="Total score divided by high score")
    @JsonProperty(value="aggregateScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") @DecimalMax(value="1") Float getAggregateScore() {
        return this.aggregateScore;
    }

    @JsonProperty(value="aggregateScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregateScore(Float aggregateScore) {
        this.aggregateScore = aggregateScore;
    }

    public AggregateGreendexAnswersSupplier scoresByCategory(List<AggregateGreendexScoreByCategorySupplier> scoresByCategory) {
        this.scoresByCategory = scoresByCategory;
        return this;
    }

    public AggregateGreendexAnswersSupplier addScoresByCategoryItem(AggregateGreendexScoreByCategorySupplier scoresByCategoryItem) {
        if (this.scoresByCategory == null) {
            this.scoresByCategory = new ArrayList<AggregateGreendexScoreByCategorySupplier>();
        }
        this.scoresByCategory.add(scoresByCategoryItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Aggregate scores by Green Index category")
    @JsonProperty(value="scoresByCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AggregateGreendexScoreByCategorySupplier> getScoresByCategory() {
        return this.scoresByCategory;
    }

    @JsonProperty(value="scoresByCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScoresByCategory(List<AggregateGreendexScoreByCategorySupplier> scoresByCategory) {
        this.scoresByCategory = scoresByCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateGreendexAnswersSupplier aggregateGreendexAnswersSupplier = (AggregateGreendexAnswersSupplier)o;
        return Objects.equals(this.hotelIdentifier, aggregateGreendexAnswersSupplier.hotelIdentifier) && Objects.equals(this._list, aggregateGreendexAnswersSupplier._list) && Objects.equals(this.highScore, aggregateGreendexAnswersSupplier.highScore) && Objects.equals(this.totalScore, aggregateGreendexAnswersSupplier.totalScore) && Objects.equals(this.aggregateScore, aggregateGreendexAnswersSupplier.aggregateScore) && Objects.equals(this.scoresByCategory, aggregateGreendexAnswersSupplier.scoresByCategory);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this._list, this.highScore, this.totalScore, this.aggregateScore, this.scoresByCategory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateGreendexAnswersSupplier {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    _list: ").append(this.toIndentedString(this._list)).append("\n");
        sb.append("    highScore: ").append(this.toIndentedString(this.highScore)).append("\n");
        sb.append("    totalScore: ").append(this.toIndentedString(this.totalScore)).append("\n");
        sb.append("    aggregateScore: ").append(this.toIndentedString(this.aggregateScore)).append("\n");
        sb.append("    scoresByCategory: ").append(this.toIndentedString(this.scoresByCategory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

