/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.extranet.model.BeneficiarySupplier;
import travel.wink.sdk.extranet.model.BookingUserSupplier;
import travel.wink.sdk.extranet.model.DailyRateSupplier;
import travel.wink.sdk.extranet.model.ItinerarySupplier;
import travel.wink.sdk.extranet.model.MoneysSupplier;
import travel.wink.sdk.extranet.model.SupplierContractItemPolicySupplier;

@ApiModel(description="Holds one booking line item for a specific supplier.")
@JsonPropertyOrder(value={"supplierItemBookingCode", "user", "nameInEnglish", "descriptionInEnglish", "totalSourcePrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice", "totalCapturePrice", "itinerary", "pricingType", "type", "beneficiaryList", "payable", "policy", "externalIdentifier", "tokensEarned", "dailyRateList", "cancelled", "totalSourcePriceAfterRefund", "totalDisplayPriceAfterRefund", "totalSupplierPriceAfterRefund", "totalInternalPriceAfterRefund", "totalCapturePriceAfterRefund", "cancellableBySupplier", "isCancellableBySupplier", "cancellableByTraveler", "isCancellableByTraveler", "cancellableWithNoCharges", "cancellableWithPotentialCharges"})
@JsonTypeName(value="BookingContractItem_Supplier")
public class BookingContractItemSupplier {
    public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
    private String supplierItemBookingCode;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserSupplier user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
    private MoneysSupplier totalSourcePrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private MoneysSupplier totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private MoneysSupplier totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private MoneysSupplier totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private MoneysSupplier totalCapturePrice;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private ItinerarySupplier itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<BeneficiarySupplier> beneficiaryList = new ArrayList<BeneficiarySupplier>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicySupplier policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
    private Long tokensEarned;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<DailyRateSupplier> dailyRateList = null;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND = "totalSourcePriceAfterRefund";
    private MoneysSupplier totalSourcePriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND = "totalDisplayPriceAfterRefund";
    private MoneysSupplier totalDisplayPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND = "totalSupplierPriceAfterRefund";
    private MoneysSupplier totalSupplierPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND = "totalInternalPriceAfterRefund";
    private MoneysSupplier totalInternalPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND = "totalCapturePriceAfterRefund";
    private MoneysSupplier totalCapturePriceAfterRefund;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER = "isCancellableBySupplier";
    private Boolean isCancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_IS_CANCELLABLE_BY_TRAVELER = "isCancellableByTraveler";
    private Boolean isCancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
    private Boolean cancellableWithPotentialCharges;

    public BookingContractItemSupplier supplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="TP-ASDFG1234", required=true, value="Booking code identifying the supplier line item.")
    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierItemBookingCode() {
        return this.supplierItemBookingCode;
    }

    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
    }

    public BookingContractItemSupplier user(BookingUserSupplier user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserSupplier getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserSupplier user) {
        this.user = user;
    }

    public BookingContractItemSupplier nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Deluxe King", required=true, value="Name of item in English included in booking.")
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public BookingContractItemSupplier descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="This is the best deluxe king that money can buy.", required=true, value="Short description in English of item included in booking.")
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public BookingContractItemSupplier totalSourcePrice(MoneysSupplier totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysSupplier getTotalSourcePrice() {
        return this.totalSourcePrice;
    }

    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalSourcePrice(MoneysSupplier totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
    }

    public BookingContractItemSupplier totalDisplayPrice(MoneysSupplier totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysSupplier getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalDisplayPrice(MoneysSupplier totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public BookingContractItemSupplier totalSupplierPrice(MoneysSupplier totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysSupplier getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalSupplierPrice(MoneysSupplier totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public BookingContractItemSupplier totalInternalPrice(MoneysSupplier totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysSupplier getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalInternalPrice(MoneysSupplier totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public BookingContractItemSupplier totalCapturePrice(MoneysSupplier totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysSupplier getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalCapturePrice(MoneysSupplier totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public BookingContractItemSupplier itinerary(ItinerarySupplier itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ItinerarySupplier getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(ItinerarySupplier itinerary) {
        this.itinerary = itinerary;
    }

    public BookingContractItemSupplier pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="How to calculate the total amount.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public BookingContractItemSupplier type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="LODGING", required=true, value="Type of item this is.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BookingContractItemSupplier beneficiaryList(List<BeneficiarySupplier> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public BookingContractItemSupplier addBeneficiaryListItem(BeneficiarySupplier beneficiaryListItem) {
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<BeneficiarySupplier> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<BeneficiarySupplier> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public BookingContractItemSupplier payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PREPAY", required=true, value="When to charge for this item.")
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public BookingContractItemSupplier policy(SupplierContractItemPolicySupplier policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicySupplier getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicySupplier policy) {
        this.policy = policy;
    }

    public BookingContractItemSupplier externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="room-type-1", value="Optional geoname externalIdentifier to remote inventory.")
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public BookingContractItemSupplier tokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Tokens earned for this item")
    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTokensEarned() {
        return this.tokensEarned;
    }

    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
    }

    public BookingContractItemSupplier dailyRateList(List<DailyRateSupplier> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public BookingContractItemSupplier addDailyRateListItem(DailyRateSupplier dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<DailyRateSupplier>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DailyRateSupplier> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<DailyRateSupplier> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public BookingContractItemSupplier cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional geoname externalIdentifier to remote inventory.")
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractItemSupplier totalSourcePriceAfterRefund(MoneysSupplier totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getTotalSourcePriceAfterRefund() {
        return this.totalSourcePriceAfterRefund;
    }

    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePriceAfterRefund(MoneysSupplier totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
    }

    public BookingContractItemSupplier totalDisplayPriceAfterRefund(MoneysSupplier totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getTotalDisplayPriceAfterRefund() {
        return this.totalDisplayPriceAfterRefund;
    }

    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPriceAfterRefund(MoneysSupplier totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
    }

    public BookingContractItemSupplier totalSupplierPriceAfterRefund(MoneysSupplier totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getTotalSupplierPriceAfterRefund() {
        return this.totalSupplierPriceAfterRefund;
    }

    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPriceAfterRefund(MoneysSupplier totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
    }

    public BookingContractItemSupplier totalInternalPriceAfterRefund(MoneysSupplier totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getTotalInternalPriceAfterRefund() {
        return this.totalInternalPriceAfterRefund;
    }

    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPriceAfterRefund(MoneysSupplier totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
    }

    public BookingContractItemSupplier totalCapturePriceAfterRefund(MoneysSupplier totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getTotalCapturePriceAfterRefund() {
        return this.totalCapturePriceAfterRefund;
    }

    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePriceAfterRefund(MoneysSupplier totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
    }

    public BookingContractItemSupplier cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable")
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractItemSupplier isCancellableBySupplier(Boolean isCancellableBySupplier) {
        this.isCancellableBySupplier = isCancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="isCancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCancellableBySupplier() {
        return this.isCancellableBySupplier;
    }

    @JsonProperty(value="isCancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCancellableBySupplier(Boolean isCancellableBySupplier) {
        this.isCancellableBySupplier = isCancellableBySupplier;
    }

    public BookingContractItemSupplier cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled by the traveller.")
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractItemSupplier isCancellableByTraveler(Boolean isCancellableByTraveler) {
        this.isCancellableByTraveler = isCancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="isCancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCancellableByTraveler() {
        return this.isCancellableByTraveler;
    }

    @JsonProperty(value="isCancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCancellableByTraveler(Boolean isCancellableByTraveler) {
        this.isCancellableByTraveler = isCancellableByTraveler;
    }

    public BookingContractItemSupplier cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled and whether cancellation charges might still occur.")
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContractItemSupplier cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled and whether cancellation charges might still occur.")
    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharges() {
        return this.cancellableWithPotentialCharges;
    }

    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractItemSupplier bookingContractItemSupplier = (BookingContractItemSupplier)o;
        return Objects.equals(this.supplierItemBookingCode, bookingContractItemSupplier.supplierItemBookingCode) && Objects.equals(this.user, bookingContractItemSupplier.user) && Objects.equals(this.nameInEnglish, bookingContractItemSupplier.nameInEnglish) && Objects.equals(this.descriptionInEnglish, bookingContractItemSupplier.descriptionInEnglish) && Objects.equals(this.totalSourcePrice, bookingContractItemSupplier.totalSourcePrice) && Objects.equals(this.totalDisplayPrice, bookingContractItemSupplier.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, bookingContractItemSupplier.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, bookingContractItemSupplier.totalInternalPrice) && Objects.equals(this.totalCapturePrice, bookingContractItemSupplier.totalCapturePrice) && Objects.equals(this.itinerary, bookingContractItemSupplier.itinerary) && Objects.equals((Object)this.pricingType, (Object)bookingContractItemSupplier.pricingType) && Objects.equals((Object)this.type, (Object)bookingContractItemSupplier.type) && Objects.equals(this.beneficiaryList, bookingContractItemSupplier.beneficiaryList) && Objects.equals((Object)this.payable, (Object)bookingContractItemSupplier.payable) && Objects.equals(this.policy, bookingContractItemSupplier.policy) && Objects.equals(this.externalIdentifier, bookingContractItemSupplier.externalIdentifier) && Objects.equals(this.tokensEarned, bookingContractItemSupplier.tokensEarned) && Objects.equals(this.dailyRateList, bookingContractItemSupplier.dailyRateList) && Objects.equals(this.cancelled, bookingContractItemSupplier.cancelled) && Objects.equals(this.totalSourcePriceAfterRefund, bookingContractItemSupplier.totalSourcePriceAfterRefund) && Objects.equals(this.totalDisplayPriceAfterRefund, bookingContractItemSupplier.totalDisplayPriceAfterRefund) && Objects.equals(this.totalSupplierPriceAfterRefund, bookingContractItemSupplier.totalSupplierPriceAfterRefund) && Objects.equals(this.totalInternalPriceAfterRefund, bookingContractItemSupplier.totalInternalPriceAfterRefund) && Objects.equals(this.totalCapturePriceAfterRefund, bookingContractItemSupplier.totalCapturePriceAfterRefund) && Objects.equals(this.cancellableBySupplier, bookingContractItemSupplier.cancellableBySupplier) && Objects.equals(this.isCancellableBySupplier, bookingContractItemSupplier.isCancellableBySupplier) && Objects.equals(this.cancellableByTraveler, bookingContractItemSupplier.cancellableByTraveler) && Objects.equals(this.isCancellableByTraveler, bookingContractItemSupplier.isCancellableByTraveler) && Objects.equals(this.cancellableWithNoCharges, bookingContractItemSupplier.cancellableWithNoCharges) && Objects.equals(this.cancellableWithPotentialCharges, bookingContractItemSupplier.cancellableWithPotentialCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.supplierItemBookingCode, this.user, this.nameInEnglish, this.descriptionInEnglish, this.totalSourcePrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice, this.totalCapturePrice, this.itinerary, this.pricingType, this.type, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.tokensEarned, this.dailyRateList, this.cancelled, this.totalSourcePriceAfterRefund, this.totalDisplayPriceAfterRefund, this.totalSupplierPriceAfterRefund, this.totalInternalPriceAfterRefund, this.totalCapturePriceAfterRefund, this.cancellableBySupplier, this.isCancellableBySupplier, this.cancellableByTraveler, this.isCancellableByTraveler, this.cancellableWithNoCharges, this.cancellableWithPotentialCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractItemSupplier {\n");
        sb.append("    supplierItemBookingCode: ").append(this.toIndentedString(this.supplierItemBookingCode)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    totalSourcePrice: ").append(this.toIndentedString(this.totalSourcePrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    tokensEarned: ").append(this.toIndentedString(this.tokensEarned)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    totalSourcePriceAfterRefund: ").append(this.toIndentedString(this.totalSourcePriceAfterRefund)).append("\n");
        sb.append("    totalDisplayPriceAfterRefund: ").append(this.toIndentedString(this.totalDisplayPriceAfterRefund)).append("\n");
        sb.append("    totalSupplierPriceAfterRefund: ").append(this.toIndentedString(this.totalSupplierPriceAfterRefund)).append("\n");
        sb.append("    totalInternalPriceAfterRefund: ").append(this.toIndentedString(this.totalInternalPriceAfterRefund)).append("\n");
        sb.append("    totalCapturePriceAfterRefund: ").append(this.toIndentedString(this.totalCapturePriceAfterRefund)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    isCancellableBySupplier: ").append(this.toIndentedString(this.isCancellableBySupplier)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    isCancellableByTraveler: ").append(this.toIndentedString(this.isCancellableByTraveler)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    cancellableWithPotentialCharges: ").append(this.toIndentedString(this.cancellableWithPotentialCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

