/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.AddOnLocalizedInventorySupplier;
import travel.wink.sdk.extranet.model.CancellationPolicySupplier;
import travel.wink.sdk.extranet.model.ExtraChargesSupplier;
import travel.wink.sdk.extranet.model.MoneysSupplier;
import travel.wink.sdk.extranet.model.RatePlanSupplier;
import travel.wink.sdk.extranet.model.RoomConfigurationSupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.StayRateSupplier;

@ApiModel(description="The room we want to book")
@JsonPropertyOrder(value={"adults", "children", "startDate", "endDate", "roomRateIdentifier", "roomRateInternalName", "ratePlan", "perkTypes", "price", "extraCharges", "configuration", "addOnOffers", "perkValue", "activeCancellationPolicy", "roomNights", "commissionable", "commission", "rateSource", "promotion", "sourceTotal", "userSpecifiedCurrencyTotal", "internalTotal", "offerDetails", "available"})
@JsonTypeName(value="RoomConfigurationPrice_Supplier")
public class RoomConfigurationPriceSupplier {
    public static final String JSON_PROPERTY_ADULTS = "adults";
    private Integer adults;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private Integer children;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    private String roomRateIdentifier;
    public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
    private String roomRateInternalName;
    public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
    private RatePlanSupplier ratePlan;
    public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
    private List<PerkTypesEnum> perkTypes = null;
    public static final String JSON_PROPERTY_PRICE = "price";
    private StayRateSupplier price;
    public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
    private ExtraChargesSupplier extraCharges;
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private RoomConfigurationSupplier _configuration;
    public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
    private List<AddOnLocalizedInventorySupplier> addOnOffers = null;
    public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
    private Integer perkValue;
    public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
    private CancellationPolicySupplier activeCancellationPolicy;
    public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
    private Integer roomNights;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Float commission;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private String rateSource;
    public static final String JSON_PROPERTY_PROMOTION = "promotion";
    private List<String> promotion = null;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    private MoneysSupplier sourceTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    private MoneysSupplier userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    private MoneysSupplier internalTotal;
    public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
    private List<SimpleDescriptionSupplier> offerDetails = null;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;

    public RoomConfigurationPriceSupplier adults(Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="The actual amount of adults as determined by the hotel's policy")
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdults(Integer adults) {
        this.adults = adults;
    }

    public RoomConfigurationPriceSupplier children(Integer children) {
        this.children = children;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The actual amount of children as determined by the hotel's policy")
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(Integer children) {
        this.children = children;
    }

    public RoomConfigurationPriceSupplier startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Itinerary startDate")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public RoomConfigurationPriceSupplier endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Itinerary endDate")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public RoomConfigurationPriceSupplier roomRateIdentifier(String roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Specified master rate identifier")
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateIdentifier(String roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public RoomConfigurationPriceSupplier roomRateInternalName(String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Specified master rate internal name")
    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomRateInternalName() {
        return this.roomRateInternalName;
    }

    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateInternalName(String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
    }

    public RoomConfigurationPriceSupplier ratePlan(RatePlanSupplier ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RatePlanSupplier getRatePlan() {
        return this.ratePlan;
    }

    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlan(RatePlanSupplier ratePlan) {
        this.ratePlan = ratePlan;
    }

    public RoomConfigurationPriceSupplier perkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
        return this;
    }

    public RoomConfigurationPriceSupplier addPerkTypesItem(PerkTypesEnum perkTypesItem) {
        if (this.perkTypes == null) {
            this.perkTypes = new ArrayList<PerkTypesEnum>();
        }
        this.perkTypes.add(perkTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PerkTypesEnum> getPerkTypes() {
        return this.perkTypes;
    }

    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
    }

    public RoomConfigurationPriceSupplier price(StayRateSupplier price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StayRateSupplier getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(StayRateSupplier price) {
        this.price = price;
    }

    public RoomConfigurationPriceSupplier extraCharges(ExtraChargesSupplier extraCharges) {
        this.extraCharges = extraCharges;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExtraChargesSupplier getExtraCharges() {
        return this.extraCharges;
    }

    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExtraCharges(ExtraChargesSupplier extraCharges) {
        this.extraCharges = extraCharges;
    }

    public RoomConfigurationPriceSupplier _configuration(RoomConfigurationSupplier _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomConfigurationSupplier getConfiguration() {
        return this._configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConfiguration(RoomConfigurationSupplier _configuration) {
        this._configuration = _configuration;
    }

    public RoomConfigurationPriceSupplier addOnOffers(List<AddOnLocalizedInventorySupplier> addOnOffers) {
        this.addOnOffers = addOnOffers;
        return this;
    }

    public RoomConfigurationPriceSupplier addAddOnOffersItem(AddOnLocalizedInventorySupplier addOnOffersItem) {
        if (this.addOnOffers == null) {
            this.addOnOffers = new ArrayList<AddOnLocalizedInventorySupplier>();
        }
        this.addOnOffers.add(addOnOffersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AddOnLocalizedInventorySupplier> getAddOnOffers() {
        return this.addOnOffers;
    }

    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddOnOffers(List<AddOnLocalizedInventorySupplier> addOnOffers) {
        this.addOnOffers = addOnOffers;
    }

    public RoomConfigurationPriceSupplier perkValue(Integer perkValue) {
        this.perkValue = perkValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The combined value of these perks")
    @JsonProperty(value="perkValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerkValue() {
        return this.perkValue;
    }

    @JsonProperty(value="perkValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkValue(Integer perkValue) {
        this.perkValue = perkValue;
    }

    public RoomConfigurationPriceSupplier activeCancellationPolicy(CancellationPolicySupplier activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CancellationPolicySupplier getActiveCancellationPolicy() {
        return this.activeCancellationPolicy;
    }

    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActiveCancellationPolicy(CancellationPolicySupplier activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
    }

    public RoomConfigurationPriceSupplier roomNights(Integer roomNights) {
        this.roomNights = roomNights;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Number of nights the guests will be staying")
    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRoomNights() {
        return this.roomNights;
    }

    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomNights(Integer roomNights) {
        this.roomNights = roomNights;
    }

    public RoomConfigurationPriceSupplier commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public RoomConfigurationPriceSupplier commission(Float commission) {
        this.commission = commission;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommission(Float commission) {
        this.commission = commission;
    }

    public RoomConfigurationPriceSupplier rateSource(String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateSource(String rateSource) {
        this.rateSource = rateSource;
    }

    public RoomConfigurationPriceSupplier promotion(List<String> promotion) {
        this.promotion = promotion;
        return this;
    }

    public RoomConfigurationPriceSupplier addPromotionItem(String promotionItem) {
        if (this.promotion == null) {
            this.promotion = new ArrayList<String>();
        }
        this.promotion.add(promotionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="promotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotion() {
        return this.promotion;
    }

    @JsonProperty(value="promotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotion(List<String> promotion) {
        this.promotion = promotion;
    }

    public RoomConfigurationPriceSupplier sourceTotal(MoneysSupplier sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(MoneysSupplier sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public RoomConfigurationPriceSupplier userSpecifiedCurrencyTotal(MoneysSupplier userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(MoneysSupplier userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public RoomConfigurationPriceSupplier internalTotal(MoneysSupplier internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(MoneysSupplier internalTotal) {
        this.internalTotal = internalTotal;
    }

    public RoomConfigurationPriceSupplier offerDetails(List<SimpleDescriptionSupplier> offerDetails) {
        this.offerDetails = offerDetails;
        return this;
    }

    public RoomConfigurationPriceSupplier addOfferDetailsItem(SimpleDescriptionSupplier offerDetailsItem) {
        if (this.offerDetails == null) {
            this.offerDetails = new ArrayList<SimpleDescriptionSupplier>();
        }
        this.offerDetails.add(offerDetailsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescriptionSupplier> getOfferDetails() {
        return this.offerDetails;
    }

    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOfferDetails(List<SimpleDescriptionSupplier> offerDetails) {
        this.offerDetails = offerDetails;
    }

    public RoomConfigurationPriceSupplier available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomConfigurationPriceSupplier roomConfigurationPriceSupplier = (RoomConfigurationPriceSupplier)o;
        return Objects.equals(this.adults, roomConfigurationPriceSupplier.adults) && Objects.equals(this.children, roomConfigurationPriceSupplier.children) && Objects.equals(this.startDate, roomConfigurationPriceSupplier.startDate) && Objects.equals(this.endDate, roomConfigurationPriceSupplier.endDate) && Objects.equals(this.roomRateIdentifier, roomConfigurationPriceSupplier.roomRateIdentifier) && Objects.equals(this.roomRateInternalName, roomConfigurationPriceSupplier.roomRateInternalName) && Objects.equals(this.ratePlan, roomConfigurationPriceSupplier.ratePlan) && Objects.equals(this.perkTypes, roomConfigurationPriceSupplier.perkTypes) && Objects.equals(this.price, roomConfigurationPriceSupplier.price) && Objects.equals(this.extraCharges, roomConfigurationPriceSupplier.extraCharges) && Objects.equals(this._configuration, roomConfigurationPriceSupplier._configuration) && Objects.equals(this.addOnOffers, roomConfigurationPriceSupplier.addOnOffers) && Objects.equals(this.perkValue, roomConfigurationPriceSupplier.perkValue) && Objects.equals(this.activeCancellationPolicy, roomConfigurationPriceSupplier.activeCancellationPolicy) && Objects.equals(this.roomNights, roomConfigurationPriceSupplier.roomNights) && Objects.equals(this.commissionable, roomConfigurationPriceSupplier.commissionable) && Objects.equals(this.commission, roomConfigurationPriceSupplier.commission) && Objects.equals(this.rateSource, roomConfigurationPriceSupplier.rateSource) && Objects.equals(this.promotion, roomConfigurationPriceSupplier.promotion) && Objects.equals(this.sourceTotal, roomConfigurationPriceSupplier.sourceTotal) && Objects.equals(this.userSpecifiedCurrencyTotal, roomConfigurationPriceSupplier.userSpecifiedCurrencyTotal) && Objects.equals(this.internalTotal, roomConfigurationPriceSupplier.internalTotal) && Objects.equals(this.offerDetails, roomConfigurationPriceSupplier.offerDetails) && Objects.equals(this.available, roomConfigurationPriceSupplier.available);
    }

    public int hashCode() {
        return Objects.hash(this.adults, this.children, this.startDate, this.endDate, this.roomRateIdentifier, this.roomRateInternalName, this.ratePlan, this.perkTypes, this.price, this.extraCharges, this._configuration, this.addOnOffers, this.perkValue, this.activeCancellationPolicy, this.roomNights, this.commissionable, this.commission, this.rateSource, this.promotion, this.sourceTotal, this.userSpecifiedCurrencyTotal, this.internalTotal, this.offerDetails, this.available);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomConfigurationPriceSupplier {\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    roomRateInternalName: ").append(this.toIndentedString(this.roomRateInternalName)).append("\n");
        sb.append("    ratePlan: ").append(this.toIndentedString(this.ratePlan)).append("\n");
        sb.append("    perkTypes: ").append(this.toIndentedString(this.perkTypes)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    extraCharges: ").append(this.toIndentedString(this.extraCharges)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    addOnOffers: ").append(this.toIndentedString(this.addOnOffers)).append("\n");
        sb.append("    perkValue: ").append(this.toIndentedString(this.perkValue)).append("\n");
        sb.append("    activeCancellationPolicy: ").append(this.toIndentedString(this.activeCancellationPolicy)).append("\n");
        sb.append("    roomNights: ").append(this.toIndentedString(this.roomNights)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    promotion: ").append(this.toIndentedString(this.promotion)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("    offerDetails: ").append(this.toIndentedString(this.offerDetails)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PerkTypesEnum {
        LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
        WINE("PERK_WINE"),
        FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
        FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
        FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
        TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
        TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
        GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
        EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
        ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
        LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
        AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
        AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
        BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
        BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
        BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

        private String value;

        private PerkTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PerkTypesEnum fromValue(String value) {
            for (PerkTypesEnum b : PerkTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

