/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.AggregateGreendexAnswerSupplier;
import travel.wink.sdk.extranet.model.AggregateGreendexScoreByCategorySupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Properties that answered the Green Index questionnaire [full or partial], will have aggregate scores available.
 */
@ApiModel(description = "Properties that answered the Green Index questionnaire [full or partial], will have aggregate scores available.")
@JsonPropertyOrder({
  AggregateGreendexAnswersSupplier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  AggregateGreendexAnswersSupplier.JSON_PROPERTY_LIST,
  AggregateGreendexAnswersSupplier.JSON_PROPERTY_HIGH_SCORE,
  AggregateGreendexAnswersSupplier.JSON_PROPERTY_TOTAL_SCORE,
  AggregateGreendexAnswersSupplier.JSON_PROPERTY_AGGREGATE_SCORE,
  AggregateGreendexAnswersSupplier.JSON_PROPERTY_SCORES_BY_CATEGORY
})
@JsonTypeName("AggregateGreendexAnswers_Supplier")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:48:44.479471290+07:00[Asia/Bangkok]")
public class AggregateGreendexAnswersSupplier {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_LIST = "list";
  private List<AggregateGreendexAnswerSupplier> _list = null;

  public static final String JSON_PROPERTY_HIGH_SCORE = "highScore";
  private Integer highScore;

  public static final String JSON_PROPERTY_TOTAL_SCORE = "totalScore";
  private Integer totalScore;

  public static final String JSON_PROPERTY_AGGREGATE_SCORE = "aggregateScore";
  private Float aggregateScore;

  public static final String JSON_PROPERTY_SCORES_BY_CATEGORY = "scoresByCategory";
  private List<AggregateGreendexScoreByCategorySupplier> scoresByCategory = null;

  public AggregateGreendexAnswersSupplier() { 
  }

  public AggregateGreendexAnswersSupplier hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Get hotelIdentifier
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public AggregateGreendexAnswersSupplier _list(List<AggregateGreendexAnswerSupplier> _list) {
    
    this._list = _list;
    return this;
  }

  public AggregateGreendexAnswersSupplier addListItem(AggregateGreendexAnswerSupplier _listItem) {
    if (this._list == null) {
      this._list = new ArrayList<>();
    }
    this._list.add(_listItem);
    return this;
  }

   /**
   * Get _list
   * @return _list
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AggregateGreendexAnswerSupplier> getList() {
    return _list;
  }


  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setList(List<AggregateGreendexAnswerSupplier> _list) {
    this._list = _list;
  }


  public AggregateGreendexAnswersSupplier highScore(Integer highScore) {
    
    this.highScore = highScore;
    return this;
  }

   /**
   * The highest possible score from all questions
   * @return highScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "100", value = "The highest possible score from all questions")
  @JsonProperty(JSON_PROPERTY_HIGH_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHighScore() {
    return highScore;
  }


  @JsonProperty(JSON_PROPERTY_HIGH_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHighScore(Integer highScore) {
    this.highScore = highScore;
  }


  public AggregateGreendexAnswersSupplier totalScore(Integer totalScore) {
    
    this.totalScore = totalScore;
    return this;
  }

   /**
   * The total score from all questions answered
   * @return totalScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "50", value = "The total score from all questions answered")
  @JsonProperty(JSON_PROPERTY_TOTAL_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalScore() {
    return totalScore;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalScore(Integer totalScore) {
    this.totalScore = totalScore;
  }


  public AggregateGreendexAnswersSupplier aggregateScore(Float aggregateScore) {
    
    this.aggregateScore = aggregateScore;
    return this;
  }

   /**
   * Total score divided by high score
   * minimum: 0
   * maximum: 1
   * @return aggregateScore
  **/
  @javax.annotation.Nullable
 @DecimalMin("0") @DecimalMax("1")  @ApiModelProperty(value = "Total score divided by high score")
  @JsonProperty(JSON_PROPERTY_AGGREGATE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateScore() {
    return aggregateScore;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateScore(Float aggregateScore) {
    this.aggregateScore = aggregateScore;
  }


  public AggregateGreendexAnswersSupplier scoresByCategory(List<AggregateGreendexScoreByCategorySupplier> scoresByCategory) {
    
    this.scoresByCategory = scoresByCategory;
    return this;
  }

  public AggregateGreendexAnswersSupplier addScoresByCategoryItem(AggregateGreendexScoreByCategorySupplier scoresByCategoryItem) {
    if (this.scoresByCategory == null) {
      this.scoresByCategory = new ArrayList<>();
    }
    this.scoresByCategory.add(scoresByCategoryItem);
    return this;
  }

   /**
   * Aggregate scores by Green Index category
   * @return scoresByCategory
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Aggregate scores by Green Index category")
  @JsonProperty(JSON_PROPERTY_SCORES_BY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AggregateGreendexScoreByCategorySupplier> getScoresByCategory() {
    return scoresByCategory;
  }


  @JsonProperty(JSON_PROPERTY_SCORES_BY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScoresByCategory(List<AggregateGreendexScoreByCategorySupplier> scoresByCategory) {
    this.scoresByCategory = scoresByCategory;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AggregateGreendexAnswersSupplier aggregateGreendexAnswersSupplier = (AggregateGreendexAnswersSupplier) o;
    return Objects.equals(this.hotelIdentifier, aggregateGreendexAnswersSupplier.hotelIdentifier) &&
        Objects.equals(this._list, aggregateGreendexAnswersSupplier._list) &&
        Objects.equals(this.highScore, aggregateGreendexAnswersSupplier.highScore) &&
        Objects.equals(this.totalScore, aggregateGreendexAnswersSupplier.totalScore) &&
        Objects.equals(this.aggregateScore, aggregateGreendexAnswersSupplier.aggregateScore) &&
        Objects.equals(this.scoresByCategory, aggregateGreendexAnswersSupplier.scoresByCategory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, _list, highScore, totalScore, aggregateScore, scoresByCategory);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AggregateGreendexAnswersSupplier {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    _list: ").append(toIndentedString(_list)).append("\n");
    sb.append("    highScore: ").append(toIndentedString(highScore)).append("\n");
    sb.append("    totalScore: ").append(toIndentedString(totalScore)).append("\n");
    sb.append("    aggregateScore: ").append(toIndentedString(aggregateScore)).append("\n");
    sb.append("    scoresByCategory: ").append(toIndentedString(scoresByCategory)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

