/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import travel.wink.sdk.extranet.model.MoneysSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BeneficiarySupplier
 */
@JsonPropertyOrder({
  BeneficiarySupplier.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  BeneficiarySupplier.JSON_PROPERTY_TYPE,
  BeneficiarySupplier.JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY,
  BeneficiarySupplier.JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY,
  BeneficiarySupplier.JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY,
  BeneficiarySupplier.JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY,
  BeneficiarySupplier.JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY
})
@JsonTypeName("Beneficiary_Supplier")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:48:44.479471290+07:00[Asia/Bangkok]")
public class BeneficiarySupplier {
  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private UUID accountIdentifier;

  /**
   * The type of beneficiary payment.
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    SALE("SALE"),
    
    TRIP_PAY("TRIP_PAY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
  private MoneysSupplier amountDueInSourceCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
  private MoneysSupplier amountDueInDisplayCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
  private MoneysSupplier amountDueInSupplierCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
  private MoneysSupplier amountDueInInternalCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
  private MoneysSupplier amountDueInCaptureCurrency;

  public BeneficiarySupplier() { 
  }

  public BeneficiarySupplier accountIdentifier(UUID accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

   /**
   * accountIdentifier of beneficiary from payment
   * @return accountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "accountIdentifier of beneficiary from payment")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(UUID accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }


  public BeneficiarySupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of beneficiary payment.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "The type of beneficiary payment.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BeneficiarySupplier amountDueInSourceCurrency(MoneysSupplier amountDueInSourceCurrency) {
    
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    return this;
  }

   /**
   * Get amountDueInSourceCurrency
   * @return amountDueInSourceCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplier getAmountDueInSourceCurrency() {
    return amountDueInSourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSourceCurrency(MoneysSupplier amountDueInSourceCurrency) {
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
  }


  public BeneficiarySupplier amountDueInDisplayCurrency(MoneysSupplier amountDueInDisplayCurrency) {
    
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    return this;
  }

   /**
   * Get amountDueInDisplayCurrency
   * @return amountDueInDisplayCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplier getAmountDueInDisplayCurrency() {
    return amountDueInDisplayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInDisplayCurrency(MoneysSupplier amountDueInDisplayCurrency) {
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
  }


  public BeneficiarySupplier amountDueInSupplierCurrency(MoneysSupplier amountDueInSupplierCurrency) {
    
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    return this;
  }

   /**
   * Get amountDueInSupplierCurrency
   * @return amountDueInSupplierCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplier getAmountDueInSupplierCurrency() {
    return amountDueInSupplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSupplierCurrency(MoneysSupplier amountDueInSupplierCurrency) {
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
  }


  public BeneficiarySupplier amountDueInInternalCurrency(MoneysSupplier amountDueInInternalCurrency) {
    
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    return this;
  }

   /**
   * Get amountDueInInternalCurrency
   * @return amountDueInInternalCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplier getAmountDueInInternalCurrency() {
    return amountDueInInternalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInInternalCurrency(MoneysSupplier amountDueInInternalCurrency) {
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
  }


  public BeneficiarySupplier amountDueInCaptureCurrency(MoneysSupplier amountDueInCaptureCurrency) {
    
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    return this;
  }

   /**
   * Get amountDueInCaptureCurrency
   * @return amountDueInCaptureCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplier getAmountDueInCaptureCurrency() {
    return amountDueInCaptureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInCaptureCurrency(MoneysSupplier amountDueInCaptureCurrency) {
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BeneficiarySupplier beneficiarySupplier = (BeneficiarySupplier) o;
    return Objects.equals(this.accountIdentifier, beneficiarySupplier.accountIdentifier) &&
        Objects.equals(this.type, beneficiarySupplier.type) &&
        Objects.equals(this.amountDueInSourceCurrency, beneficiarySupplier.amountDueInSourceCurrency) &&
        Objects.equals(this.amountDueInDisplayCurrency, beneficiarySupplier.amountDueInDisplayCurrency) &&
        Objects.equals(this.amountDueInSupplierCurrency, beneficiarySupplier.amountDueInSupplierCurrency) &&
        Objects.equals(this.amountDueInInternalCurrency, beneficiarySupplier.amountDueInInternalCurrency) &&
        Objects.equals(this.amountDueInCaptureCurrency, beneficiarySupplier.amountDueInCaptureCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentifier, type, amountDueInSourceCurrency, amountDueInDisplayCurrency, amountDueInSupplierCurrency, amountDueInInternalCurrency, amountDueInCaptureCurrency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BeneficiarySupplier {\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    amountDueInSourceCurrency: ").append(toIndentedString(amountDueInSourceCurrency)).append("\n");
    sb.append("    amountDueInDisplayCurrency: ").append(toIndentedString(amountDueInDisplayCurrency)).append("\n");
    sb.append("    amountDueInSupplierCurrency: ").append(toIndentedString(amountDueInSupplierCurrency)).append("\n");
    sb.append("    amountDueInInternalCurrency: ").append(toIndentedString(amountDueInInternalCurrency)).append("\n");
    sb.append("    amountDueInCaptureCurrency: ").append(toIndentedString(amountDueInCaptureCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

