/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.MoneysSupplierDetails;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplierDetails;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * This is one bookable item that can stand alongside a restaurant / meeting room etc.
 */
@ApiModel(description = "This is one bookable item that can stand alongside a restaurant / meeting room etc.")
@JsonPropertyOrder({
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_IDENTIFIER,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_NAME,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_DESCRIPTIONS,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_PRICING_TYPE,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_BASE_PRICE,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_DISCOUNTED_PRICE,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_MULTIMEDIAS,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_MIN_PAX,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_MAX_PAX,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_PERCENT_DISCOUNT,
  TransactionalTravelInventorySupplierDetails.JSON_PROPERTY_PERCENT_PREMIUM
})
@JsonTypeName("TransactionalTravelInventory_SupplierDetails")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:48:44.479471290+07:00[Asia/Bangkok]")
public class TransactionalTravelInventorySupplierDetails {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionSupplierDetails> descriptions = new ArrayList<>();

  /**
   * How this inventory item should be priced.
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
  private MoneysSupplierDetails basePrice;

  public static final String JSON_PROPERTY_DISCOUNTED_PRICE = "discountedPrice";
  private MoneysSupplierDetails discountedPrice;

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaSupplierDetails> multimedias = null;

  public static final String JSON_PROPERTY_MIN_PAX = "minPax";
  private Integer minPax;

  public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
  private Integer maxPax;

  public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
  private Float percentDiscount;

  public static final String JSON_PROPERTY_PERCENT_PREMIUM = "percentPremium";
  private Float percentPremium;

  public TransactionalTravelInventorySupplierDetails() { 
  }

  public TransactionalTravelInventorySupplierDetails identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique transactional identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Unique transactional identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public TransactionalTravelInventorySupplierDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of transactional inventory.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1 hour session", required = true, value = "Internal name of transactional inventory.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public TransactionalTravelInventorySupplierDetails descriptions(List<SimpleDescriptionSupplierDetails> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public TransactionalTravelInventorySupplierDetails addDescriptionsItem(SimpleDescriptionSupplierDetails descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Localized descriptions describing inventory.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionSupplierDetails> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionSupplierDetails> descriptions) {
    this.descriptions = descriptions;
  }


  public TransactionalTravelInventorySupplierDetails pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How this inventory item should be priced.
   * @return pricingType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "How this inventory item should be priced.")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public TransactionalTravelInventorySupplierDetails basePrice(MoneysSupplierDetails basePrice) {
    
    this.basePrice = basePrice;
    return this;
  }

   /**
   * Get basePrice
   * @return basePrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplierDetails getBasePrice() {
    return basePrice;
  }


  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBasePrice(MoneysSupplierDetails basePrice) {
    this.basePrice = basePrice;
  }


  public TransactionalTravelInventorySupplierDetails discountedPrice(MoneysSupplierDetails discountedPrice) {
    
    this.discountedPrice = discountedPrice;
    return this;
  }

   /**
   * Get discountedPrice
   * @return discountedPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISCOUNTED_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplierDetails getDiscountedPrice() {
    return discountedPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNTED_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDiscountedPrice(MoneysSupplierDetails discountedPrice) {
    this.discountedPrice = discountedPrice;
  }


  public TransactionalTravelInventorySupplierDetails multimedias(List<SimpleMultimediaSupplierDetails> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public TransactionalTravelInventorySupplierDetails addMultimediasItem(SimpleMultimediaSupplierDetails multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of item.
   * @return multimedias
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "List of images / videos of item.")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaSupplierDetails> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimedias(List<SimpleMultimediaSupplierDetails> multimedias) {
    this.multimedias = multimedias;
  }


  public TransactionalTravelInventorySupplierDetails minPax(Integer minPax) {
    
    this.minPax = minPax;
    return this;
  }

   /**
   * Whether there is a limit to minimum group size.
   * @return minPax
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Whether there is a limit to minimum group size.")
  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinPax() {
    return minPax;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPax(Integer minPax) {
    this.minPax = minPax;
  }


  public TransactionalTravelInventorySupplierDetails maxPax(Integer maxPax) {
    
    this.maxPax = maxPax;
    return this;
  }

   /**
   * Whether there is a limit to maximum group size.
   * @return maxPax
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "Whether there is a limit to maximum group size.")
  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxPax() {
    return maxPax;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPax(Integer maxPax) {
    this.maxPax = maxPax;
  }


  public TransactionalTravelInventorySupplierDetails percentDiscount(Float percentDiscount) {
    
    this.percentDiscount = percentDiscount;
    return this;
  }

   /**
   * Calculates the percent difference between basePrice and discountedPrice.
   * @return percentDiscount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.1", value = "Calculates the percent difference between basePrice and discountedPrice.")
  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPercentDiscount() {
    return percentDiscount;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentDiscount(Float percentDiscount) {
    this.percentDiscount = percentDiscount;
  }


  public TransactionalTravelInventorySupplierDetails percentPremium(Float percentPremium) {
    
    this.percentPremium = percentPremium;
    return this;
  }

   /**
   * Calculates the percent difference between basePrice and discountedPrice.
   * @return percentPremium
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.1", value = "Calculates the percent difference between basePrice and discountedPrice.")
  @JsonProperty(JSON_PROPERTY_PERCENT_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPercentPremium() {
    return percentPremium;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentPremium(Float percentPremium) {
    this.percentPremium = percentPremium;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionalTravelInventorySupplierDetails transactionalTravelInventorySupplierDetails = (TransactionalTravelInventorySupplierDetails) o;
    return Objects.equals(this.identifier, transactionalTravelInventorySupplierDetails.identifier) &&
        Objects.equals(this.name, transactionalTravelInventorySupplierDetails.name) &&
        Objects.equals(this.descriptions, transactionalTravelInventorySupplierDetails.descriptions) &&
        Objects.equals(this.pricingType, transactionalTravelInventorySupplierDetails.pricingType) &&
        Objects.equals(this.basePrice, transactionalTravelInventorySupplierDetails.basePrice) &&
        Objects.equals(this.discountedPrice, transactionalTravelInventorySupplierDetails.discountedPrice) &&
        Objects.equals(this.multimedias, transactionalTravelInventorySupplierDetails.multimedias) &&
        Objects.equals(this.minPax, transactionalTravelInventorySupplierDetails.minPax) &&
        Objects.equals(this.maxPax, transactionalTravelInventorySupplierDetails.maxPax) &&
        Objects.equals(this.percentDiscount, transactionalTravelInventorySupplierDetails.percentDiscount) &&
        Objects.equals(this.percentPremium, transactionalTravelInventorySupplierDetails.percentPremium);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, descriptions, pricingType, basePrice, discountedPrice, multimedias, minPax, maxPax, percentDiscount, percentPremium);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionalTravelInventorySupplierDetails {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    basePrice: ").append(toIndentedString(basePrice)).append("\n");
    sb.append("    discountedPrice: ").append(toIndentedString(discountedPrice)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    minPax: ").append(toIndentedString(minPax)).append("\n");
    sb.append("    maxPax: ").append(toIndentedString(maxPax)).append("\n");
    sb.append("    percentDiscount: ").append(toIndentedString(percentDiscount)).append("\n");
    sb.append("    percentPremium: ").append(toIndentedString(percentPremium)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

