/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.RefPointViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.UpsertPlaceRequestSupplier;

public class PlaceApi {
    private ApiClient apiClient;

    public PlaceApi() {
        this(new ApiClient());
    }

    @Autowired
    public PlaceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createPlaceRequestCreation(String hotelIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertPlaceRequestSupplier postBody = upsertPlaceRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPlaceRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPlaceRequestSupplier' when calling createPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> createPlace(String hotelIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.createPlaceRequestCreation(hotelIdentifier, upsertPlaceRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> createPlaceWithHttpInfo(String hotelIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.createPlaceRequestCreation(hotelIdentifier, upsertPlaceRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removePlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removePlace(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(){};
        return this.removePlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removePlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(){};
        return this.removePlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> showPlace(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.showPlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> showPlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.showPlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPlacePairsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlacePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showPlacePairs(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showPlacePairsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showPlacePairsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showPlacePairsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPlacesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlaces", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RefPointViewSupplier> showPlaces(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.showPlacesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RefPointViewSupplier>>> showPlacesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.showPlacesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updatePlaceRequestCreation(String hotelIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertPlaceRequestSupplier postBody = upsertPlaceRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPlaceRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPlaceRequestSupplier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> updatePlace(String hotelIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.updatePlaceRequestCreation(hotelIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> updatePlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.updatePlaceRequestCreation(hotelIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec uploadPlaceMediaRequestCreation(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> uploadPlaceMedia(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> uploadPlaceMediaWithHttpInfo(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(){};
        return this.uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

