/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="List of localized descriptions for this fee.")
@JsonPropertyOrder(value={"description", "language"})
@JsonTypeName(value="LocalizedDescription_Supplier")
public class LocalizedDescriptionSupplier {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language = "en";

    public LocalizedDescriptionSupplier description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="This is a longer description that explains its relationship to parent nicely.", required=true, value="Longer text description")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public LocalizedDescriptionSupplier language(String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=2, max=2)
    @ApiModelProperty(example="en", required=true, value="Indicate which language this description is written in.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=2) String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedDescriptionSupplier localizedDescriptionSupplier = (LocalizedDescriptionSupplier)o;
        return Objects.equals(this.description, localizedDescriptionSupplier.description) && Objects.equals(this.language, localizedDescriptionSupplier.language);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.language);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocalizedDescriptionSupplier {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

