/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.AgreementSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.UpsertAddressRequestSupplier;

@JsonPropertyOrder(value={"name", "legalName", "localName", "currencyCode", "numberOfRooms", "reservationDeskStartTime", "reservationDeskEndTime", "address", "reservation", "owner", "agreement"})
@JsonTypeName(value="PropertyRegistrationRequest_Supplier")
public class PropertyRegistrationRequestSupplier {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    private String legalName;
    public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
    private String localName;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
    private Integer numberOfRooms;
    public static final String JSON_PROPERTY_RESERVATION_DESK_START_TIME = "reservationDeskStartTime";
    private String reservationDeskStartTime;
    public static final String JSON_PROPERTY_RESERVATION_DESK_END_TIME = "reservationDeskEndTime";
    private String reservationDeskEndTime;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private UpsertAddressRequestSupplier address;
    public static final String JSON_PROPERTY_RESERVATION = "reservation";
    private ContactSupplier reservation;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private ContactSupplier owner;
    public static final String JSON_PROPERTY_AGREEMENT = "agreement";
    private AgreementSupplier agreement;

    public PropertyRegistrationRequestSupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="The Getaway resort - Ubud", required=true, value="Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public PropertyRegistrationRequestSupplier legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Getaway Resorts Limited", required=true, value="Legal name of the hotel as it is registered.")
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public PropertyRegistrationRequestSupplier localName(String localName) {
        this.localName = localName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Getaway Resorts Limited", required=true, value="Local name of the hotel as it is referred to in the local language.")
    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocalName() {
        return this.localName;
    }

    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public PropertyRegistrationRequestSupplier currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="INR", required=true, value="Valid 3-character ISO currency code. Find our [supported currency codes here](#operation/showCurrencies).")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PropertyRegistrationRequestSupplier numberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="40", required=true, value="Number of rooms / keys for property")
    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public PropertyRegistrationRequestSupplier reservationDeskStartTime(String reservationDeskStartTime) {
        this.reservationDeskStartTime = reservationDeskStartTime;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="10:00", required=true, value="If the reservation desk does not operate 24 hours, enter a start time.")
    @JsonProperty(value="reservationDeskStartTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getReservationDeskStartTime() {
        return this.reservationDeskStartTime;
    }

    @JsonProperty(value="reservationDeskStartTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReservationDeskStartTime(String reservationDeskStartTime) {
        this.reservationDeskStartTime = reservationDeskStartTime;
    }

    public PropertyRegistrationRequestSupplier reservationDeskEndTime(String reservationDeskEndTime) {
        this.reservationDeskEndTime = reservationDeskEndTime;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="23:00", required=true, value="If the reservation desk does not operate 24 hours, enter an end time.")
    @JsonProperty(value="reservationDeskEndTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getReservationDeskEndTime() {
        return this.reservationDeskEndTime;
    }

    @JsonProperty(value="reservationDeskEndTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReservationDeskEndTime(String reservationDeskEndTime) {
        this.reservationDeskEndTime = reservationDeskEndTime;
    }

    public PropertyRegistrationRequestSupplier address(UpsertAddressRequestSupplier address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UpsertAddressRequestSupplier getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(UpsertAddressRequestSupplier address) {
        this.address = address;
    }

    public PropertyRegistrationRequestSupplier reservation(ContactSupplier reservation) {
        this.reservation = reservation;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="reservation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactSupplier getReservation() {
        return this.reservation;
    }

    @JsonProperty(value="reservation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReservation(ContactSupplier reservation) {
        this.reservation = reservation;
    }

    public PropertyRegistrationRequestSupplier owner(ContactSupplier owner) {
        this.owner = owner;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactSupplier getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwner(ContactSupplier owner) {
        this.owner = owner;
    }

    public PropertyRegistrationRequestSupplier agreement(AgreementSupplier agreement) {
        this.agreement = agreement;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="agreement")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AgreementSupplier getAgreement() {
        return this.agreement;
    }

    @JsonProperty(value="agreement")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAgreement(AgreementSupplier agreement) {
        this.agreement = agreement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier = (PropertyRegistrationRequestSupplier)o;
        return Objects.equals(this.name, propertyRegistrationRequestSupplier.name) && Objects.equals(this.legalName, propertyRegistrationRequestSupplier.legalName) && Objects.equals(this.localName, propertyRegistrationRequestSupplier.localName) && Objects.equals(this.currencyCode, propertyRegistrationRequestSupplier.currencyCode) && Objects.equals(this.numberOfRooms, propertyRegistrationRequestSupplier.numberOfRooms) && Objects.equals(this.reservationDeskStartTime, propertyRegistrationRequestSupplier.reservationDeskStartTime) && Objects.equals(this.reservationDeskEndTime, propertyRegistrationRequestSupplier.reservationDeskEndTime) && Objects.equals(this.address, propertyRegistrationRequestSupplier.address) && Objects.equals(this.reservation, propertyRegistrationRequestSupplier.reservation) && Objects.equals(this.owner, propertyRegistrationRequestSupplier.owner) && Objects.equals(this.agreement, propertyRegistrationRequestSupplier.agreement);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.legalName, this.localName, this.currencyCode, this.numberOfRooms, this.reservationDeskStartTime, this.reservationDeskEndTime, this.address, this.reservation, this.owner, this.agreement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertyRegistrationRequestSupplier {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    localName: ").append(this.toIndentedString(this.localName)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    numberOfRooms: ").append(this.toIndentedString(this.numberOfRooms)).append("\n");
        sb.append("    reservationDeskStartTime: ").append(this.toIndentedString(this.reservationDeskStartTime)).append("\n");
        sb.append("    reservationDeskEndTime: ").append(this.toIndentedString(this.reservationDeskEndTime)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    reservation: ").append(this.toIndentedString(this.reservation)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString(this.agreement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

