/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.RateModifierSupplierDetails;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplierDetails;
import travel.wink.sdk.extranet.model.VariableChargeSupplierDetails;

@ApiModel(description="Promotion bundles for this channel")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "name", "enabled", "items", "modifierOverride", "type", "pricingType", "isValid", "description", "hasFixedDiscountModifier", "hasPercentDiscountModifier"})
@JsonTypeName(value="RateModifierBundle_SupplierDetails")
public class RateModifierBundleSupplierDetails {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<RateModifierSupplierDetails> items = new ArrayList<RateModifierSupplierDetails>();
    public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
    private VariableChargeSupplierDetails modifierOverride;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_IS_VALID = "isValid";
    private Boolean isValid;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private List<SimpleDescriptionSupplierDetails> description = null;
    public static final String JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER = "hasFixedDiscountModifier";
    private Boolean hasFixedDiscountModifier;
    public static final String JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER = "hasPercentDiscountModifier";
    private Boolean hasPercentDiscountModifier;

    public RateModifierBundleSupplierDetails identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RateModifierBundleSupplierDetails hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RateModifierBundleSupplierDetails name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Early bird - Long Term", required=true, value="Internal name of promotion ancillary.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RateModifierBundleSupplierDetails enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether this promotion ancillary is enabled or not.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public RateModifierBundleSupplierDetails items(List<RateModifierSupplierDetails> items) {
        this.items = items;
        return this;
    }

    public RateModifierBundleSupplierDetails addItemsItem(RateModifierSupplierDetails itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RateModifierSupplierDetails> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItems(List<RateModifierSupplierDetails> items) {
        this.items = items;
    }

    public RateModifierBundleSupplierDetails modifierOverride(VariableChargeSupplierDetails modifierOverride) {
        this.modifierOverride = modifierOverride;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VariableChargeSupplierDetails getModifierOverride() {
        return this.modifierOverride;
    }

    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModifierOverride(VariableChargeSupplierDetails modifierOverride) {
        this.modifierOverride = modifierOverride;
    }

    public RateModifierBundleSupplierDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="DISCOUNT", value="Required if manual override modifier is not null")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RateModifierBundleSupplierDetails pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public RateModifierBundleSupplierDetails isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="isValid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsValid() {
        return this.isValid;
    }

    @JsonProperty(value="isValid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public RateModifierBundleSupplierDetails description(List<SimpleDescriptionSupplierDetails> description) {
        this.description = description;
        return this;
    }

    public RateModifierBundleSupplierDetails addDescriptionItem(SimpleDescriptionSupplierDetails descriptionItem) {
        if (this.description == null) {
            this.description = new ArrayList<SimpleDescriptionSupplierDetails>();
        }
        this.description.add(descriptionItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescriptionSupplierDetails> getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(List<SimpleDescriptionSupplierDetails> description) {
        this.description = description;
    }

    public RateModifierBundleSupplierDetails hasFixedDiscountModifier(Boolean hasFixedDiscountModifier) {
        this.hasFixedDiscountModifier = hasFixedDiscountModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasFixedDiscountModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasFixedDiscountModifier() {
        return this.hasFixedDiscountModifier;
    }

    @JsonProperty(value="hasFixedDiscountModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasFixedDiscountModifier(Boolean hasFixedDiscountModifier) {
        this.hasFixedDiscountModifier = hasFixedDiscountModifier;
    }

    public RateModifierBundleSupplierDetails hasPercentDiscountModifier(Boolean hasPercentDiscountModifier) {
        this.hasPercentDiscountModifier = hasPercentDiscountModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasPercentDiscountModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPercentDiscountModifier() {
        return this.hasPercentDiscountModifier;
    }

    @JsonProperty(value="hasPercentDiscountModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPercentDiscountModifier(Boolean hasPercentDiscountModifier) {
        this.hasPercentDiscountModifier = hasPercentDiscountModifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateModifierBundleSupplierDetails rateModifierBundleSupplierDetails = (RateModifierBundleSupplierDetails)o;
        return Objects.equals(this.identifier, rateModifierBundleSupplierDetails.identifier) && Objects.equals(this.hotelIdentifier, rateModifierBundleSupplierDetails.hotelIdentifier) && Objects.equals(this.name, rateModifierBundleSupplierDetails.name) && Objects.equals(this.enabled, rateModifierBundleSupplierDetails.enabled) && Objects.equals(this.items, rateModifierBundleSupplierDetails.items) && Objects.equals(this.modifierOverride, rateModifierBundleSupplierDetails.modifierOverride) && Objects.equals((Object)this.type, (Object)rateModifierBundleSupplierDetails.type) && Objects.equals((Object)this.pricingType, (Object)rateModifierBundleSupplierDetails.pricingType) && Objects.equals(this.isValid, rateModifierBundleSupplierDetails.isValid) && Objects.equals(this.description, rateModifierBundleSupplierDetails.description) && Objects.equals(this.hasFixedDiscountModifier, rateModifierBundleSupplierDetails.hasFixedDiscountModifier) && Objects.equals(this.hasPercentDiscountModifier, rateModifierBundleSupplierDetails.hasPercentDiscountModifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.name, this.enabled, this.items, this.modifierOverride, this.type, this.pricingType, this.isValid, this.description, this.hasFixedDiscountModifier, this.hasPercentDiscountModifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RateModifierBundleSupplierDetails {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    modifierOverride: ").append(this.toIndentedString(this.modifierOverride)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.isValid)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hasFixedDiscountModifier: ").append(this.toIndentedString(this.hasFixedDiscountModifier)).append("\n");
        sb.append("    hasPercentDiscountModifier: ").append(this.toIndentedString(this.hasPercentDiscountModifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PREMIUM("PREMIUM"),
        DISCOUNT("DISCOUNT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

