/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.AddressSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.DowPatternGroupSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.model.SocialSupplier;
import travel.wink.sdk.extranet.model.TransactionalTravelInventorySupplier;
import travel.wink.sdk.extranet.model.TravelInventoryRecognitionSupplier;

@ApiModel(description="Restaurant data")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "transactionalInventoryList", "applicableStart", "applicableEnd", "reservationRequiredInd", "opens", "closes", "daysOfWeek", "maxSeatingCapacity", "maxSingleParty", "offerBreakfast", "offerLunch", "offerDinner", "offerBrunch", "amenities", "infoCodes", "cuisineCodes"})
@JsonTypeName(value="Restaurant_Supplier")
public class RestaurantSupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointSupplier location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaSupplier> multimedias = new ArrayList<SimpleMultimediaSupplier>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactSupplier contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressSupplier address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures = null;
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures = null;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<SocialSupplier> socials = null;
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    private List<TravelInventoryRecognitionSupplier> recognitionList = null;
    public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
    private List<TransactionalTravelInventorySupplier> transactionalInventoryList = null;
    public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
    private LocalDate applicableStart;
    public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
    private LocalDate applicableEnd;
    public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
    private Boolean reservationRequiredInd;
    public static final String JSON_PROPERTY_OPENS = "opens";
    private String opens;
    public static final String JSON_PROPERTY_CLOSES = "closes";
    private String closes;
    public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
    private DowPatternGroupSupplier daysOfWeek;
    public static final String JSON_PROPERTY_MAX_SEATING_CAPACITY = "maxSeatingCapacity";
    private Integer maxSeatingCapacity;
    public static final String JSON_PROPERTY_MAX_SINGLE_PARTY = "maxSingleParty";
    private Integer maxSingleParty;
    public static final String JSON_PROPERTY_OFFER_BREAKFAST = "offerBreakfast";
    private Boolean offerBreakfast = false;
    public static final String JSON_PROPERTY_OFFER_LUNCH = "offerLunch";
    private Boolean offerLunch = false;
    public static final String JSON_PROPERTY_OFFER_DINNER = "offerDinner";
    private Boolean offerDinner = false;
    public static final String JSON_PROPERTY_OFFER_BRUNCH = "offerBrunch";
    private Boolean offerBrunch = false;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    private List<String> amenities = null;
    public static final String JSON_PROPERTY_INFO_CODES = "infoCodes";
    private List<String> infoCodes = null;
    public static final String JSON_PROPERTY_CUISINE_CODES = "cuisineCodes";
    private List<String> cuisineCodes = null;

    public RestaurantSupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RestaurantSupplier hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RestaurantSupplier featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public RestaurantSupplier lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Indicate the type of lifestyle this inventory should be associated with.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public RestaurantSupplier location(GeoJsonPointSupplier location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointSupplier getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPointSupplier location) {
        this.location = location;
    }

    public RestaurantSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public RestaurantSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public RestaurantSupplier multimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public RestaurantSupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of inventory.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimediaSupplier> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
    }

    public RestaurantSupplier contact(ContactSupplier contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactSupplier getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(ContactSupplier contact) {
        this.contact = contact;
    }

    public RestaurantSupplier address(AddressSupplier address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressSupplier getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressSupplier address) {
        this.address = address;
    }

    public RestaurantSupplier commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicate whether sales channels receive commission for selling this inventory.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public RestaurantSupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Archery lesson", required=true, value="Internal name of inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RestaurantSupplier proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Supported OTA specification `PRX` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public RestaurantSupplier sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Use this property to sort an inventory in a list of activities.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public RestaurantSupplier minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `AQC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public RestaurantSupplier bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public RestaurantSupplier active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Modify inventory availability with this flag.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public RestaurantSupplier disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public RestaurantSupplier addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public RestaurantSupplier securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public RestaurantSupplier addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public RestaurantSupplier socials(List<SocialSupplier> socials) {
        this.socials = socials;
        return this;
    }

    public RestaurantSupplier addSocialsItem(SocialSupplier socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialSupplier>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Social network accounts for inventory (if applicable).")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SocialSupplier> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<SocialSupplier> socials) {
        this.socials = socials;
    }

    public RestaurantSupplier pricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="THREE", required=true, value="Level of expensiveness.")
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public RestaurantSupplier recognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public RestaurantSupplier addRecognitionListItem(TravelInventoryRecognitionSupplier recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionSupplier>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Inventory-level recognition.")
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TravelInventoryRecognitionSupplier> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public RestaurantSupplier transactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
        return this;
    }

    public RestaurantSupplier addTransactionalInventoryListItem(TransactionalTravelInventorySupplier transactionalInventoryListItem) {
        if (this.transactionalInventoryList == null) {
            this.transactionalInventoryList = new ArrayList<TransactionalTravelInventorySupplier>();
        }
        this.transactionalInventoryList.add(transactionalInventoryListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Purchasable items for this inventory.")
    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransactionalTravelInventorySupplier> getTransactionalInventoryList() {
        return this.transactionalInventoryList;
    }

    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
    }

    public RestaurantSupplier applicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Thu Jan 01 07:00:00 ICT 1970", value="Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.")
    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableStart() {
        return this.applicableStart;
    }

    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
    }

    public RestaurantSupplier applicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Tue Dec 01 07:00:00 ICT 1970", value="End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.")
    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableEnd() {
        return this.applicableEnd;
    }

    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
    }

    public RestaurantSupplier reservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Indicates whether a reservation is required to participate in this inventory.")
    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReservationRequiredInd() {
        return this.reservationRequiredInd;
    }

    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
    }

    public RestaurantSupplier opens(String opens) {
        this.opens = opens;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="09:00", value="Opening time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpens() {
        return this.opens;
    }

    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpens(String opens) {
        this.opens = opens;
    }

    public RestaurantSupplier closes(String closes) {
        this.closes = closes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="17:30", value="Closing time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloses() {
        return this.closes;
    }

    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloses(String closes) {
        this.closes = closes;
    }

    public RestaurantSupplier daysOfWeek(DowPatternGroupSupplier daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupSupplier getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDaysOfWeek(DowPatternGroupSupplier daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public RestaurantSupplier maxSeatingCapacity(Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="100", required=true, value="Restaurant supports these many people.")
    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSeatingCapacity() {
        return this.maxSeatingCapacity;
    }

    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSeatingCapacity(Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
    }

    public RestaurantSupplier maxSingleParty(Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="10", required=true, value="Largest table at restaurant.")
    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSingleParty() {
        return this.maxSingleParty;
    }

    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSingleParty(Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
    }

    public RestaurantSupplier offerBreakfast(Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers breakfast.")
    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBreakfast() {
        return this.offerBreakfast;
    }

    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBreakfast(Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
    }

    public RestaurantSupplier offerLunch(Boolean offerLunch) {
        this.offerLunch = offerLunch;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers lunch.")
    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferLunch() {
        return this.offerLunch;
    }

    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferLunch(Boolean offerLunch) {
        this.offerLunch = offerLunch;
    }

    public RestaurantSupplier offerDinner(Boolean offerDinner) {
        this.offerDinner = offerDinner;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers dinner.")
    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferDinner() {
        return this.offerDinner;
    }

    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferDinner(Boolean offerDinner) {
        this.offerDinner = offerDinner;
    }

    public RestaurantSupplier offerBrunch(Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Restaurant offers brunch.")
    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBrunch() {
        return this.offerBrunch;
    }

    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBrunch(Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
    }

    public RestaurantSupplier amenities(List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public RestaurantSupplier addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `RSI` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(List<String> amenities) {
        this.amenities = amenities;
    }

    public RestaurantSupplier infoCodes(List<String> infoCodes) {
        this.infoCodes = infoCodes;
        return this;
    }

    public RestaurantSupplier addInfoCodesItem(String infoCodesItem) {
        if (this.infoCodes == null) {
            this.infoCodes = new ArrayList<String>();
        }
        this.infoCodes.add(infoCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `RES` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInfoCodes() {
        return this.infoCodes;
    }

    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfoCodes(List<String> infoCodes) {
        this.infoCodes = infoCodes;
    }

    public RestaurantSupplier cuisineCodes(List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
        return this;
    }

    public RestaurantSupplier addCuisineCodesItem(String cuisineCodesItem) {
        if (this.cuisineCodes == null) {
            this.cuisineCodes = new ArrayList<String>();
        }
        this.cuisineCodes.add(cuisineCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `CUI` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCuisineCodes() {
        return this.cuisineCodes;
    }

    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCuisineCodes(List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestaurantSupplier restaurantSupplier = (RestaurantSupplier)o;
        return Objects.equals(this.identifier, restaurantSupplier.identifier) && Objects.equals(this.hotelIdentifier, restaurantSupplier.hotelIdentifier) && Objects.equals(this.featuredInd, restaurantSupplier.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)restaurantSupplier.lifestyleType) && Objects.equals(this.location, restaurantSupplier.location) && Objects.equals(this.descriptions, restaurantSupplier.descriptions) && Objects.equals(this.multimedias, restaurantSupplier.multimedias) && Objects.equals(this.contact, restaurantSupplier.contact) && Objects.equals(this.address, restaurantSupplier.address) && Objects.equals(this.commissionable, restaurantSupplier.commissionable) && Objects.equals(this.name, restaurantSupplier.name) && Objects.equals(this.proximityCode, restaurantSupplier.proximityCode) && Objects.equals(this.sort, restaurantSupplier.sort) && Objects.equals(this.minAgeAppropriateCode, restaurantSupplier.minAgeAppropriateCode) && Objects.equals(this.bookable, restaurantSupplier.bookable) && Objects.equals(this.active, restaurantSupplier.active) && Objects.equals(this.disabilityFeatures, restaurantSupplier.disabilityFeatures) && Objects.equals(this.securityFeatures, restaurantSupplier.securityFeatures) && Objects.equals(this.socials, restaurantSupplier.socials) && Objects.equals((Object)this.pricePoint, (Object)restaurantSupplier.pricePoint) && Objects.equals(this.recognitionList, restaurantSupplier.recognitionList) && Objects.equals(this.transactionalInventoryList, restaurantSupplier.transactionalInventoryList) && Objects.equals(this.applicableStart, restaurantSupplier.applicableStart) && Objects.equals(this.applicableEnd, restaurantSupplier.applicableEnd) && Objects.equals(this.reservationRequiredInd, restaurantSupplier.reservationRequiredInd) && Objects.equals(this.opens, restaurantSupplier.opens) && Objects.equals(this.closes, restaurantSupplier.closes) && Objects.equals(this.daysOfWeek, restaurantSupplier.daysOfWeek) && Objects.equals(this.maxSeatingCapacity, restaurantSupplier.maxSeatingCapacity) && Objects.equals(this.maxSingleParty, restaurantSupplier.maxSingleParty) && Objects.equals(this.offerBreakfast, restaurantSupplier.offerBreakfast) && Objects.equals(this.offerLunch, restaurantSupplier.offerLunch) && Objects.equals(this.offerDinner, restaurantSupplier.offerDinner) && Objects.equals(this.offerBrunch, restaurantSupplier.offerBrunch) && Objects.equals(this.amenities, restaurantSupplier.amenities) && Objects.equals(this.infoCodes, restaurantSupplier.infoCodes) && Objects.equals(this.cuisineCodes, restaurantSupplier.cuisineCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.transactionalInventoryList, this.applicableStart, this.applicableEnd, this.reservationRequiredInd, this.opens, this.closes, this.daysOfWeek, this.maxSeatingCapacity, this.maxSingleParty, this.offerBreakfast, this.offerLunch, this.offerDinner, this.offerBrunch, this.amenities, this.infoCodes, this.cuisineCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestaurantSupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    transactionalInventoryList: ").append(this.toIndentedString(this.transactionalInventoryList)).append("\n");
        sb.append("    applicableStart: ").append(this.toIndentedString(this.applicableStart)).append("\n");
        sb.append("    applicableEnd: ").append(this.toIndentedString(this.applicableEnd)).append("\n");
        sb.append("    reservationRequiredInd: ").append(this.toIndentedString(this.reservationRequiredInd)).append("\n");
        sb.append("    opens: ").append(this.toIndentedString(this.opens)).append("\n");
        sb.append("    closes: ").append(this.toIndentedString(this.closes)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    maxSeatingCapacity: ").append(this.toIndentedString(this.maxSeatingCapacity)).append("\n");
        sb.append("    maxSingleParty: ").append(this.toIndentedString(this.maxSingleParty)).append("\n");
        sb.append("    offerBreakfast: ").append(this.toIndentedString(this.offerBreakfast)).append("\n");
        sb.append("    offerLunch: ").append(this.toIndentedString(this.offerLunch)).append("\n");
        sb.append("    offerDinner: ").append(this.toIndentedString(this.offerDinner)).append("\n");
        sb.append("    offerBrunch: ").append(this.toIndentedString(this.offerBrunch)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    infoCodes: ").append(this.toIndentedString(this.infoCodes)).append("\n");
        sb.append("    cuisineCodes: ").append(this.toIndentedString(this.cuisineCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF("HALF"),
        ONE("ONE"),
        ONE_HALF("ONE_HALF"),
        TWO("TWO"),
        TWO_HALF("TWO_HALF"),
        THREE("THREE"),
        THREE_HALF("THREE_HALF"),
        FOUR("FOUR"),
        FOUR_HALF("FOUR_HALF"),
        FIVE("FIVE");

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

