/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPolygonSupplier;
import travel.wink.sdk.extranet.model.IPLocationSupplier;
import travel.wink.sdk.extranet.model.ItinerarySupplier;
import travel.wink.sdk.extranet.model.RoomConfigurationSupplier;
import travel.wink.sdk.extranet.model.SearchFiltersSupplier;

@ApiModel(description="User session information containing itinerary and other user related data.")
@JsonPropertyOrder(value={"location", "ipLocation", "ipNumber", "bounds", "itinerary", "searchFilters", "language", "currency", "redirectUrl", "userIdentifier", "promotionalCodes", "selectedRoomConfiguration"})
@JsonTypeName(value="UserSession_Supplier")
public class UserSessionSupplier {
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointSupplier location;
    public static final String JSON_PROPERTY_IP_LOCATION = "ipLocation";
    private IPLocationSupplier ipLocation;
    public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
    private String ipNumber;
    public static final String JSON_PROPERTY_BOUNDS = "bounds";
    private GeoJsonPolygonSupplier bounds;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private ItinerarySupplier itinerary;
    public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
    private SearchFiltersSupplier searchFilters;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    private String redirectUrl;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION = "selectedRoomConfiguration";
    private RoomConfigurationSupplier selectedRoomConfiguration;

    public UserSessionSupplier location(GeoJsonPointSupplier location) {
        this.location = location;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPointSupplier getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(GeoJsonPointSupplier location) {
        this.location = location;
    }

    public UserSessionSupplier ipLocation(IPLocationSupplier ipLocation) {
        this.ipLocation = ipLocation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="ipLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IPLocationSupplier getIpLocation() {
        return this.ipLocation;
    }

    @JsonProperty(value="ipLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpLocation(IPLocationSupplier ipLocation) {
        this.ipLocation = ipLocation;
    }

    public UserSessionSupplier ipNumber(String ipNumber) {
        this.ipNumber = ipNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="203.543.122.021", value="User's incoming IP number")
    @JsonProperty(value="ipNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpNumber() {
        return this.ipNumber;
    }

    @JsonProperty(value="ipNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpNumber(String ipNumber) {
        this.ipNumber = ipNumber;
    }

    public UserSessionSupplier bounds(GeoJsonPolygonSupplier bounds) {
        this.bounds = bounds;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPolygonSupplier getBounds() {
        return this.bounds;
    }

    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBounds(GeoJsonPolygonSupplier bounds) {
        this.bounds = bounds;
    }

    public UserSessionSupplier itinerary(ItinerarySupplier itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ItinerarySupplier getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(ItinerarySupplier itinerary) {
        this.itinerary = itinerary;
    }

    public UserSessionSupplier searchFilters(SearchFiltersSupplier searchFilters) {
        this.searchFilters = searchFilters;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchFiltersSupplier getSearchFilters() {
        return this.searchFilters;
    }

    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchFilters(SearchFiltersSupplier searchFilters) {
        this.searchFilters = searchFilters;
    }

    public UserSessionSupplier language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="User's language preference")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public UserSessionSupplier currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="User's currency preference")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public UserSessionSupplier redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public UserSessionSupplier userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Pass along the user identifier if user is known.")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public UserSessionSupplier promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public UserSessionSupplier addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public UserSessionSupplier selectedRoomConfiguration(RoomConfigurationSupplier selectedRoomConfiguration) {
        this.selectedRoomConfiguration = selectedRoomConfiguration;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="selectedRoomConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomConfigurationSupplier getSelectedRoomConfiguration() {
        return this.selectedRoomConfiguration;
    }

    @JsonProperty(value="selectedRoomConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRoomConfiguration(RoomConfigurationSupplier selectedRoomConfiguration) {
        this.selectedRoomConfiguration = selectedRoomConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSessionSupplier userSessionSupplier = (UserSessionSupplier)o;
        return Objects.equals(this.location, userSessionSupplier.location) && Objects.equals(this.ipLocation, userSessionSupplier.ipLocation) && Objects.equals(this.ipNumber, userSessionSupplier.ipNumber) && Objects.equals(this.bounds, userSessionSupplier.bounds) && Objects.equals(this.itinerary, userSessionSupplier.itinerary) && Objects.equals(this.searchFilters, userSessionSupplier.searchFilters) && Objects.equals(this.language, userSessionSupplier.language) && Objects.equals(this.currency, userSessionSupplier.currency) && Objects.equals(this.redirectUrl, userSessionSupplier.redirectUrl) && Objects.equals(this.userIdentifier, userSessionSupplier.userIdentifier) && Objects.equals(this.promotionalCodes, userSessionSupplier.promotionalCodes) && Objects.equals(this.selectedRoomConfiguration, userSessionSupplier.selectedRoomConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.ipLocation, this.ipNumber, this.bounds, this.itinerary, this.searchFilters, this.language, this.currency, this.redirectUrl, this.userIdentifier, this.promotionalCodes, this.selectedRoomConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSessionSupplier {\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    ipLocation: ").append(this.toIndentedString(this.ipLocation)).append("\n");
        sb.append("    ipNumber: ").append(this.toIndentedString(this.ipNumber)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    searchFilters: ").append(this.toIndentedString(this.searchFilters)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    selectedRoomConfiguration: ").append(this.toIndentedString(this.selectedRoomConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

