package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.BookingCancellableSupplier;
import travel.wink.sdk.extranet.model.BookingCountSupplier;
import travel.wink.sdk.extranet.model.BookingViewSupplier;
import travel.wink.sdk.extranet.model.BooleanResponseSupplier;
import travel.wink.sdk.extranet.model.CancellationDetailSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.PageBookingViewSupplier;
import travel.wink.sdk.extranet.model.PropertyBookingRefundRequestSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.StateSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-18T08:52:26.126132332+07:00[Asia/Bangkok]")
public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel Booking
     * Booking is cancelled by the property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param cancellationDetailSupplier The cancellationDetailSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelHotelBookingRequestCreation(String hotelIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetailSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetailSupplier' is set
        if (cancellationDetailSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailSupplier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Booking
     * Booking is cancelled by the property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param cancellationDetailSupplier The cancellationDetailSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewSupplier> cancelHotelBooking(String hotelIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return cancelHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplier>> cancelHotelBookingWithHttpInfo(String hotelIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return cancelHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Is Booking Cancellable
     * Checks to see whether this booking (or group booking) can be cancelled by either the traveler or the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Check if booking can be cancelled for hotel with this identifier
     * @param bookingIdentifier Check if booking can be cancelled with this identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingCancellableSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isBookingCancellableRequestCreation(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/cancellable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Is Booking Cancellable
     * Checks to see whether this booking (or group booking) can be cancelled by either the traveler or the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Check if booking can be cancelled for hotel with this identifier
     * @param bookingIdentifier Check if booking can be cancelled with this identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingCancellableSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingCancellableSupplier> isBookingCancellable(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>() {};
        return isBookingCancellableRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingCancellableSupplier>> isBookingCancellableWithHttpInfo(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>() {};
        return isBookingCancellableRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Request refund
     * Under certain circumstances, a property can request a partial refund of the funds that were attributed to them even after a cancellation occurred or the while the funds have not been disbursed yet.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param propertyBookingRefundRequestSupplier The propertyBookingRefundRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec requestRefundRequestCreation(String hotelIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyBookingRefundRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyBookingRefundRequestSupplier' is set
        if (propertyBookingRefundRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyBookingRefundRequestSupplier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/request-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Request refund
     * Under certain circumstances, a property can request a partial refund of the funds that were attributed to them even after a cancellation occurred or the while the funds have not been disbursed yet.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param propertyBookingRefundRequestSupplier The propertyBookingRefundRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewSupplier> requestRefund(String hotelIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return requestRefundRequestCreation(hotelIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplier>> requestRefundWithHttpInfo(String hotelIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return requestRefundRequestCreation(hotelIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Booking owner
     * @param bookingIdentifier Booking identifier
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec resendBookingConfirmationEmailRequestCreation(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Booking owner
     * @param bookingIdentifier Booking identifier
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseSupplier> resendBookingConfirmationEmail(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>() {};
        return resendBookingConfirmationEmailRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseSupplier>> resendBookingConfirmationEmailWithHttpInfo(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>() {};
        return resendBookingConfirmationEmailRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Active Affiliates
     * Return a geoname list of unique affiliates that have brought the property bookings. This is helpful data you can use to filter on within your dataset.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show active affiliates for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActiveAffiliatesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActiveAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/owner/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Active Affiliates
     * Return a geoname list of unique affiliates that have brought the property bookings. This is helpful data you can use to filter on within your dataset.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show active affiliates for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> showActiveAffiliates(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveAffiliatesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveAffiliatesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveAffiliatesRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Active Master Rates
     * Return a geoname list of unique master rates that have been booked. This is helpful data you can use to filter on within your dataset.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show booked master rates for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActiveMasterRatesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActiveMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/roomrate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Active Master Rates
     * Return a geoname list of unique master rates that have been booked. This is helpful data you can use to filter on within your dataset.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show booked master rates for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> showActiveMasterRates(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveMasterRatesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveMasterRatesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveMasterRatesRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Upcoming Booking Count
     * Retrieve the number of upcoming bookings that arrive today for the specific hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show active booking count for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingCountSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsCountRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showBookingsCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingCountSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCountSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upcoming Booking Count
     * Retrieve the number of upcoming bookings that arrive today for the specific hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show active booking count for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingCountSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingCountSupplier> showBookingsCount(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCountSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCountSupplier>() {};
        return showBookingsCountRequestCreation(hotelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingCountSupplier>> showBookingsCountWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCountSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCountSupplier>() {};
        return showBookingsCountRequestCreation(hotelIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Booking
     * Retrieve a single booking specific by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show booking owned by this hotel
     * @param bookingIdentifier Show booking with this identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelBookingRequestCreation(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a single booking specific by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show booking owned by this hotel
     * @param bookingIdentifier Show booking with this identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewSupplier> showHotelBooking(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return showHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplier>> showHotelBookingWithHttpInfo(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return showHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Bookings Grid
     * Retrieve page of bookings for a specific hotel with advanced filtering rules.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show bookings for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelBookingsRequestCreation(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = stateSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateSupplier' is set
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings Grid
     * Retrieve page of bookings for a specific hotel with advanced filtering rules.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show bookings for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewSupplier> showHotelBookings(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookingsRequestCreation(hotelIdentifier, stateSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookingsWithHttpInfo(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookingsRequestCreation(hotelIdentifier, stateSupplier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Bookings
     * Retrieve bookings for hotel with simple filter rules.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show bookings for hotel with this identifier
     * @param state Filter on the booking state
     * @param pageNumber Paginate booking list
     * @param maxResults Limit number of records to return
     * @param search Filter on email, first or last name to further narrow down the result set
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelBookings1RequestCreation(String hotelIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelBookings1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "pageNumber", pageNumber));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "maxResults", maxResults));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "search", search));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieve bookings for hotel with simple filter rules.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show bookings for hotel with this identifier
     * @param state Filter on the booking state
     * @param pageNumber Paginate booking list
     * @param maxResults Limit number of records to return
     * @param search Filter on email, first or last name to further narrow down the result set
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewSupplier> showHotelBookings1(String hotelIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookings1RequestCreation(hotelIdentifier, state, pageNumber, maxResults, search, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookings1WithHttpInfo(String hotelIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookings1RequestCreation(hotelIdentifier, state, pageNumber, maxResults, search, winkVersion).toEntity(localVarReturnType);
    }
}
