/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 24.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.MoneysSupplierDetails;
import travel.wink.sdk.extranet.model.QuoteSupplierDetails;
import travel.wink.sdk.extranet.model.RateSupplierDetails;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DailyRateSupplierDetails
 */
@JsonPropertyOrder({
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_BASE_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_BASE_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_AVAILABLE,
  DailyRateSupplierDetails.JSON_PROPERTY_IS_START_DATE,
  DailyRateSupplierDetails.JSON_PROPERTY_IS_END_DATE,
  DailyRateSupplierDetails.JSON_PROPERTY_IS_BETWEEN_DATE,
  DailyRateSupplierDetails.JSON_PROPERTY_IS_LAST_NIGHT,
  DailyRateSupplierDetails.JSON_PROPERTY_OFFER_DETAILS,
  DailyRateSupplierDetails.JSON_PROPERTY_HAS_MODIFICATION,
  DailyRateSupplierDetails.JSON_PROPERTY_IS_BUNDLED_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_HAS_CHANNEL_DISCOUNT,
  DailyRateSupplierDetails.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  DailyRateSupplierDetails.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  DailyRateSupplierDetails.JSON_PROPERTY_PREMIUM_PERCENT,
  DailyRateSupplierDetails.JSON_PROPERTY_PROMOTION,
  DailyRateSupplierDetails.JSON_PROPERTY_ADULTS,
  DailyRateSupplierDetails.JSON_PROPERTY_CHILDREN,
  DailyRateSupplierDetails.JSON_PROPERTY_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  DailyRateSupplierDetails.JSON_PROPERTY_PHANTOM,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE,
  DailyRateSupplierDetails.JSON_PROPERTY_DATE,
  DailyRateSupplierDetails.JSON_PROPERTY_END_DATE,
  DailyRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_BASE_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_CLOSE_ON_DEPARTURE,
  DailyRateSupplierDetails.JSON_PROPERTY_INVENTORY_AVAILABLE,
  DailyRateSupplierDetails.JSON_PROPERTY_MASTER_AVAILABILITY,
  DailyRateSupplierDetails.JSON_PROPERTY_CLOSE_ON_ARRIVAL,
  DailyRateSupplierDetails.JSON_PROPERTY_RATE_IDENTIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_START_DATE,
  DailyRateSupplierDetails.JSON_PROPERTY_BETWEEN_DATE,
  DailyRateSupplierDetails.JSON_PROPERTY_LAST_NIGHT,
  DailyRateSupplierDetails.JSON_PROPERTY_BUNDLED_MODIFIER,
  DailyRateSupplierDetails.JSON_PROPERTY_MIN_L_O_S,
  DailyRateSupplierDetails.JSON_PROPERTY_MAX_L_O_S,
  DailyRateSupplierDetails.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT,
  DailyRateSupplierDetails.JSON_PROPERTY_MIN_OCCUPANCY,
  DailyRateSupplierDetails.JSON_PROPERTY_QUANTITY,
  DailyRateSupplierDetails.JSON_PROPERTY_SOURCE_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_INTERNAL_RATE,
  DailyRateSupplierDetails.JSON_PROPERTY_MAX_OCCUPANCY,
  DailyRateSupplierDetails.JSON_PROPERTY_MAX_CHILD_OCCUPANCY
})
@JsonTypeName("DailyRate_SupplierDetails")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-18T08:52:26.126132332+07:00[Asia/Bangkok]")
public class DailyRateSupplierDetails {
  public static final String JSON_PROPERTY_SOURCE_BASE_RATE = "sourceBaseRate";
  private MoneysSupplierDetails sourceBaseRate;

  public static final String JSON_PROPERTY_INTERNAL_BASE_RATE = "internalBaseRate";
  private MoneysSupplierDetails internalBaseRate;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE = "userSpecifiedCurrencyBaseRate";
  private MoneysSupplierDetails userSpecifiedCurrencyBaseRate;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER = "sourceExtraPaxModifier";
  private Double sourceExtraPaxModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER = "internalExtraPaxModifier";
  private Double internalExtraPaxModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER = "userSpecifiedCurrencyExtraPaxModifier";
  private Double userSpecifiedCurrencyExtraPaxModifier;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER = "sourceExtraChildModifier";
  private Double sourceExtraChildModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER = "internalExtraChildModifier";
  private Double internalExtraChildModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER = "userSpecifiedCurrencyExtraChildModifier";
  private Double userSpecifiedCurrencyExtraChildModifier;

  public static final String JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER = "sourceSingleOccupantModifier";
  private Double sourceSingleOccupantModifier;

  public static final String JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER = "internalSingleOccupantModifier";
  private Double internalSingleOccupantModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER = "userSpecifiedCurrencySingleOccupantModifier";
  private Double userSpecifiedCurrencySingleOccupantModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private Double sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private Double internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private Double userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private Double sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private Double internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private Double userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private Double sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private Double internalChannelModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private Double userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_IS_START_DATE = "isStartDate";
  private Boolean isStartDate;

  public static final String JSON_PROPERTY_IS_END_DATE = "isEndDate";
  private Boolean isEndDate;

  public static final String JSON_PROPERTY_IS_BETWEEN_DATE = "isBetweenDate";
  private Boolean isBetweenDate;

  public static final String JSON_PROPERTY_IS_LAST_NIGHT = "isLastNight";
  private Boolean isLastNight;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<SimpleDescriptionSupplierDetails> offerDetails = null;

  public static final String JSON_PROPERTY_HAS_MODIFICATION = "hasModification";
  private Boolean hasModification;

  public static final String JSON_PROPERTY_IS_BUNDLED_MODIFIER = "isBundledModifier";
  private Boolean isBundledModifier;

  public static final String JSON_PROPERTY_HAS_CHANNEL_DISCOUNT = "hasChannelDiscount";
  private Boolean hasChannelDiscount;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_RATE = "rate";
  private RateSupplierDetails rate;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteSupplierDetails sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteSupplierDetails sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_PHANTOM = "phantom";
  private Boolean phantom;

  public static final String JSON_PROPERTY_SOURCE = "source";
  private String source;

  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private Boolean endDate;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE = "userSpecifiedCurrencyRate";
  private MoneysSupplierDetails userSpecifiedCurrencyRate;

  public static final String JSON_PROPERTY_BASE_RATE = "baseRate";
  private MoneysSupplierDetails baseRate;

  public static final String JSON_PROPERTY_CLOSE_ON_DEPARTURE = "closeOnDeparture";
  private Boolean closeOnDeparture;

  public static final String JSON_PROPERTY_INVENTORY_AVAILABLE = "inventoryAvailable";
  private Boolean inventoryAvailable;

  public static final String JSON_PROPERTY_MASTER_AVAILABILITY = "masterAvailability";
  private Boolean masterAvailability;

  public static final String JSON_PROPERTY_CLOSE_ON_ARRIVAL = "closeOnArrival";
  private Boolean closeOnArrival;

  public static final String JSON_PROPERTY_RATE_IDENTIFIER = "rateIdentifier";
  private String rateIdentifier;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private Boolean startDate;

  public static final String JSON_PROPERTY_BETWEEN_DATE = "betweenDate";
  private Boolean betweenDate;

  public static final String JSON_PROPERTY_LAST_NIGHT = "lastNight";
  private Boolean lastNight;

  public static final String JSON_PROPERTY_BUNDLED_MODIFIER = "bundledModifier";
  private Boolean bundledModifier;

  public static final String JSON_PROPERTY_MIN_L_O_S = "minLOS";
  private Integer minLOS;

  public static final String JSON_PROPERTY_MAX_L_O_S = "maxLOS";
  private Integer maxLOS;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_SOURCE_RATE = "sourceRate";
  private MoneysSupplierDetails sourceRate;

  public static final String JSON_PROPERTY_INTERNAL_RATE = "internalRate";
  private MoneysSupplierDetails internalRate;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
  private Integer maxChildOccupancy;

  public DailyRateSupplierDetails() { 
  }

  public DailyRateSupplierDetails sourceBaseRate(MoneysSupplierDetails sourceBaseRate) {
    
    this.sourceBaseRate = sourceBaseRate;
    return this;
  }

   /**
   * Get sourceBaseRate
   * @return sourceBaseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getSourceBaseRate() {
    return sourceBaseRate;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceBaseRate(MoneysSupplierDetails sourceBaseRate) {
    this.sourceBaseRate = sourceBaseRate;
  }


  public DailyRateSupplierDetails internalBaseRate(MoneysSupplierDetails internalBaseRate) {
    
    this.internalBaseRate = internalBaseRate;
    return this;
  }

   /**
   * Get internalBaseRate
   * @return internalBaseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getInternalBaseRate() {
    return internalBaseRate;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalBaseRate(MoneysSupplierDetails internalBaseRate) {
    this.internalBaseRate = internalBaseRate;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencyBaseRate(MoneysSupplierDetails userSpecifiedCurrencyBaseRate) {
    
    this.userSpecifiedCurrencyBaseRate = userSpecifiedCurrencyBaseRate;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseRate
   * @return userSpecifiedCurrencyBaseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getUserSpecifiedCurrencyBaseRate() {
    return userSpecifiedCurrencyBaseRate;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyBaseRate(MoneysSupplierDetails userSpecifiedCurrencyBaseRate) {
    this.userSpecifiedCurrencyBaseRate = userSpecifiedCurrencyBaseRate;
  }


  public DailyRateSupplierDetails sourceExtraPaxModifier(Double sourceExtraPaxModifier) {
    
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
    return this;
  }

   /**
   * Get sourceExtraPaxModifier
   * @return sourceExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceExtraPaxModifier() {
    return sourceExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraPaxModifier(Double sourceExtraPaxModifier) {
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
  }


  public DailyRateSupplierDetails internalExtraPaxModifier(Double internalExtraPaxModifier) {
    
    this.internalExtraPaxModifier = internalExtraPaxModifier;
    return this;
  }

   /**
   * Get internalExtraPaxModifier
   * @return internalExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalExtraPaxModifier() {
    return internalExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraPaxModifier(Double internalExtraPaxModifier) {
    this.internalExtraPaxModifier = internalExtraPaxModifier;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
    
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyExtraPaxModifier
   * @return userSpecifiedCurrencyExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyExtraPaxModifier() {
    return userSpecifiedCurrencyExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
  }


  public DailyRateSupplierDetails sourceExtraChildModifier(Double sourceExtraChildModifier) {
    
    this.sourceExtraChildModifier = sourceExtraChildModifier;
    return this;
  }

   /**
   * Get sourceExtraChildModifier
   * @return sourceExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceExtraChildModifier() {
    return sourceExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraChildModifier(Double sourceExtraChildModifier) {
    this.sourceExtraChildModifier = sourceExtraChildModifier;
  }


  public DailyRateSupplierDetails internalExtraChildModifier(Double internalExtraChildModifier) {
    
    this.internalExtraChildModifier = internalExtraChildModifier;
    return this;
  }

   /**
   * Get internalExtraChildModifier
   * @return internalExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalExtraChildModifier() {
    return internalExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraChildModifier(Double internalExtraChildModifier) {
    this.internalExtraChildModifier = internalExtraChildModifier;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
    
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyExtraChildModifier
   * @return userSpecifiedCurrencyExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyExtraChildModifier() {
    return userSpecifiedCurrencyExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
  }


  public DailyRateSupplierDetails sourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
    
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
    return this;
  }

   /**
   * Get sourceSingleOccupantModifier
   * @return sourceSingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceSingleOccupantModifier() {
    return sourceSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
  }


  public DailyRateSupplierDetails internalSingleOccupantModifier(Double internalSingleOccupantModifier) {
    
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
    return this;
  }

   /**
   * Get internalSingleOccupantModifier
   * @return internalSingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalSingleOccupantModifier() {
    return internalSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalSingleOccupantModifier(Double internalSingleOccupantModifier) {
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
    
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencySingleOccupantModifier
   * @return userSpecifiedCurrencySingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencySingleOccupantModifier() {
    return userSpecifiedCurrencySingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
  }


  public DailyRateSupplierDetails sourcePromotionalModifier(Double sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Get sourcePromotionalModifier
   * @return sourcePromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public DailyRateSupplierDetails internalPromotionalModifier(Double internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Get internalPromotionalModifier
   * @return internalPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyPromotionalModifier
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public DailyRateSupplierDetails sourcePremiumModifier(Double sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Get sourcePremiumModifier
   * @return sourcePremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(Double sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public DailyRateSupplierDetails internalPremiumModifier(Double internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Get internalPremiumModifier
   * @return internalPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(Double internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyPremiumModifier
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public DailyRateSupplierDetails sourceChannelModifier(Double sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Get sourceChannelModifier
   * @return sourceChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(Double sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public DailyRateSupplierDetails internalChannelModifier(Double internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Get internalChannelModifier
   * @return internalChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(Double internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyChannelModifier
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public DailyRateSupplierDetails available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public DailyRateSupplierDetails isStartDate(Boolean isStartDate) {
    
    this.isStartDate = isStartDate;
    return this;
  }

   /**
   * Get isStartDate
   * @return isStartDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsStartDate() {
    return isStartDate;
  }


  @JsonProperty(JSON_PROPERTY_IS_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsStartDate(Boolean isStartDate) {
    this.isStartDate = isStartDate;
  }


  public DailyRateSupplierDetails isEndDate(Boolean isEndDate) {
    
    this.isEndDate = isEndDate;
    return this;
  }

   /**
   * Get isEndDate
   * @return isEndDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsEndDate() {
    return isEndDate;
  }


  @JsonProperty(JSON_PROPERTY_IS_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsEndDate(Boolean isEndDate) {
    this.isEndDate = isEndDate;
  }


  public DailyRateSupplierDetails isBetweenDate(Boolean isBetweenDate) {
    
    this.isBetweenDate = isBetweenDate;
    return this;
  }

   /**
   * Get isBetweenDate
   * @return isBetweenDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_BETWEEN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsBetweenDate() {
    return isBetweenDate;
  }


  @JsonProperty(JSON_PROPERTY_IS_BETWEEN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsBetweenDate(Boolean isBetweenDate) {
    this.isBetweenDate = isBetweenDate;
  }


  public DailyRateSupplierDetails isLastNight(Boolean isLastNight) {
    
    this.isLastNight = isLastNight;
    return this;
  }

   /**
   * Get isLastNight
   * @return isLastNight
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_LAST_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsLastNight() {
    return isLastNight;
  }


  @JsonProperty(JSON_PROPERTY_IS_LAST_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsLastNight(Boolean isLastNight) {
    this.isLastNight = isLastNight;
  }


  public DailyRateSupplierDetails offerDetails(List<SimpleDescriptionSupplierDetails> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public DailyRateSupplierDetails addOfferDetailsItem(SimpleDescriptionSupplierDetails offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Get offerDetails
   * @return offerDetails
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescriptionSupplierDetails> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<SimpleDescriptionSupplierDetails> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public DailyRateSupplierDetails hasModification(Boolean hasModification) {
    
    this.hasModification = hasModification;
    return this;
  }

   /**
   * Get hasModification
   * @return hasModification
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HAS_MODIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasModification() {
    return hasModification;
  }


  @JsonProperty(JSON_PROPERTY_HAS_MODIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasModification(Boolean hasModification) {
    this.hasModification = hasModification;
  }


  public DailyRateSupplierDetails isBundledModifier(Boolean isBundledModifier) {
    
    this.isBundledModifier = isBundledModifier;
    return this;
  }

   /**
   * Get isBundledModifier
   * @return isBundledModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IS_BUNDLED_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsBundledModifier() {
    return isBundledModifier;
  }


  @JsonProperty(JSON_PROPERTY_IS_BUNDLED_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsBundledModifier(Boolean isBundledModifier) {
    this.isBundledModifier = isBundledModifier;
  }


  public DailyRateSupplierDetails hasChannelDiscount(Boolean hasChannelDiscount) {
    
    this.hasChannelDiscount = hasChannelDiscount;
    return this;
  }

   /**
   * Get hasChannelDiscount
   * @return hasChannelDiscount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasChannelDiscount() {
    return hasChannelDiscount;
  }


  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasChannelDiscount(Boolean hasChannelDiscount) {
    this.hasChannelDiscount = hasChannelDiscount;
  }


  public DailyRateSupplierDetails channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Get channelDiscountPercent
   * @return channelDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public DailyRateSupplierDetails promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Get promotionalDiscountPercent
   * @return promotionalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public DailyRateSupplierDetails premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Get premiumPercent
   * @return premiumPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public DailyRateSupplierDetails promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * Get promotion
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  public DailyRateSupplierDetails adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Get adults
   * @return adults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public DailyRateSupplierDetails children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public DailyRateSupplierDetails rate(RateSupplierDetails rate) {
    
    this.rate = rate;
    return this;
  }

   /**
   * Get rate
   * @return rate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RateSupplierDetails getRate() {
    return rate;
  }


  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRate(RateSupplierDetails rate) {
    this.rate = rate;
  }


  public DailyRateSupplierDetails sourceToUserCurrencyQuote(QuoteSupplierDetails sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplierDetails getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToUserCurrencyQuote(QuoteSupplierDetails sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public DailyRateSupplierDetails sourceToInternalCurrencyQuote(QuoteSupplierDetails sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplierDetails getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToInternalCurrencyQuote(QuoteSupplierDetails sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public DailyRateSupplierDetails phantom(Boolean phantom) {
    
    this.phantom = phantom;
    return this;
  }

   /**
   * Get phantom
   * @return phantom
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PHANTOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPhantom() {
    return phantom;
  }


  @JsonProperty(JSON_PROPERTY_PHANTOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPhantom(Boolean phantom) {
    this.phantom = phantom;
  }


  public DailyRateSupplierDetails source(String source) {
    
    this.source = source;
    return this;
  }

   /**
   * Get source
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(String source) {
    this.source = source;
  }


  public DailyRateSupplierDetails date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * Get date
   * @return date
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  public DailyRateSupplierDetails endDate(Boolean endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(Boolean endDate) {
    this.endDate = endDate;
  }


  public DailyRateSupplierDetails userSpecifiedCurrencyRate(MoneysSupplierDetails userSpecifiedCurrencyRate) {
    
    this.userSpecifiedCurrencyRate = userSpecifiedCurrencyRate;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyRate
   * @return userSpecifiedCurrencyRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getUserSpecifiedCurrencyRate() {
    return userSpecifiedCurrencyRate;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyRate(MoneysSupplierDetails userSpecifiedCurrencyRate) {
    this.userSpecifiedCurrencyRate = userSpecifiedCurrencyRate;
  }


  public DailyRateSupplierDetails baseRate(MoneysSupplierDetails baseRate) {
    
    this.baseRate = baseRate;
    return this;
  }

   /**
   * Get baseRate
   * @return baseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getBaseRate() {
    return baseRate;
  }


  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseRate(MoneysSupplierDetails baseRate) {
    this.baseRate = baseRate;
  }


  public DailyRateSupplierDetails closeOnDeparture(Boolean closeOnDeparture) {
    
    this.closeOnDeparture = closeOnDeparture;
    return this;
  }

   /**
   * Get closeOnDeparture
   * @return closeOnDeparture
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLOSE_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCloseOnDeparture() {
    return closeOnDeparture;
  }


  @JsonProperty(JSON_PROPERTY_CLOSE_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloseOnDeparture(Boolean closeOnDeparture) {
    this.closeOnDeparture = closeOnDeparture;
  }


  public DailyRateSupplierDetails inventoryAvailable(Boolean inventoryAvailable) {
    
    this.inventoryAvailable = inventoryAvailable;
    return this;
  }

   /**
   * Get inventoryAvailable
   * @return inventoryAvailable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INVENTORY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getInventoryAvailable() {
    return inventoryAvailable;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryAvailable(Boolean inventoryAvailable) {
    this.inventoryAvailable = inventoryAvailable;
  }


  public DailyRateSupplierDetails masterAvailability(Boolean masterAvailability) {
    
    this.masterAvailability = masterAvailability;
    return this;
  }

   /**
   * Get masterAvailability
   * @return masterAvailability
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MASTER_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMasterAvailability() {
    return masterAvailability;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterAvailability(Boolean masterAvailability) {
    this.masterAvailability = masterAvailability;
  }


  public DailyRateSupplierDetails closeOnArrival(Boolean closeOnArrival) {
    
    this.closeOnArrival = closeOnArrival;
    return this;
  }

   /**
   * Get closeOnArrival
   * @return closeOnArrival
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLOSE_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCloseOnArrival() {
    return closeOnArrival;
  }


  @JsonProperty(JSON_PROPERTY_CLOSE_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloseOnArrival(Boolean closeOnArrival) {
    this.closeOnArrival = closeOnArrival;
  }


  public DailyRateSupplierDetails rateIdentifier(String rateIdentifier) {
    
    this.rateIdentifier = rateIdentifier;
    return this;
  }

   /**
   * Get rateIdentifier
   * @return rateIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateIdentifier() {
    return rateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateIdentifier(String rateIdentifier) {
    this.rateIdentifier = rateIdentifier;
  }


  public DailyRateSupplierDetails startDate(Boolean startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(Boolean startDate) {
    this.startDate = startDate;
  }


  public DailyRateSupplierDetails betweenDate(Boolean betweenDate) {
    
    this.betweenDate = betweenDate;
    return this;
  }

   /**
   * Get betweenDate
   * @return betweenDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BETWEEN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBetweenDate() {
    return betweenDate;
  }


  @JsonProperty(JSON_PROPERTY_BETWEEN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBetweenDate(Boolean betweenDate) {
    this.betweenDate = betweenDate;
  }


  public DailyRateSupplierDetails lastNight(Boolean lastNight) {
    
    this.lastNight = lastNight;
    return this;
  }

   /**
   * Get lastNight
   * @return lastNight
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LAST_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLastNight() {
    return lastNight;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastNight(Boolean lastNight) {
    this.lastNight = lastNight;
  }


  public DailyRateSupplierDetails bundledModifier(Boolean bundledModifier) {
    
    this.bundledModifier = bundledModifier;
    return this;
  }

   /**
   * Get bundledModifier
   * @return bundledModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BUNDLED_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBundledModifier() {
    return bundledModifier;
  }


  @JsonProperty(JSON_PROPERTY_BUNDLED_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBundledModifier(Boolean bundledModifier) {
    this.bundledModifier = bundledModifier;
  }


  public DailyRateSupplierDetails minLOS(Integer minLOS) {
    
    this.minLOS = minLOS;
    return this;
  }

   /**
   * Get minLOS
   * @return minLOS
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLOS() {
    return minLOS;
  }


  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLOS(Integer minLOS) {
    this.minLOS = minLOS;
  }


  public DailyRateSupplierDetails maxLOS(Integer maxLOS) {
    
    this.maxLOS = maxLOS;
    return this;
  }

   /**
   * Get maxLOS
   * @return maxLOS
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLOS() {
    return maxLOS;
  }


  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLOS(Integer maxLOS) {
    this.maxLOS = maxLOS;
  }


  public DailyRateSupplierDetails totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }


  public DailyRateSupplierDetails minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Get minOccupancy
   * @return minOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public DailyRateSupplierDetails quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public DailyRateSupplierDetails sourceRate(MoneysSupplierDetails sourceRate) {
    
    this.sourceRate = sourceRate;
    return this;
  }

   /**
   * Get sourceRate
   * @return sourceRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getSourceRate() {
    return sourceRate;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceRate(MoneysSupplierDetails sourceRate) {
    this.sourceRate = sourceRate;
  }


  public DailyRateSupplierDetails internalRate(MoneysSupplierDetails internalRate) {
    
    this.internalRate = internalRate;
    return this;
  }

   /**
   * Get internalRate
   * @return internalRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getInternalRate() {
    return internalRate;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalRate(MoneysSupplierDetails internalRate) {
    this.internalRate = internalRate;
  }


  public DailyRateSupplierDetails maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Get maxOccupancy
   * @return maxOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public DailyRateSupplierDetails maxChildOccupancy(Integer maxChildOccupancy) {
    
    this.maxChildOccupancy = maxChildOccupancy;
    return this;
  }

   /**
   * Get maxChildOccupancy
   * @return maxChildOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxChildOccupancy() {
    return maxChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxChildOccupancy(Integer maxChildOccupancy) {
    this.maxChildOccupancy = maxChildOccupancy;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DailyRateSupplierDetails dailyRateSupplierDetails = (DailyRateSupplierDetails) o;
    return Objects.equals(this.sourceBaseRate, dailyRateSupplierDetails.sourceBaseRate) &&
        Objects.equals(this.internalBaseRate, dailyRateSupplierDetails.internalBaseRate) &&
        Objects.equals(this.userSpecifiedCurrencyBaseRate, dailyRateSupplierDetails.userSpecifiedCurrencyBaseRate) &&
        Objects.equals(this.sourceExtraPaxModifier, dailyRateSupplierDetails.sourceExtraPaxModifier) &&
        Objects.equals(this.internalExtraPaxModifier, dailyRateSupplierDetails.internalExtraPaxModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraPaxModifier, dailyRateSupplierDetails.userSpecifiedCurrencyExtraPaxModifier) &&
        Objects.equals(this.sourceExtraChildModifier, dailyRateSupplierDetails.sourceExtraChildModifier) &&
        Objects.equals(this.internalExtraChildModifier, dailyRateSupplierDetails.internalExtraChildModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraChildModifier, dailyRateSupplierDetails.userSpecifiedCurrencyExtraChildModifier) &&
        Objects.equals(this.sourceSingleOccupantModifier, dailyRateSupplierDetails.sourceSingleOccupantModifier) &&
        Objects.equals(this.internalSingleOccupantModifier, dailyRateSupplierDetails.internalSingleOccupantModifier) &&
        Objects.equals(this.userSpecifiedCurrencySingleOccupantModifier, dailyRateSupplierDetails.userSpecifiedCurrencySingleOccupantModifier) &&
        Objects.equals(this.sourcePromotionalModifier, dailyRateSupplierDetails.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, dailyRateSupplierDetails.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, dailyRateSupplierDetails.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePremiumModifier, dailyRateSupplierDetails.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, dailyRateSupplierDetails.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, dailyRateSupplierDetails.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourceChannelModifier, dailyRateSupplierDetails.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, dailyRateSupplierDetails.internalChannelModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, dailyRateSupplierDetails.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.available, dailyRateSupplierDetails.available) &&
        Objects.equals(this.isStartDate, dailyRateSupplierDetails.isStartDate) &&
        Objects.equals(this.isEndDate, dailyRateSupplierDetails.isEndDate) &&
        Objects.equals(this.isBetweenDate, dailyRateSupplierDetails.isBetweenDate) &&
        Objects.equals(this.isLastNight, dailyRateSupplierDetails.isLastNight) &&
        Objects.equals(this.offerDetails, dailyRateSupplierDetails.offerDetails) &&
        Objects.equals(this.hasModification, dailyRateSupplierDetails.hasModification) &&
        Objects.equals(this.isBundledModifier, dailyRateSupplierDetails.isBundledModifier) &&
        Objects.equals(this.hasChannelDiscount, dailyRateSupplierDetails.hasChannelDiscount) &&
        Objects.equals(this.channelDiscountPercent, dailyRateSupplierDetails.channelDiscountPercent) &&
        Objects.equals(this.promotionalDiscountPercent, dailyRateSupplierDetails.promotionalDiscountPercent) &&
        Objects.equals(this.premiumPercent, dailyRateSupplierDetails.premiumPercent) &&
        Objects.equals(this.promotion, dailyRateSupplierDetails.promotion) &&
        Objects.equals(this.adults, dailyRateSupplierDetails.adults) &&
        Objects.equals(this.children, dailyRateSupplierDetails.children) &&
        Objects.equals(this.rate, dailyRateSupplierDetails.rate) &&
        Objects.equals(this.sourceToUserCurrencyQuote, dailyRateSupplierDetails.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, dailyRateSupplierDetails.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.phantom, dailyRateSupplierDetails.phantom) &&
        Objects.equals(this.source, dailyRateSupplierDetails.source) &&
        Objects.equals(this.date, dailyRateSupplierDetails.date) &&
        Objects.equals(this.endDate, dailyRateSupplierDetails.endDate) &&
        Objects.equals(this.userSpecifiedCurrencyRate, dailyRateSupplierDetails.userSpecifiedCurrencyRate) &&
        Objects.equals(this.baseRate, dailyRateSupplierDetails.baseRate) &&
        Objects.equals(this.closeOnDeparture, dailyRateSupplierDetails.closeOnDeparture) &&
        Objects.equals(this.inventoryAvailable, dailyRateSupplierDetails.inventoryAvailable) &&
        Objects.equals(this.masterAvailability, dailyRateSupplierDetails.masterAvailability) &&
        Objects.equals(this.closeOnArrival, dailyRateSupplierDetails.closeOnArrival) &&
        Objects.equals(this.rateIdentifier, dailyRateSupplierDetails.rateIdentifier) &&
        Objects.equals(this.startDate, dailyRateSupplierDetails.startDate) &&
        Objects.equals(this.betweenDate, dailyRateSupplierDetails.betweenDate) &&
        Objects.equals(this.lastNight, dailyRateSupplierDetails.lastNight) &&
        Objects.equals(this.bundledModifier, dailyRateSupplierDetails.bundledModifier) &&
        Objects.equals(this.minLOS, dailyRateSupplierDetails.minLOS) &&
        Objects.equals(this.maxLOS, dailyRateSupplierDetails.maxLOS) &&
        Objects.equals(this.totalDiscountPercent, dailyRateSupplierDetails.totalDiscountPercent) &&
        Objects.equals(this.minOccupancy, dailyRateSupplierDetails.minOccupancy) &&
        Objects.equals(this.quantity, dailyRateSupplierDetails.quantity) &&
        Objects.equals(this.sourceRate, dailyRateSupplierDetails.sourceRate) &&
        Objects.equals(this.internalRate, dailyRateSupplierDetails.internalRate) &&
        Objects.equals(this.maxOccupancy, dailyRateSupplierDetails.maxOccupancy) &&
        Objects.equals(this.maxChildOccupancy, dailyRateSupplierDetails.maxChildOccupancy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceBaseRate, internalBaseRate, userSpecifiedCurrencyBaseRate, sourceExtraPaxModifier, internalExtraPaxModifier, userSpecifiedCurrencyExtraPaxModifier, sourceExtraChildModifier, internalExtraChildModifier, userSpecifiedCurrencyExtraChildModifier, sourceSingleOccupantModifier, internalSingleOccupantModifier, userSpecifiedCurrencySingleOccupantModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPromotionalModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyPremiumModifier, sourceChannelModifier, internalChannelModifier, userSpecifiedCurrencyChannelModifier, available, isStartDate, isEndDate, isBetweenDate, isLastNight, offerDetails, hasModification, isBundledModifier, hasChannelDiscount, channelDiscountPercent, promotionalDiscountPercent, premiumPercent, promotion, adults, children, rate, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, phantom, source, date, endDate, userSpecifiedCurrencyRate, baseRate, closeOnDeparture, inventoryAvailable, masterAvailability, closeOnArrival, rateIdentifier, startDate, betweenDate, lastNight, bundledModifier, minLOS, maxLOS, totalDiscountPercent, minOccupancy, quantity, sourceRate, internalRate, maxOccupancy, maxChildOccupancy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DailyRateSupplierDetails {\n");
    sb.append("    sourceBaseRate: ").append(toIndentedString(sourceBaseRate)).append("\n");
    sb.append("    internalBaseRate: ").append(toIndentedString(internalBaseRate)).append("\n");
    sb.append("    userSpecifiedCurrencyBaseRate: ").append(toIndentedString(userSpecifiedCurrencyBaseRate)).append("\n");
    sb.append("    sourceExtraPaxModifier: ").append(toIndentedString(sourceExtraPaxModifier)).append("\n");
    sb.append("    internalExtraPaxModifier: ").append(toIndentedString(internalExtraPaxModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraPaxModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraPaxModifier)).append("\n");
    sb.append("    sourceExtraChildModifier: ").append(toIndentedString(sourceExtraChildModifier)).append("\n");
    sb.append("    internalExtraChildModifier: ").append(toIndentedString(internalExtraChildModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraChildModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraChildModifier)).append("\n");
    sb.append("    sourceSingleOccupantModifier: ").append(toIndentedString(sourceSingleOccupantModifier)).append("\n");
    sb.append("    internalSingleOccupantModifier: ").append(toIndentedString(internalSingleOccupantModifier)).append("\n");
    sb.append("    userSpecifiedCurrencySingleOccupantModifier: ").append(toIndentedString(userSpecifiedCurrencySingleOccupantModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    isStartDate: ").append(toIndentedString(isStartDate)).append("\n");
    sb.append("    isEndDate: ").append(toIndentedString(isEndDate)).append("\n");
    sb.append("    isBetweenDate: ").append(toIndentedString(isBetweenDate)).append("\n");
    sb.append("    isLastNight: ").append(toIndentedString(isLastNight)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    hasModification: ").append(toIndentedString(hasModification)).append("\n");
    sb.append("    isBundledModifier: ").append(toIndentedString(isBundledModifier)).append("\n");
    sb.append("    hasChannelDiscount: ").append(toIndentedString(hasChannelDiscount)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    phantom: ").append(toIndentedString(phantom)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    userSpecifiedCurrencyRate: ").append(toIndentedString(userSpecifiedCurrencyRate)).append("\n");
    sb.append("    baseRate: ").append(toIndentedString(baseRate)).append("\n");
    sb.append("    closeOnDeparture: ").append(toIndentedString(closeOnDeparture)).append("\n");
    sb.append("    inventoryAvailable: ").append(toIndentedString(inventoryAvailable)).append("\n");
    sb.append("    masterAvailability: ").append(toIndentedString(masterAvailability)).append("\n");
    sb.append("    closeOnArrival: ").append(toIndentedString(closeOnArrival)).append("\n");
    sb.append("    rateIdentifier: ").append(toIndentedString(rateIdentifier)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    betweenDate: ").append(toIndentedString(betweenDate)).append("\n");
    sb.append("    lastNight: ").append(toIndentedString(lastNight)).append("\n");
    sb.append("    bundledModifier: ").append(toIndentedString(bundledModifier)).append("\n");
    sb.append("    minLOS: ").append(toIndentedString(minLOS)).append("\n");
    sb.append("    maxLOS: ").append(toIndentedString(maxLOS)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    sourceRate: ").append(toIndentedString(sourceRate)).append("\n");
    sb.append("    internalRate: ").append(toIndentedString(internalRate)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    maxChildOccupancy: ").append(toIndentedString(maxChildOccupancy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

