/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.MoneysSupplier;

@JsonPropertyOrder(value={"startDate", "endDate", "rateSource", "master", "closedOnArrival", "closedOnDeparture", "numberOfUnits", "rate", "minLengthOfStay", "maxLengthOfStay"})
@JsonTypeName(value="DailyRateUpdate_Supplier")
public class DailyRateUpdateSupplier {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private String rateSource = "TRAVELIKO";
    public static final String JSON_PROPERTY_MASTER = "master";
    private Boolean master = true;
    public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
    private Boolean closedOnArrival = false;
    public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
    private Boolean closedOnDeparture = false;
    public static final String JSON_PROPERTY_NUMBER_OF_UNITS = "numberOfUnits";
    private Integer numberOfUnits;
    public static final String JSON_PROPERTY_RATE = "rate";
    private MoneysSupplier rate;
    public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
    private Integer minLengthOfStay;
    public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
    private Integer maxLengthOfStay;

    public DailyRateUpdateSupplier startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Mon Aug 24 07:00:00 ICT 2020", required=true, value="Start date for where you want to begin updating rates")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public DailyRateUpdateSupplier endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Wed Aug 26 07:00:00 ICT 2020", required=true, value="End date for where you want to stop updating rates")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public DailyRateUpdateSupplier rateSource(String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="TRAVELIKO", required=true, value="Indicate where this rate originated from. Leave as TRAVELIKO unless you are a channel manager and responsible for the property's rates externally of this payment.")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRateSource(String rateSource) {
        this.rateSource = rateSource;
    }

    public DailyRateUpdateSupplier master(Boolean master) {
        this.master = master;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="This flag indicates whether this rate is available for this date.")
    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getMaster() {
        return this.master;
    }

    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaster(Boolean master) {
        this.master = master;
    }

    public DailyRateUpdateSupplier closedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="This flag indicates whether a guest can arrive at the property on this date.")
    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnArrival() {
        return this.closedOnArrival;
    }

    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
    }

    public DailyRateUpdateSupplier closedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="This flag indicates whether a guest can leave the property on this date.")
    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnDeparture() {
        return this.closedOnDeparture;
    }

    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
    }

    public DailyRateUpdateSupplier numberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Update the amount of rooms available for this date range. Leave empty if you don't want to update this property.")
    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfUnits() {
        return this.numberOfUnits;
    }

    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public DailyRateUpdateSupplier rate(MoneysSupplier rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getRate() {
        return this.rate;
    }

    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRate(MoneysSupplier rate) {
        this.rate = rate;
    }

    public DailyRateUpdateSupplier minLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="Control the minimum length of stay at the day-level. This means that a guest arriving within this date range is required to stay at least these number of days in order to get this rate. Leave empty if you don't want to update this property.")
    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLengthOfStay() {
        return this.minLengthOfStay;
    }

    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
    }

    public DailyRateUpdateSupplier maxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8", value="Control the maximum length of stay at the day-level. This means that a guest arriving within this date range is required to stay no longer than these number of days in order to get this rate. Leave empty if you don't want to update this property.")
    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLengthOfStay() {
        return this.maxLengthOfStay;
    }

    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyRateUpdateSupplier dailyRateUpdateSupplier = (DailyRateUpdateSupplier)o;
        return Objects.equals(this.startDate, dailyRateUpdateSupplier.startDate) && Objects.equals(this.endDate, dailyRateUpdateSupplier.endDate) && Objects.equals(this.rateSource, dailyRateUpdateSupplier.rateSource) && Objects.equals(this.master, dailyRateUpdateSupplier.master) && Objects.equals(this.closedOnArrival, dailyRateUpdateSupplier.closedOnArrival) && Objects.equals(this.closedOnDeparture, dailyRateUpdateSupplier.closedOnDeparture) && Objects.equals(this.numberOfUnits, dailyRateUpdateSupplier.numberOfUnits) && Objects.equals(this.rate, dailyRateUpdateSupplier.rate) && Objects.equals(this.minLengthOfStay, dailyRateUpdateSupplier.minLengthOfStay) && Objects.equals(this.maxLengthOfStay, dailyRateUpdateSupplier.maxLengthOfStay);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.rateSource, this.master, this.closedOnArrival, this.closedOnDeparture, this.numberOfUnits, this.rate, this.minLengthOfStay, this.maxLengthOfStay);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyRateUpdateSupplier {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    master: ").append(this.toIndentedString(this.master)).append("\n");
        sb.append("    closedOnArrival: ").append(this.toIndentedString(this.closedOnArrival)).append("\n");
        sb.append("    closedOnDeparture: ").append(this.toIndentedString(this.closedOnDeparture)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    minLengthOfStay: ").append(this.toIndentedString(this.minLengthOfStay)).append("\n");
        sb.append("    maxLengthOfStay: ").append(this.toIndentedString(this.maxLengthOfStay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

