/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.extranet.model.LocalizedPriceSupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;

@ApiModel(description="This is one localized bookable item that can stand alongside a restaurant / meeting room etc.")
@JsonPropertyOrder(value={"identifier", "name", "descriptions", "pricingType", "price", "multimedias", "minPax", "maxPax", "offerDetails", "promotion"})
@JsonTypeName(value="LocalizedTransactionalTravelInventory_Supplier")
public class LocalizedTransactionalTravelInventorySupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_PRICE = "price";
    private LocalizedPriceSupplier price;
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaSupplier> multimedias = new ArrayList<SimpleMultimediaSupplier>();
    public static final String JSON_PROPERTY_MIN_PAX = "minPax";
    private Integer minPax;
    public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
    private Integer maxPax;
    public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
    private List<SimpleDescriptionSupplier> offerDetails = null;
    public static final String JSON_PROPERTY_PROMOTION = "promotion";
    private String promotion;

    public LocalizedTransactionalTravelInventorySupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique transactional identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public LocalizedTransactionalTravelInventorySupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1 hour session", required=true, value="Internal name of transactional inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public LocalizedTransactionalTravelInventorySupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public LocalizedTransactionalTravelInventorySupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public LocalizedTransactionalTravelInventorySupplier pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="How this inventory item should be priced.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public LocalizedTransactionalTravelInventorySupplier price(LocalizedPriceSupplier price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalizedPriceSupplier getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(LocalizedPriceSupplier price) {
        this.price = price;
    }

    public LocalizedTransactionalTravelInventorySupplier multimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public LocalizedTransactionalTravelInventorySupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of item.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimediaSupplier> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
    }

    public LocalizedTransactionalTravelInventorySupplier minPax(Integer minPax) {
        this.minPax = minPax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Whether there is a limit to minimum group size.")
    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinPax() {
        return this.minPax;
    }

    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinPax(Integer minPax) {
        this.minPax = minPax;
    }

    public LocalizedTransactionalTravelInventorySupplier maxPax(Integer maxPax) {
        this.maxPax = maxPax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Whether there is a limit to maximum group size.")
    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxPax() {
        return this.maxPax;
    }

    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxPax(Integer maxPax) {
        this.maxPax = maxPax;
    }

    public LocalizedTransactionalTravelInventorySupplier offerDetails(List<SimpleDescriptionSupplier> offerDetails) {
        this.offerDetails = offerDetails;
        return this;
    }

    public LocalizedTransactionalTravelInventorySupplier addOfferDetailsItem(SimpleDescriptionSupplier offerDetailsItem) {
        if (this.offerDetails == null) {
            this.offerDetails = new ArrayList<SimpleDescriptionSupplier>();
        }
        this.offerDetails.add(offerDetailsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Localized offer details if rate plan discount applies.")
    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescriptionSupplier> getOfferDetails() {
        return this.offerDetails;
    }

    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOfferDetails(List<SimpleDescriptionSupplier> offerDetails) {
        this.offerDetails = offerDetails;
    }

    public LocalizedTransactionalTravelInventorySupplier promotion(String promotion) {
        this.promotion = promotion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If a package is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the package.")
    @JsonProperty(value="promotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPromotion() {
        return this.promotion;
    }

    @JsonProperty(value="promotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotion(String promotion) {
        this.promotion = promotion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedTransactionalTravelInventorySupplier localizedTransactionalTravelInventorySupplier = (LocalizedTransactionalTravelInventorySupplier)o;
        return Objects.equals(this.identifier, localizedTransactionalTravelInventorySupplier.identifier) && Objects.equals(this.name, localizedTransactionalTravelInventorySupplier.name) && Objects.equals(this.descriptions, localizedTransactionalTravelInventorySupplier.descriptions) && Objects.equals((Object)this.pricingType, (Object)localizedTransactionalTravelInventorySupplier.pricingType) && Objects.equals(this.price, localizedTransactionalTravelInventorySupplier.price) && Objects.equals(this.multimedias, localizedTransactionalTravelInventorySupplier.multimedias) && Objects.equals(this.minPax, localizedTransactionalTravelInventorySupplier.minPax) && Objects.equals(this.maxPax, localizedTransactionalTravelInventorySupplier.maxPax) && Objects.equals(this.offerDetails, localizedTransactionalTravelInventorySupplier.offerDetails) && Objects.equals(this.promotion, localizedTransactionalTravelInventorySupplier.promotion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.descriptions, this.pricingType, this.price, this.multimedias, this.minPax, this.maxPax, this.offerDetails, this.promotion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocalizedTransactionalTravelInventorySupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    minPax: ").append(this.toIndentedString(this.minPax)).append("\n");
        sb.append("    maxPax: ").append(this.toIndentedString(this.maxPax)).append("\n");
        sb.append("    offerDetails: ").append(this.toIndentedString(this.offerDetails)).append("\n");
        sb.append("    promotion: ").append(this.toIndentedString(this.promotion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

